/*
 * Decompiled with CFR 0.152.
 */
package io.github.siculo.sbtbom;

import com.github.packageurl.PackageURL;
import io.github.siculo.sbtbom.BomExtractorParams;
import io.github.siculo.sbtbom.model.License;
import java.io.Serializable;
import java.util.TreeMap;
import java.util.UUID;
import org.cyclonedx.Version;
import org.cyclonedx.model.Bom;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.LicenseChoice;
import sbt.librarymanagement.ConfigRef$;
import sbt.librarymanagement.Configuration;
import sbt.librarymanagement.ModuleReport;
import sbt.librarymanagement.UpdateReport;
import sbt.package$;
import sbt.util.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001B\t\u0013\u0001mA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\tO\u0001\u0011\t\u0011)A\u0005Q!Aq\u0007\u0001B\u0001B\u0003%\u0001\bC\u0003<\u0001\u0011\u0005A\bC\u0004B\u0001\t\u0007I\u0011\u0002\"\t\r-\u0003\u0001\u0015!\u0003D\u0011\u0015a\u0005\u0001\"\u0001N\u0011\u0015A\u0006\u0001\"\u0003Z\u0011\u0015)\u0007\u0001\"\u0003g\u0011\u0015i\u0007\u0001\"\u0003o\r\u0011\u0001\b\u0001A9\t\u0011I\\!\u0011!Q\u0001\nMDQaO\u0006\u0005\u0002eDQ!`\u0006\u0005\u0002yDaa`\u0006\u0005\n\u0005\u0005\u0001bBA\b\u0001\u0011%\u0011\u0011\u0003\u0002\r\u0005>lW\t\u001f;sC\u000e$xN\u001d\u0006\u0003'Q\taa\u001d2uE>l'BA\u000b\u0017\u0003\u0019\u0019\u0018nY;m_*\u0011q\u0003G\u0001\u0007O&$\b.\u001e2\u000b\u0003e\t!![8\u0004\u0001M\u0011\u0001\u0001\b\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0007\u0003:L(+\u001a4\u0002\u0011M,G\u000f^5oON\u0004\"\u0001J\u0013\u000e\u0003II!A\n\n\u0003%\t{W.\u0012=ue\u0006\u001cGo\u001c:QCJ\fWn]\u0001\u0007e\u0016\u0004xN\u001d;\u0011\u0005%\u001adB\u0001\u00161\u001d\tYc&D\u0001-\u0015\ti#$\u0001\u0004=e>|GOP\u0005\u0002_\u0005\u00191O\u0019;\n\u0005E\u0012\u0014a\u00029bG.\fw-\u001a\u0006\u0002_%\u0011A'\u000e\u0002\r+B$\u0017\r^3SKB|'\u000f^\u0005\u0003mI\u0012a!S7q_J$\u0018a\u00017pOB\u0011\u0011&O\u0005\u0003uU\u0012a\u0001T8hO\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u0003>}}\u0002\u0005C\u0001\u0013\u0001\u0011\u0015\u0011C\u00011\u0001$\u0011\u00159C\u00011\u0001)\u0011\u00159D\u00011\u00019\u00031\u0019XM]5bY:+XNY3s+\u0005\u0019\u0005C\u0001#I\u001d\t)e\t\u0005\u0002,=%\u0011qIH\u0001\u0007!J,G-\u001a4\n\u0005%S%AB*ue&twM\u0003\u0002H=\u0005i1/\u001a:jC2tU/\u001c2fe\u0002\n1AY8n+\u0005q\u0005CA(W\u001b\u0005\u0001&BA)S\u0003\u0015iw\u000eZ3m\u0015\t\u0019F+A\u0005ds\u000edwN\\3eq*\tQ+A\u0002pe\u001eL!a\u0016)\u0003\u0007\t{W.\u0001\u0006d_6\u0004xN\\3oiN,\u0012A\u0017\t\u00047~\u0013gB\u0001/_\u001d\tYS,C\u0001 \u0013\t\td$\u0003\u0002aC\n\u00191+Z9\u000b\u0005Er\u0002CA(d\u0013\t!\u0007KA\u0005D_6\u0004xN\\3oi\u0006Y2m\u001c8gS\u001e,(/\u0019;j_:\u001chi\u001c:D_6\u0004xN\\3oiN$\"aZ6\u0011\u0007m{\u0006\u000e\u0005\u0002*S&\u0011!.\u000e\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000b1L\u0001\u0019\u00015\u0002\u001b\r|gNZ5hkJ\fG/[8o\u0003i\u0019w.\u001c9p]\u0016tGo\u001d$pe\u000e{gNZ5hkJ\fG/[8o)\tQv\u000eC\u0003m\u0015\u0001\u0007\u0001N\u0001\nD_6\u0004xN\\3oi\u0016CHO]1di>\u00148CA\u0006\u001d\u00031iw\u000eZ;mKJ+\u0007o\u001c:u!\t!x/D\u0001v\u0015\t1('A\tmS\n\u0014\u0018M]=nC:\fw-Z7f]RL!\u0001_;\u0003\u00195{G-\u001e7f%\u0016\u0004xN\u001d;\u0015\u0005id\bCA>\f\u001b\u0005\u0001\u0001\"\u0002:\u000e\u0001\u0004\u0019\u0018!C2p[B|g.\u001a8u+\u0005\u0011\u0017!\u00047jG\u0016t7/Z\"i_&\u001cW-\u0006\u0002\u0002\u0004A)Q$!\u0002\u0002\n%\u0019\u0011q\u0001\u0010\u0003\r=\u0003H/[8o!\ry\u00151B\u0005\u0004\u0003\u001b\u0001&!\u0004'jG\u0016t7/Z\"i_&\u001cW-\u0001\u0007m_\u001e\u001cu.\u001c9p]\u0016tG\u000f\u0006\u0003\u0002\u0014\u0005e\u0001cA\u000f\u0002\u0016%\u0019\u0011q\u0003\u0010\u0003\tUs\u0017\u000e\u001e\u0005\u0006{B\u0001\rA\u0019")
public class BomExtractor {
    public final BomExtractorParams io$github$siculo$sbtbom$BomExtractor$$settings;
    private final UpdateReport report;
    private final Logger log;
    private final String serialNumber;

    private String serialNumber() {
        return this.serialNumber;
    }

    public Bom bom() {
        Bom bom = new Bom();
        Version version = this.io$github$siculo$sbtbom$BomExtractor$$settings.schemaVersion();
        Version version2 = Version.VERSION_10;
        if (version == null ? version2 != null : !version.equals(version2)) {
            bom.setSerialNumber(this.serialNumber());
        }
        bom.setComponents((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.components()).asJava());
        return bom;
    }

    private Seq<Component> components() {
        return (Seq)this.configurationsForComponents(this.io$github$siculo$sbtbom$BomExtractor$$settings.configuration()).foldLeft((Object)Nil$.MODULE$, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Seq collected = (Seq)tuple2._1();
                Configuration configuration = (Configuration)tuple2._2();
                return (Seq)collected.$plus$plus(this.componentsForConfiguration(configuration), Seq$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private Seq<Configuration> configurationsForComponents(Configuration configuration) {
        this.log.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Current configuration = ").append(configuration.name()).toString());
        Configuration configuration2 = configuration;
        Configuration configuration3 = package$.MODULE$.Test();
        Configuration configuration4 = configuration2;
        if (!(configuration3 != null ? !configuration3.equals(configuration4) : configuration4 != null)) {
            return (Seq)new .colon.colon((Object)package$.MODULE$.Test(), (List)new .colon.colon((Object)package$.MODULE$.Runtime(), (List)new .colon.colon((Object)package$.MODULE$.Compile(), (List)Nil$.MODULE$)));
        }
        Configuration configuration5 = package$.MODULE$.IntegrationTest();
        Configuration configuration6 = configuration2;
        if (!(configuration5 != null ? !configuration5.equals(configuration6) : configuration6 != null)) {
            return (Seq)new .colon.colon((Object)package$.MODULE$.IntegrationTest(), (List)new .colon.colon((Object)package$.MODULE$.Runtime(), (List)new .colon.colon((Object)package$.MODULE$.Compile(), (List)Nil$.MODULE$)));
        }
        Configuration configuration7 = package$.MODULE$.Runtime();
        Configuration configuration8 = configuration2;
        if (!(configuration7 != null ? !configuration7.equals(configuration8) : configuration8 != null)) {
            return (Seq)new .colon.colon((Object)package$.MODULE$.Runtime(), (List)new .colon.colon((Object)package$.MODULE$.Compile(), (List)Nil$.MODULE$));
        }
        Configuration configuration9 = package$.MODULE$.Compile();
        Configuration configuration10 = configuration2;
        if (!(configuration9 != null ? !configuration9.equals(configuration10) : configuration10 != null)) {
            return (Seq)new .colon.colon((Object)package$.MODULE$.Compile(), (List)Nil$.MODULE$);
        }
        Configuration configuration11 = package$.MODULE$.Provided();
        Configuration configuration12 = configuration2;
        if (!(configuration11 != null ? !configuration11.equals(configuration12) : configuration12 != null)) {
            return (Seq)new .colon.colon((Object)package$.MODULE$.Provided(), (List)Nil$.MODULE$);
        }
        if (configuration2 != null) {
            Configuration configuration13 = configuration2;
            return (Seq)new .colon.colon((Object)configuration13, (List)Nil$.MODULE$);
        }
        return (Seq)Nil$.MODULE$;
    }

    private Seq<Component> componentsForConfiguration(Configuration configuration) {
        return (Seq)this.report.configuration(ConfigRef$.MODULE$.configToConfigRef(configuration)).map((Function1 & Serializable & scala.Serializable)configurationReport -> {
            $this.log.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Configuration name = ").append(configurationReport.configuration().name()).append(", modules: ").append(configurationReport.modules().size()).toString());
            return (Vector)configurationReport.modules().map((Function1 & Serializable & scala.Serializable)module -> new ComponentExtractor(this, (ModuleReport)module).component(), Vector$.MODULE$.canBuildFrom());
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
    }

    private void logComponent(Component component) {
        this.log.info((Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(99).append("\"\n         |").append(component.getGroup()).append("\" % \"").append(component.getName()).append("\" % \"").append(component.getVersion()).append("\",\n         | Modified = ").append(component.getModified()).append(", Component type = ").append(component.getType().getTypeName()).append(",\n         | Scope = ").append(component.getScope().getScopeName()).append("\n         | ").toString())).stripMargin());
    }

    public BomExtractor(BomExtractorParams settings, UpdateReport report, Logger log) {
        this.io$github$siculo$sbtbom$BomExtractor$$settings = settings;
        this.report = report;
        this.log = log;
        this.serialNumber = new StringBuilder(9).append("urn:uuid:").append(UUID.randomUUID().toString()).toString();
    }

    public class ComponentExtractor {
        private final ModuleReport moduleReport;
        public final /* synthetic */ BomExtractor $outer;

        public Component component() {
            String group = this.moduleReport.module().organization();
            String name = this.moduleReport.module().name();
            String version = this.moduleReport.module().revision();
            Component component = new Component();
            component.setGroup(group);
            component.setName(name);
            component.setVersion(version);
            component.setModified(Predef$.MODULE$.boolean2Boolean(false));
            component.setType(Component.Type.LIBRARY);
            component.setPurl(new PackageURL("maven", group, name, version, new TreeMap(), null).canonicalize());
            component.setScope(Component.Scope.REQUIRED);
            this.licenseChoice().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                component.setLicenses(x$1);
                return BoxedUnit.UNIT;
            });
            return component;
        }

        private Option<LicenseChoice> licenseChoice() {
            Seq licenses = (Seq)this.moduleReport.licenses().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Option mayBeUrl = (Option)tuple2._2();
                    return new License(name, (Option<String>)mayBeUrl);
                }
                throw new MatchError((Object)tuple2);
            }, Vector$.MODULE$.canBuildFrom());
            if (licenses.isEmpty()) {
                return None$.MODULE$;
            }
            LicenseChoice choice = new LicenseChoice();
            licenses.foreach((Function1 & Serializable & scala.Serializable)modelLicense -> {
                ComponentExtractor.$anonfun$licenseChoice$2(this, choice, modelLicense);
                return BoxedUnit.UNIT;
            });
            return new Some((Object)choice);
        }

        public /* synthetic */ BomExtractor io$github$siculo$sbtbom$BomExtractor$ComponentExtractor$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$licenseChoice$2(ComponentExtractor $this, LicenseChoice choice$1, License modelLicense) {
            org.cyclonedx.model.License license = new org.cyclonedx.model.License();
            license.setName(modelLicense.name());
            Version version = $this.io$github$siculo$sbtbom$BomExtractor$ComponentExtractor$$$outer().io$github$siculo$sbtbom$BomExtractor$$settings.schemaVersion();
            Version version2 = Version.VERSION_10;
            if (version == null ? version2 != null : !version.equals(version2)) {
                modelLicense.url().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    license.setUrl(x$1);
                    return BoxedUnit.UNIT;
                });
            }
            choice$1.addLicense(license);
        }

        public ComponentExtractor(BomExtractor $outer, ModuleReport moduleReport) {
            this.moduleReport = moduleReport;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

