/*
 * Decompiled with CFR 0.152.
 */
package io.github.siculo.sbtbom;

import com.github.packageurl.PackageURL;
import io.github.siculo.sbtbom.BomExtractorParams;
import io.github.siculo.sbtbom.BuildInfo$;
import io.github.siculo.sbtbom.licenses.License;
import io.github.siculo.sbtbom.licenses.LicensesArchive$;
import java.io.File;
import java.io.Serializable;
import java.util.TreeMap;
import java.util.UUID;
import org.cyclonedx.Version;
import org.cyclonedx.model.Bom;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Hash;
import org.cyclonedx.model.LicenseChoice;
import org.cyclonedx.model.Metadata;
import org.cyclonedx.model.Tool;
import org.cyclonedx.util.BomUtils;
import sbt.librarymanagement.ConfigRef$;
import sbt.librarymanagement.Configuration;
import sbt.librarymanagement.ModuleReport;
import sbt.librarymanagement.UpdateReport;
import sbt.package$;
import sbt.util.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Uc\u0001B\u000b\u0017\u0001}A\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!A1\b\u0001B\u0001B\u0003%A\bC\u0003@\u0001\u0011\u0005\u0001\tC\u0004F\u0001\t\u0007I\u0011\u0002$\t\r=\u0003\u0001\u0015!\u0003H\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0011\u0015a\u0006\u0001\"\u0003^\u0011\u0015\t\u0007\u0001\"\u0003c\u0011\u00151\u0007\u0001\"\u0003h\u0011\u0015\u0019\b\u0001\"\u0003u\u0011\u0015Y\b\u0001\"\u0003}\r\u0011q\b\u0001A@\t\u0015\u0005\u0005QB!A!\u0002\u0013\t\u0019\u0001\u0003\u0004@\u001b\u0011\u0005\u0011q\u0002\u0005\b\u0003/iA\u0011AA\r\u0011\u001d\tY\"\u0004C\u0005\u0003;Aq!!\u000b\u000e\t\u0013\tY\u0003C\u0004\u0002:5!I!a\u000f\t\u000f\u0005%\u0003\u0001\"\u0003\u0002L\ta!i\\7FqR\u0014\u0018m\u0019;pe*\u0011q\u0003G\u0001\u0007g\n$(m\\7\u000b\u0005eQ\u0012AB:jGVdwN\u0003\u0002\u001c9\u00051q-\u001b;ik\nT\u0011!H\u0001\u0003S>\u001c\u0001a\u0005\u0002\u0001AA\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t1\u0011I\\=SK\u001a\f\u0001b]3ui&twm\u001d\t\u0003Q%j\u0011AF\u0005\u0003UY\u0011!CQ8n\u000bb$(/Y2u_J\u0004\u0016M]1ng\u00061!/\u001a9peR\u0004\"!L\u001c\u000f\u00059\"dBA\u00183\u001b\u0005\u0001$BA\u0019\u001f\u0003\u0019a$o\\8u}%\t1'A\u0002tERL!!\u000e\u001c\u0002\u000fA\f7m[1hK*\t1'\u0003\u00029s\taQ\u000b\u001d3bi\u0016\u0014V\r]8si&\u0011!H\u000e\u0002\u0007\u00136\u0004xN\u001d;\u0002\u00071|w\r\u0005\u0002.{%\u0011a(\u000f\u0002\u0007\u0019><w-\u001a:\u0002\rqJg.\u001b;?)\u0011\t%i\u0011#\u0011\u0005!\u0002\u0001\"\u0002\u0014\u0005\u0001\u00049\u0003\"B\u0016\u0005\u0001\u0004a\u0003\"B\u001e\u0005\u0001\u0004a\u0014\u0001D:fe&\fGNT;nE\u0016\u0014X#A$\u0011\u0005!ceBA%K!\ty#%\u0003\u0002LE\u00051\u0001K]3eK\u001aL!!\u0014(\u0003\rM#(/\u001b8h\u0015\tY%%A\u0007tKJL\u0017\r\u001c(v[\n,'\u000fI\u0001\u0004E>lW#\u0001*\u0011\u0005MSV\"\u0001+\u000b\u0005U3\u0016!B7pI\u0016d'BA,Y\u0003%\u0019\u0017p\u00197p]\u0016$\u0007PC\u0001Z\u0003\ry'oZ\u0005\u00037R\u00131AQ8n\u0003!iW\r^1eCR\fW#\u00010\u0011\u0005M{\u0016B\u00011U\u0005!iU\r^1eCR\f\u0017\u0001\u0002;p_2,\u0012a\u0019\t\u0003'\u0012L!!\u001a+\u0003\tQ{w\u000e\\\u0001\u000bG>l\u0007o\u001c8f]R\u001cX#\u00015\u0011\u0007%l\u0007O\u0004\u0002kY:\u0011qf[\u0005\u0002G%\u0011QGI\u0005\u0003]>\u00141aU3r\u0015\t)$\u0005\u0005\u0002Tc&\u0011!\u000f\u0016\u0002\n\u0007>l\u0007o\u001c8f]R\f1dY8oM&<WO]1uS>t7OR8s\u0007>l\u0007o\u001c8f]R\u001cHCA;z!\rIWN\u001e\t\u0003[]L!\u0001_\u001d\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u0015Q8\u00021\u0001w\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]\u0006Q2m\\7q_:,g\u000e^:G_J\u001cuN\u001c4jOV\u0014\u0018\r^5p]R\u0011\u0001. \u0005\u0006u2\u0001\rA\u001e\u0002\u0013\u0007>l\u0007o\u001c8f]R,\u0005\u0010\u001e:bGR|'o\u0005\u0002\u000eA\u0005aQn\u001c3vY\u0016\u0014V\r]8siB!\u0011QAA\u0006\u001b\t\t9AC\u0002\u0002\nY\n\u0011\u0003\\5ce\u0006\u0014\u00180\\1oC\u001e,W.\u001a8u\u0013\u0011\ti!a\u0002\u0003\u00195{G-\u001e7f%\u0016\u0004xN\u001d;\u0015\t\u0005E\u0011Q\u0003\t\u0004\u0003'iQ\"\u0001\u0001\t\u000f\u0005\u0005q\u00021\u0001\u0002\u0004\u0005I1m\\7q_:,g\u000e^\u000b\u0002a\u0006i\u0011M\u001d;jM\u0006\u001cG\u000fU1uQN$B!a\b\u0002(A!\u0011.\\A\u0011!\ri\u00131E\u0005\u0004\u0003KI$\u0001\u0002$jY\u0016Dq!!\u0001\u0012\u0001\u0004\t\u0019!\u0001\u0004iCNDWm\u001d\u000b\u0005\u0003[\t)\u0004\u0005\u0003j[\u0006=\u0002cA*\u00022%\u0019\u00111\u0007+\u0003\t!\u000b7\u000f\u001b\u0005\b\u0003o\u0011\u0002\u0019AA\u0010\u0003\u00151\u0017\u000e\\3t\u00035a\u0017nY3og\u0016\u001c\u0005n\\5dKV\u0011\u0011Q\b\t\u0006C\u0005}\u00121I\u0005\u0004\u0003\u0003\u0012#AB(qi&|g\u000eE\u0002T\u0003\u000bJ1!a\u0012U\u00055a\u0015nY3og\u0016\u001c\u0005n\\5dK\u0006aAn\\4D_6\u0004xN\\3oiR!\u0011QJA*!\r\t\u0013qJ\u0005\u0004\u0003#\u0012#\u0001B+oSRDa!a\u0006\u0015\u0001\u0004\u0001\b")
public class BomExtractor {
    public final BomExtractorParams io$github$siculo$sbtbom$BomExtractor$$settings;
    private final UpdateReport report;
    private final Logger log;
    private final String serialNumber;

    private String serialNumber() {
        return this.serialNumber;
    }

    public Bom bom() {
        Bom bom = new Bom();
        Version version = this.io$github$siculo$sbtbom$BomExtractor$$settings.schemaVersion();
        Version version2 = Version.VERSION_10;
        if (version == null ? version2 != null : !version.equals(version2)) {
            bom.setSerialNumber(this.serialNumber());
        }
        bom.setMetadata(this.metadata());
        bom.setComponents((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.components()).asJava());
        return bom;
    }

    private Metadata metadata() {
        Metadata metadata;
        block0: {
            metadata = new Metadata();
            if (!(this.io$github$siculo$sbtbom$BomExtractor$$settings.schemaVersion().getVersion() >= Version.VERSION_12.getVersion())) break block0;
            metadata.addTool(this.tool());
        }
        return metadata;
    }

    private Tool tool() {
        Tool tool = new Tool();
        tool.setName("CycloneDX SBT plugin");
        tool.setVersion(BuildInfo$.MODULE$.version());
        return tool;
    }

    private Seq<Component> components() {
        return (Seq)this.configurationsForComponents(this.io$github$siculo$sbtbom$BomExtractor$$settings.configuration()).foldLeft((Object)Nil$.MODULE$, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Seq collected = (Seq)tuple2._1();
                Configuration configuration = (Configuration)tuple2._2();
                return (Seq)collected.$plus$plus(this.componentsForConfiguration(configuration), Seq$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private Seq<Configuration> configurationsForComponents(Configuration configuration) {
        this.log.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Current configuration = ").append(configuration.name()).toString());
        Configuration configuration2 = configuration;
        Configuration configuration3 = package$.MODULE$.Test();
        Configuration configuration4 = configuration2;
        if (!(configuration3 != null ? !configuration3.equals(configuration4) : configuration4 != null)) {
            return (Seq)new .colon.colon((Object)package$.MODULE$.Test(), (List)new .colon.colon((Object)package$.MODULE$.Runtime(), (List)new .colon.colon((Object)package$.MODULE$.Compile(), (List)Nil$.MODULE$)));
        }
        Configuration configuration5 = package$.MODULE$.IntegrationTest();
        Configuration configuration6 = configuration2;
        if (!(configuration5 != null ? !configuration5.equals(configuration6) : configuration6 != null)) {
            return (Seq)new .colon.colon((Object)package$.MODULE$.IntegrationTest(), (List)new .colon.colon((Object)package$.MODULE$.Runtime(), (List)new .colon.colon((Object)package$.MODULE$.Compile(), (List)Nil$.MODULE$)));
        }
        Configuration configuration7 = package$.MODULE$.Runtime();
        Configuration configuration8 = configuration2;
        if (!(configuration7 != null ? !configuration7.equals(configuration8) : configuration8 != null)) {
            return (Seq)new .colon.colon((Object)package$.MODULE$.Runtime(), (List)new .colon.colon((Object)package$.MODULE$.Compile(), (List)Nil$.MODULE$));
        }
        Configuration configuration9 = package$.MODULE$.Compile();
        Configuration configuration10 = configuration2;
        if (!(configuration9 != null ? !configuration9.equals(configuration10) : configuration10 != null)) {
            return (Seq)new .colon.colon((Object)package$.MODULE$.Compile(), (List)Nil$.MODULE$);
        }
        Configuration configuration11 = package$.MODULE$.Provided();
        Configuration configuration12 = configuration2;
        if (!(configuration11 != null ? !configuration11.equals(configuration12) : configuration12 != null)) {
            return (Seq)new .colon.colon((Object)package$.MODULE$.Provided(), (List)Nil$.MODULE$);
        }
        if (configuration2 != null) {
            Configuration configuration13 = configuration2;
            return (Seq)new .colon.colon((Object)configuration13, (List)Nil$.MODULE$);
        }
        return (Seq)Nil$.MODULE$;
    }

    private Seq<Component> componentsForConfiguration(Configuration configuration) {
        return (Seq)this.report.configuration(ConfigRef$.MODULE$.configToConfigRef(configuration)).map((Function1 & Serializable & scala.Serializable)configurationReport -> {
            $this.log.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Configuration name = ").append(configurationReport.configuration().name()).append(", modules: ").append(configurationReport.modules().size()).toString());
            return (Vector)configurationReport.modules().map((Function1 & Serializable & scala.Serializable)module -> new ComponentExtractor(this, (ModuleReport)module).component(), Vector$.MODULE$.canBuildFrom());
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
    }

    private void logComponent(Component component) {
        this.log.info((Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(99).append("\"\n         |").append(component.getGroup()).append("\" % \"").append(component.getName()).append("\" % \"").append(component.getVersion()).append("\",\n         | Modified = ").append(component.getModified()).append(", Component type = ").append(component.getType().getTypeName()).append(",\n         | Scope = ").append(component.getScope().getScopeName()).append("\n         | ").toString())).stripMargin());
    }

    public BomExtractor(BomExtractorParams settings, UpdateReport report, Logger log) {
        this.io$github$siculo$sbtbom$BomExtractor$$settings = settings;
        this.report = report;
        this.log = log;
        this.serialNumber = new StringBuilder(9).append("urn:uuid:").append(UUID.randomUUID().toString()).toString();
    }

    public class ComponentExtractor {
        private final ModuleReport moduleReport;
        public final /* synthetic */ BomExtractor $outer;

        public Component component() {
            String group = this.moduleReport.module().organization();
            String name = this.moduleReport.module().name();
            String version = this.moduleReport.module().revision();
            Component component = new Component();
            component.setGroup(group);
            component.setName(name);
            component.setVersion(version);
            component.setModified(Predef$.MODULE$.boolean2Boolean(false));
            component.setType(Component.Type.LIBRARY);
            component.setPurl(new PackageURL("maven", group, name, version, new TreeMap(), null).canonicalize());
            component.setScope(Component.Scope.REQUIRED);
            component.setHashes((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.hashes(this.artifactPaths(this.moduleReport))).asJava());
            this.licenseChoice().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                component.setLicenses(x$1);
                return BoxedUnit.UNIT;
            });
            return component;
        }

        private Seq<File> artifactPaths(ModuleReport moduleReport) {
            return (Seq)((TraversableLike)moduleReport.artifacts().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    File file = (File)tuple2._2();
                    return file;
                }
                throw new MatchError((Object)tuple2);
            }, Vector$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)ComponentExtractor.$anonfun$artifactPaths$2(file)));
        }

        private Seq<Hash> hashes(Seq<File> files) {
            return (Seq)files.flatMap((Function1 & Serializable & scala.Serializable)file -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(BomUtils.calculateHashes((File)file, (Version)$this.io$github$siculo$sbtbom$BomExtractor$ComponentExtractor$$$outer().io$github$siculo$sbtbom$BomExtractor$$settings.schemaVersion())).asScala(), Seq$.MODULE$.canBuildFrom());
        }

        private Option<LicenseChoice> licenseChoice() {
            Seq licenses = (Seq)this.moduleReport.licenses().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Option urlOption = (Option)tuple2._2();
                    org.cyclonedx.model.License license = new org.cyclonedx.model.License();
                    license.setName(name);
                    urlOption.foreach((Function1 & Serializable & scala.Serializable)licenseUrl -> {
                        ComponentExtractor.$anonfun$licenseChoice$2(this, license, licenseUrl);
                        return BoxedUnit.UNIT;
                    });
                    return license;
                }
                throw new MatchError((Object)tuple2);
            }, Vector$.MODULE$.canBuildFrom());
            if (licenses.isEmpty()) {
                return None$.MODULE$;
            }
            LicenseChoice choice = new LicenseChoice();
            licenses.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                choice.addLicense(x$1);
                return BoxedUnit.UNIT;
            });
            return new Some((Object)choice);
        }

        public /* synthetic */ BomExtractor io$github$siculo$sbtbom$BomExtractor$ComponentExtractor$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ boolean $anonfun$artifactPaths$2(File file) {
            return file.exists() && file.isFile();
        }

        public static final /* synthetic */ void $anonfun$licenseChoice$3(org.cyclonedx.model.License license$1, License archiveLicense) {
            license$1.setId(archiveLicense.id());
            license$1.setName(archiveLicense.name());
        }

        public static final /* synthetic */ void $anonfun$licenseChoice$2(ComponentExtractor $this, org.cyclonedx.model.License license$1, String licenseUrl) {
            LicensesArchive$.MODULE$.bundled().findByNormalizedUrl(licenseUrl).foreach((Function1 & Serializable & scala.Serializable)archiveLicense -> {
                ComponentExtractor.$anonfun$licenseChoice$3(license$1, archiveLicense);
                return BoxedUnit.UNIT;
            });
            Version version = $this.io$github$siculo$sbtbom$BomExtractor$ComponentExtractor$$$outer().io$github$siculo$sbtbom$BomExtractor$$settings.schemaVersion();
            Version version2 = Version.VERSION_10;
            if (version == null ? version2 != null : !version.equals(version2)) {
                license$1.setUrl(licenseUrl);
                return;
            }
        }

        public ComponentExtractor(BomExtractor $outer, ModuleReport moduleReport) {
            this.moduleReport = moduleReport;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

