/*
 * Decompiled with CFR 0.152.
 */
package io.github.siculo.sbtbom;

import io.github.siculo.sbtbom.BomError;
import io.github.siculo.sbtbom.BomExtractor;
import io.github.siculo.sbtbom.BomExtractorParams;
import io.github.siculo.sbtbom.BomTaskProperties;
import io.github.siculo.sbtbom.SchemaVersions$;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.apache.commons.io.FileUtils;
import org.cyclonedx.Version;
import org.cyclonedx.exception.ParseException;
import org.cyclonedx.generators.BomGeneratorFactory;
import org.cyclonedx.generators.xml.BomXmlGenerator;
import org.cyclonedx.model.Bom;
import org.cyclonedx.parsers.XmlParser;
import sbt.librarymanagement.Configuration;
import sbt.librarymanagement.UpdateReport;
import sbt.util.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005ma!B\b\u0011\u0003\u0003I\u0002\u0002C\u0011\u0001\u0005\u000b\u0007I\u0011\u0003\u0012\t\u0011\u001d\u0002!\u0011!Q\u0001\n\rBQ\u0001\u000b\u0001\u0005\u0002%BQa\u000e\u0001\u0007\u0002aBQ!\u000f\u0001\u0005\u0012iBQA\u0012\u0001\u0005\u0012\u001dCQa\u0017\u0001\u0005\u0012qCQa\u0018\u0001\u0005\n\u0001DQ!\u001b\u0001\u0005\n)DQa\u001e\u0001\u0005\u0012aDQ\u0001 \u0001\u0005\u0012uDa!\u001a\u0001\u0005\u0012\u0005\r\u0001bBA\u0003\u0001\u0011E\u0011q\u0001\u0005\u000b\u0003\u001f\u0001\u0001R1A\u0005\u0012\u0005E!a\u0002\"p[R\u000b7o\u001b\u0006\u0003#I\taa\u001d2uE>l'BA\n\u0015\u0003\u0019\u0019\u0018nY;m_*\u0011QCF\u0001\u0007O&$\b.\u001e2\u000b\u0003]\t!![8\u0004\u0001U\u0011!$L\n\u0003\u0001m\u0001\"\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\u0011a!\u00118z%\u00164\u0017A\u00039s_B,'\u000f^5fgV\t1\u0005\u0005\u0002%K5\t\u0001#\u0003\u0002'!\t\t\"i\\7UCN\\\u0007K]8qKJ$\u0018.Z:\u0002\u0017A\u0014x\u000e]3si&,7\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005)2\u0004c\u0001\u0013\u0001WA\u0011A&\f\u0007\u0001\t\u0015q\u0003A1\u00010\u0005\u0005!\u0016C\u0001\u00194!\ta\u0012'\u0003\u00023;\t9aj\u001c;iS:<\u0007C\u0001\u000f5\u0013\t)TDA\u0002B]fDQ!I\u0002A\u0002\r\nq!\u001a=fGV$X-F\u0001,\u0003)9W\r\u001e\"p[R+\u0007\u0010^\u000b\u0002wA\u0011Ah\u0011\b\u0003{\u0005\u0003\"AP\u000f\u000e\u0003}R!\u0001\u0011\r\u0002\rq\u0012xn\u001c;?\u0013\t\u0011U$\u0001\u0004Qe\u0016$WMZ\u0005\u0003\t\u0016\u0013aa\u0015;sS:<'B\u0001\"\u001e\u0003-9(/\u001b;f)>4\u0015\u000e\\3\u0015\u0007![\u0015\f\u0005\u0002\u001d\u0013&\u0011!*\b\u0002\u0005+:LG\u000fC\u0003M\r\u0001\u0007Q*\u0001\u0005eKN$h)\u001b7f!\tqUK\u0004\u0002P%:\u0011a\bU\u0005\u0002#\u0006\u00191O\u0019;\n\u0005M#\u0016a\u00029bG.\fw-\u001a\u0006\u0002#&\u0011ak\u0016\u0002\u0005\r&dW-\u0003\u0002Y)\n1\u0011*\u001c9peRDQA\u0017\u0004A\u0002m\nA\u0001^3yi\u0006ya/\u00197jI\u0006$XMQ8n\r&dW\r\u0006\u0002I;\")al\u0002a\u0001\u001b\u00069!m\\7GS2,\u0017aD3yiJ\f7\r^8s!\u0006\u0014\u0018-\\:\u0015\u0005\u0005$\u0007C\u0001\u0013c\u0013\t\u0019\u0007C\u0001\nC_6,\u0005\u0010\u001e:bGR|'\u000fU1sC6\u001c\b\"B3\t\u0001\u00041\u0017\u0001F2veJ,g\u000e^\"p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0002OO&\u0011\u0001n\u0016\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u0015\u001d,G\u000fW7m)\u0016DH\u000f\u0006\u0002<W\")A.\u0003a\u0001[\u0006\u0019!m\\7\u0011\u00059,X\"A8\u000b\u0005A\f\u0018!B7pI\u0016d'B\u0001:t\u0003%\u0019\u0017p\u00197p]\u0016$\u0007PC\u0001u\u0003\ry'oZ\u0005\u0003m>\u00141AQ8n\u0003)awn\u001a\"p[&sgm\u001c\u000b\u0004\u0011f\\\b\"\u0002>\u000b\u0001\u0004\t\u0017A\u00029be\u0006l7\u000fC\u0003m\u0015\u0001\u0007Q.\u0001\u0004sKB|'\u000f^\u000b\u0002}B\u0011aj`\u0005\u0004\u0003\u00039&\u0001D+qI\u0006$XMU3q_J$X#\u00014\u0002\u00071|w-\u0006\u0002\u0002\nA\u0019a*a\u0003\n\u0007\u00055qK\u0001\u0004M_\u001e<WM]\u0001\u000eg\u000eDW-\\1WKJ\u001c\u0018n\u001c8\u0016\u0005\u0005M\u0001\u0003BA\u000b\u0003/i\u0011!]\u0005\u0004\u00033\t(a\u0002,feNLwN\u001c")
public abstract class BomTask<T> {
    private Version schemaVersion;
    private final BomTaskProperties properties;
    private volatile boolean bitmap$0;

    public BomTaskProperties properties() {
        return this.properties;
    }

    public abstract T execute();

    public String getBomText() {
        BomExtractorParams params = this.extractorParams(this.currentConfiguration());
        Bom bom = new BomExtractor(params, this.report(), this.log()).bom();
        String bomText = this.getXmlText(bom);
        this.logBomInfo(params, bom);
        return bomText;
    }

    public void writeToFile(File destFile, String text) {
        FileUtils.write((File)destFile, (CharSequence)text, (Charset)Charset.forName("UTF-8"), (boolean)false);
    }

    public void validateBomFile(File bomFile) {
        XmlParser parser = new XmlParser();
        Buffer exceptions = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(parser.validate(bomFile, this.schemaVersion())).asScala();
        if (exceptions.nonEmpty()) {
            String message = new StringBuilder(82).append("The BOM file ").append(bomFile.getAbsolutePath()).append(" does not conform to the CycloneDX BOM standard as defined by the XSD").toString();
            this.log().error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(1).append(message).append(":").toString());
            exceptions.foreach((Function1 & Serializable & scala.Serializable)exception -> {
                BomTask.$anonfun$validateBomFile$2(this, exception);
                return BoxedUnit.UNIT;
            });
            throw new BomError(message);
        }
    }

    private BomExtractorParams extractorParams(Configuration currentConfiguration) {
        return new BomExtractorParams(this.schemaVersion(), currentConfiguration);
    }

    private String getXmlText(Bom bom) {
        BomXmlGenerator bomGenerator = BomGeneratorFactory.createXml((Version)this.schemaVersion(), (Bom)bom);
        bomGenerator.generate();
        String bomText = bomGenerator.toXmlString();
        return bomText;
    }

    public void logBomInfo(BomExtractorParams params, Bom bom) {
        this.log().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Schema version: ").append(this.schemaVersion().getVersionString()).toString());
        this.log().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Scope         : ").append(params.configuration().id()).toString());
    }

    public UpdateReport report() {
        return this.properties().report();
    }

    public Configuration currentConfiguration() {
        return this.properties().currentConfiguration();
    }

    public Logger log() {
        return this.properties().log();
    }

    private Version schemaVersion$lzycompute() {
        BomTask bomTask = this;
        synchronized (bomTask) {
            if (!this.bitmap$0) {
                Option<Version> option = SchemaVersions$.MODULE$.supportedVersionByName(this.properties().schemaVersion());
                if (!(option instanceof Some)) {
                    if (None$.MODULE$.equals(option)) {
                        String message = new StringBuilder(27).append("Unsupported schema version ").append(this.properties().schemaVersion()).toString();
                        this.log().error((Function0 & Serializable & scala.Serializable)() -> message);
                        throw new BomError(message);
                    }
                    throw new MatchError(option);
                }
                Some some = (Some)option;
                Version foundVersion = (Version)some.value();
                this.schemaVersion = foundVersion;
                this.bitmap$0 = true;
            }
        }
        return this.schemaVersion;
    }

    public Version schemaVersion() {
        if (!this.bitmap$0) {
            return this.schemaVersion$lzycompute();
        }
        return this.schemaVersion;
    }

    public static final /* synthetic */ void $anonfun$validateBomFile$2(BomTask $this, ParseException exception) {
        $this.log().error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(2).append("- ").append(exception.getMessage()).toString());
    }

    public BomTask(BomTaskProperties properties) {
        this.properties = properties;
    }
}

