/*
 * Decompiled with CFR 0.152.
 */
package io.github.siculo.sbtbom;

import com.github.packageurl.PackageURL;
import io.github.siculo.sbtbom.BuildInfo$;
import io.github.siculo.sbtbom.licenses.LicensesArchive$;
import java.io.File;
import java.io.Serializable;
import java.util.TreeMap;
import java.util.UUID;
import org.cyclonedx.Version;
import org.cyclonedx.model.Bom;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Hash;
import org.cyclonedx.model.License;
import org.cyclonedx.model.LicenseChoice;
import org.cyclonedx.model.Metadata;
import org.cyclonedx.model.Tool;
import org.cyclonedx.util.BomUtils;
import sbt.librarymanagement.ConfigRef$;
import sbt.librarymanagement.Configuration;
import sbt.librarymanagement.ModuleReport;
import sbt.librarymanagement.UpdateReport;
import sbt.package$;
import sbt.util.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001\u0002\f\u0018\u0001\u0001B\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\ta\u0001\u0011\t\u0011)A\u0005c!A\u0001\t\u0001B\u0001B\u0003%\u0011\t\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003F\u0011\u0015A\u0005\u0001\"\u0001J\u0011\u001d\u0001\u0006A1A\u0005\nECaA\u0017\u0001!\u0002\u0013\u0011\u0006\"B.\u0001\t\u0003a\u0006\"B2\u0001\t\u0013!\u0007\"\u00025\u0001\t\u0013I\u0007\"B7\u0001\t\u0013q\u0007\"\u0002>\u0001\t\u0013Y\b\"\u0002@\u0001\t\u0013yhABA\u0002\u0001\u0001\t)\u0001\u0003\u0006\u0002\b9\u0011\t\u0011)A\u0005\u0003\u0013Aa\u0001\u0013\b\u0005\u0002\u0005U\u0001bBA\u000f\u001d\u0011\u0005\u0011q\u0004\u0005\b\u0003CqA\u0011BA\u0012\u0011\u001d\tyC\u0004C\u0005\u0003cAq!a\u0010\u000f\t\u0013\t\t\u0005C\u0004\u0002P\u0001!I!!\u0015\u0003\u0019\t{W.\u0012=ue\u0006\u001cGo\u001c:\u000b\u0005aI\u0012AB:ci\n|WN\u0003\u0002\u001b7\u000511/[2vY>T!\u0001H\u000f\u0002\r\u001dLG\u000f[;c\u0015\u0005q\u0012AA5p\u0007\u0001\u0019\"\u0001A\u0011\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\r\u0005s\u0017PU3g\u00035\u00198\r[3nCZ+'o]5p]B\u0011\u0011FL\u0007\u0002U)\u00111\u0006L\u0001\nGf\u001cGn\u001c8fIbT\u0011!L\u0001\u0004_J<\u0017BA\u0018+\u0005\u001d1VM]:j_:\fQbY8oM&<WO]1uS>t\u0007C\u0001\u001a=\u001d\t\u0019\u0014H\u0004\u00025o5\tQG\u0003\u00027?\u00051AH]8pizJ\u0011\u0001O\u0001\u0004g\n$\u0018B\u0001\u001e<\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011\u0001O\u0005\u0003{y\u0012QbQ8oM&<WO]1uS>t\u0017BA <\u0005\u0019IU\u000e]8si\u00061!/\u001a9peR\u0004\"A\r\"\n\u0005\rs$\u0001D+qI\u0006$XMU3q_J$\u0018a\u00017pOB\u0011!GR\u0005\u0003\u000fz\u0012a\u0001T8hO\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0003K\u00196su\n\u0005\u0002L\u00015\tq\u0003C\u0003(\u000b\u0001\u0007\u0001\u0006C\u00031\u000b\u0001\u0007\u0011\u0007C\u0003A\u000b\u0001\u0007\u0011\tC\u0003E\u000b\u0001\u0007Q)\u0001\u0007tKJL\u0017\r\u001c(v[\n,'/F\u0001S!\t\u0019vK\u0004\u0002U+B\u0011AgI\u0005\u0003-\u000e\na\u0001\u0015:fI\u00164\u0017B\u0001-Z\u0005\u0019\u0019FO]5oO*\u0011akI\u0001\u000eg\u0016\u0014\u0018.\u00197Ok6\u0014WM\u001d\u0011\u0002\u0007\t|W.F\u0001^!\tq\u0016-D\u0001`\u0015\t\u0001'&A\u0003n_\u0012,G.\u0003\u0002c?\n\u0019!i\\7\u0002\u00115,G/\u00193bi\u0006,\u0012!\u001a\t\u0003=\u001aL!aZ0\u0003\u00115+G/\u00193bi\u0006\fA\u0001^8pYV\t!\u000e\u0005\u0002_W&\u0011An\u0018\u0002\u0005)>|G.\u0001\u0006d_6\u0004xN\\3oiN,\u0012a\u001c\t\u0004aR<hBA9t\u001d\t!$/C\u0001%\u0013\tQ4%\u0003\u0002vm\n\u00191+Z9\u000b\u0005i\u001a\u0003C\u00010y\u0013\tIxLA\u0005D_6\u0004xN\\3oi\u0006Y2m\u001c8gS\u001e,(/\u0019;j_:\u001chi\u001c:D_6\u0004xN\\3oiN$\"\u0001`?\u0011\u0007A$\u0018\u0007C\u00031\u0019\u0001\u0007\u0011'\u0001\u000ed_6\u0004xN\\3oiN4uN]\"p]\u001aLw-\u001e:bi&|g\u000eF\u0002p\u0003\u0003AQ\u0001M\u0007A\u0002E\u0012!cQ8na>tWM\u001c;FqR\u0014\u0018m\u0019;peN\u0011a\"I\u0001\r[>$W\u000f\\3SKB|'\u000f\u001e\t\u0005\u0003\u0017\t\t\"\u0004\u0002\u0002\u000e)\u0019\u0011qB\u001e\u0002#1L'M]1ss6\fg.Y4f[\u0016tG/\u0003\u0003\u0002\u0014\u00055!\u0001D'pIVdWMU3q_J$H\u0003BA\f\u00037\u00012!!\u0007\u000f\u001b\u0005\u0001\u0001bBA\u0004!\u0001\u0007\u0011\u0011B\u0001\nG>l\u0007o\u001c8f]R,\u0012a^\u0001\u000eCJ$\u0018NZ1diB\u000bG\u000f[:\u0015\t\u0005\u0015\u0012Q\u0006\t\u0005aR\f9\u0003E\u00023\u0003SI1!a\u000b?\u0005\u00111\u0015\u000e\\3\t\u000f\u0005\u001d!\u00031\u0001\u0002\n\u00051\u0001.Y:iKN$B!a\r\u0002<A!\u0001\u000f^A\u001b!\rq\u0016qG\u0005\u0004\u0003sy&\u0001\u0002%bg\"Dq!!\u0010\u0014\u0001\u0004\t)#A\u0003gS2,7/A\u0007mS\u000e,gn]3DQ>L7-Z\u000b\u0003\u0003\u0007\u0002RAIA#\u0003\u0013J1!a\u0012$\u0005\u0019y\u0005\u000f^5p]B\u0019a,a\u0013\n\u0007\u00055sLA\u0007MS\u000e,gn]3DQ>L7-Z\u0001\rY><7i\\7q_:,g\u000e\u001e\u000b\u0005\u0003'\nI\u0006E\u0002#\u0003+J1!a\u0016$\u0005\u0011)f.\u001b;\t\r\u0005uQ\u00031\u0001x\u0001")
public class BomExtractor {
    public final Version io$github$siculo$sbtbom$BomExtractor$$schemaVersion;
    private final Configuration configuration;
    private final UpdateReport report;
    private final Logger log;
    private final String serialNumber;

    private String serialNumber() {
        return this.serialNumber;
    }

    public Bom bom() {
        Bom bom = new Bom();
        if (this.io$github$siculo$sbtbom$BomExtractor$$schemaVersion.getVersion() >= Version.VERSION_11.getVersion()) {
            bom.setSerialNumber(this.serialNumber());
        }
        if (this.io$github$siculo$sbtbom$BomExtractor$$schemaVersion.getVersion() >= Version.VERSION_12.getVersion()) {
            bom.setMetadata(this.metadata());
        }
        bom.setComponents((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.components()).asJava());
        return bom;
    }

    private Metadata metadata() {
        Metadata metadata = new Metadata();
        metadata.addTool(this.tool());
        return metadata;
    }

    private Tool tool() {
        Tool tool = new Tool();
        tool.setName("CycloneDX SBT plugin");
        tool.setVersion(BuildInfo$.MODULE$.version());
        return tool;
    }

    private Seq<Component> components() {
        return (Seq)this.configurationsForComponents(this.configuration).foldLeft((Object)Nil$.MODULE$, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Seq collected = (Seq)tuple2._1();
                Configuration configuration = (Configuration)tuple2._2();
                return (Seq)collected.$plus$plus(this.componentsForConfiguration(configuration), Seq$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private Seq<Configuration> configurationsForComponents(Configuration configuration) {
        this.log.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Current configuration = ").append(configuration.name()).toString());
        Configuration configuration2 = configuration;
        Configuration configuration3 = package$.MODULE$.Test();
        Configuration configuration4 = configuration2;
        if (!(configuration3 != null ? !configuration3.equals(configuration4) : configuration4 != null)) {
            return (Seq)new .colon.colon((Object)package$.MODULE$.Test(), (List)new .colon.colon((Object)package$.MODULE$.Runtime(), (List)new .colon.colon((Object)package$.MODULE$.Compile(), (List)Nil$.MODULE$)));
        }
        Configuration configuration5 = package$.MODULE$.IntegrationTest();
        Configuration configuration6 = configuration2;
        if (!(configuration5 != null ? !configuration5.equals(configuration6) : configuration6 != null)) {
            return (Seq)new .colon.colon((Object)package$.MODULE$.IntegrationTest(), (List)new .colon.colon((Object)package$.MODULE$.Runtime(), (List)new .colon.colon((Object)package$.MODULE$.Compile(), (List)Nil$.MODULE$)));
        }
        Configuration configuration7 = package$.MODULE$.Runtime();
        Configuration configuration8 = configuration2;
        if (!(configuration7 != null ? !configuration7.equals(configuration8) : configuration8 != null)) {
            return (Seq)new .colon.colon((Object)package$.MODULE$.Runtime(), (List)new .colon.colon((Object)package$.MODULE$.Compile(), (List)Nil$.MODULE$));
        }
        Configuration configuration9 = package$.MODULE$.Compile();
        Configuration configuration10 = configuration2;
        if (!(configuration9 != null ? !configuration9.equals(configuration10) : configuration10 != null)) {
            return (Seq)new .colon.colon((Object)package$.MODULE$.Compile(), (List)Nil$.MODULE$);
        }
        Configuration configuration11 = package$.MODULE$.Provided();
        Configuration configuration12 = configuration2;
        if (!(configuration11 != null ? !configuration11.equals(configuration12) : configuration12 != null)) {
            return (Seq)new .colon.colon((Object)package$.MODULE$.Provided(), (List)Nil$.MODULE$);
        }
        if (configuration2 != null) {
            Configuration configuration13 = configuration2;
            return (Seq)new .colon.colon((Object)configuration13, (List)Nil$.MODULE$);
        }
        return (Seq)Nil$.MODULE$;
    }

    private Seq<Component> componentsForConfiguration(Configuration configuration) {
        return (Seq)this.report.configuration(ConfigRef$.MODULE$.configToConfigRef(configuration)).map((Function1 & Serializable & scala.Serializable)configurationReport -> {
            $this.log.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Configuration name = ").append(configurationReport.configuration().name()).append(", modules: ").append(configurationReport.modules().size()).toString());
            return (Vector)((SeqLike)configurationReport.modules().map((Function1 & Serializable & scala.Serializable)module -> new ComponentExtractor(this, (ModuleReport)module).component(), Vector$.MODULE$.canBuildFrom())).distinct();
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
    }

    private void logComponent(Component component) {
        this.log.info((Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(99).append("\"\n         |").append(component.getGroup()).append("\" % \"").append(component.getName()).append("\" % \"").append(component.getVersion()).append("\",\n         | Modified = ").append(component.getModified()).append(", Component type = ").append(component.getType().getTypeName()).append(",\n         | Scope = ").append(component.getScope().getScopeName()).append("\n         | ").toString())).stripMargin());
    }

    public BomExtractor(Version schemaVersion, Configuration configuration, UpdateReport report, Logger log) {
        this.io$github$siculo$sbtbom$BomExtractor$$schemaVersion = schemaVersion;
        this.configuration = configuration;
        this.report = report;
        this.log = log;
        this.serialNumber = new StringBuilder(9).append("urn:uuid:").append(UUID.randomUUID().toString()).toString();
    }

    public class ComponentExtractor {
        private final ModuleReport moduleReport;
        public final /* synthetic */ BomExtractor $outer;

        public Component component() {
            String group = this.moduleReport.module().organization();
            String name = this.moduleReport.module().name();
            String version = this.moduleReport.module().revision();
            Component component = new Component();
            component.setGroup(group);
            component.setName(name);
            component.setVersion(version);
            component.setModified(Predef$.MODULE$.boolean2Boolean(false));
            component.setType(Component.Type.LIBRARY);
            component.setPurl(new PackageURL("maven", group, name, version, new TreeMap(), null).canonicalize());
            if (this.io$github$siculo$sbtbom$BomExtractor$ComponentExtractor$$$outer().io$github$siculo$sbtbom$BomExtractor$$schemaVersion.getVersion() >= Version.VERSION_11.getVersion()) {
                component.setBomRef(component.getPurl());
            }
            component.setScope(Component.Scope.REQUIRED);
            component.setHashes((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.hashes(this.artifactPaths(this.moduleReport))).asJava());
            this.licenseChoice().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                component.setLicenses(x$1);
                return BoxedUnit.UNIT;
            });
            return component;
        }

        private Seq<File> artifactPaths(ModuleReport moduleReport) {
            return (Seq)((TraversableLike)moduleReport.artifacts().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    File file = (File)tuple2._2();
                    return file;
                }
                throw new MatchError((Object)tuple2);
            }, Vector$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)ComponentExtractor.$anonfun$artifactPaths$2(file)));
        }

        private Seq<Hash> hashes(Seq<File> files) {
            return (Seq)files.flatMap((Function1 & Serializable & scala.Serializable)file -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(BomUtils.calculateHashes((File)file, (Version)$this.io$github$siculo$sbtbom$BomExtractor$ComponentExtractor$$$outer().io$github$siculo$sbtbom$BomExtractor$$schemaVersion)).asScala(), Seq$.MODULE$.canBuildFrom());
        }

        private Option<LicenseChoice> licenseChoice() {
            Seq licenses = (Seq)this.moduleReport.licenses().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Option urlOption = (Option)tuple2._2();
                    License license = new License();
                    urlOption.foreach((Function1 & Serializable & scala.Serializable)licenseUrl -> {
                        ComponentExtractor.$anonfun$licenseChoice$2(this, license, licenseUrl);
                        return BoxedUnit.UNIT;
                    });
                    if (license.getId() == null) {
                        license.setName(name);
                    }
                    return license;
                }
                throw new MatchError((Object)tuple2);
            }, Vector$.MODULE$.canBuildFrom());
            if (licenses.isEmpty()) {
                return None$.MODULE$;
            }
            LicenseChoice choice = new LicenseChoice();
            licenses.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                choice.addLicense(x$1);
                return BoxedUnit.UNIT;
            });
            return new Some((Object)choice);
        }

        public /* synthetic */ BomExtractor io$github$siculo$sbtbom$BomExtractor$ComponentExtractor$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ boolean $anonfun$artifactPaths$2(File file) {
            return file.exists() && file.isFile();
        }

        public static final /* synthetic */ void $anonfun$licenseChoice$2(ComponentExtractor $this, License license$1, String licenseUrl) {
            LicensesArchive$.MODULE$.bundled().findByNormalizedUrl(licenseUrl).foreach((Function1 & Serializable & scala.Serializable)archiveLicense -> {
                license$1.setId(archiveLicense.id());
                return BoxedUnit.UNIT;
            });
            if ($this.io$github$siculo$sbtbom$BomExtractor$ComponentExtractor$$$outer().io$github$siculo$sbtbom$BomExtractor$$schemaVersion.getVersion() >= Version.VERSION_11.getVersion()) {
                license$1.setUrl(licenseUrl);
                return;
            }
        }

        public ComponentExtractor(BomExtractor $outer, ModuleReport moduleReport) {
            this.moduleReport = moduleReport;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

