/*
 * Decompiled with CFR 0.152.
 */
package io.github.siculo.sbtbom;

import io.github.siculo.sbtbom.BomError;
import io.github.siculo.sbtbom.BomExtractor;
import io.github.siculo.sbtbom.BomTaskProperties;
import io.github.siculo.sbtbom.SchemaVersions$;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.apache.commons.io.FileUtils;
import org.cyclonedx.Version;
import org.cyclonedx.exception.ParseException;
import org.cyclonedx.generators.BomGeneratorFactory;
import org.cyclonedx.model.Bom;
import org.cyclonedx.parsers.JsonParser;
import org.cyclonedx.parsers.Parser;
import org.cyclonedx.parsers.XmlParser;
import sbt.librarymanagement.Configuration;
import sbt.librarymanagement.UpdateReport;
import sbt.util.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001da!B\u0007\u000f\u0003\u00039\u0002\u0002C\u0010\u0001\u0005\u000b\u0007I\u0011\u0003\u0011\t\u0011\u0015\u0002!\u0011!Q\u0001\n\u0005BQA\n\u0001\u0005\u0002\u001dBQ!\u000e\u0001\u0007\u0002YBQa\u000e\u0001\u0005\u0012aBQ\u0001\u0012\u0001\u0005\u0012\u0015CQ!\u0017\u0001\u0005\u0012iCQ!\u0018\u0001\u0005\u0012yCQA\u001e\u0001\u0005\u0012]DQa\u001f\u0001\u0005\u0012qDQ! \u0001\u0005\u0012yD\u0011\u0002\u0019\u0001\t\u0006\u0004%\t\"!\u0002\u0003\u000f\t{W\u000eV1tW*\u0011q\u0002E\u0001\u0007g\n$(m\\7\u000b\u0005E\u0011\u0012AB:jGVdwN\u0003\u0002\u0014)\u00051q-\u001b;ik\nT\u0011!F\u0001\u0003S>\u001c\u0001!\u0006\u0002\u0019WM\u0011\u0001!\u0007\t\u00035ui\u0011a\u0007\u0006\u00029\u0005)1oY1mC&\u0011ad\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\u0015A\u0014x\u000e]3si&,7/F\u0001\"!\t\u00113%D\u0001\u000f\u0013\t!cBA\tC_6$\u0016m]6Qe>\u0004XM\u001d;jKN\f1\u0002\u001d:pa\u0016\u0014H/[3tA\u00051A(\u001b8jiz\"\"\u0001\u000b\u001b\u0011\u0007\t\u0002\u0011\u0006\u0005\u0002+W1\u0001A!\u0002\u0017\u0001\u0005\u0004i#!\u0001+\u0012\u00059\n\u0004C\u0001\u000e0\u0013\t\u00014DA\u0004O_RD\u0017N\\4\u0011\u0005i\u0011\u0014BA\u001a\u001c\u0005\r\te.\u001f\u0005\u0006?\r\u0001\r!I\u0001\bKb,7-\u001e;f+\u0005I\u0013AC4fi\n{W\u000eV3yiV\t\u0011\b\u0005\u0002;\u0003:\u00111h\u0010\t\u0003ymi\u0011!\u0010\u0006\u0003}Y\ta\u0001\u0010:p_Rt\u0014B\u0001!\u001c\u0003\u0019\u0001&/\u001a3fM&\u0011!i\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0001[\u0012aC<sSR,Gk\u001c$jY\u0016$2AR%X!\tQr)\u0003\u0002I7\t!QK\\5u\u0011\u0015Qe\u00011\u0001L\u0003!!Wm\u001d;GS2,\u0007C\u0001'T\u001d\ti\u0005K\u0004\u0002=\u001d&\tq*A\u0002tERL!!\u0015*\u0002\u000fA\f7m[1hK*\tq*\u0003\u0002U+\n!a)\u001b7f\u0013\t1&K\u0001\u0004J[B|'\u000f\u001e\u0005\u00061\u001a\u0001\r!O\u0001\u0005i\u0016DH/A\bwC2LG-\u0019;f\u0005>lg)\u001b7f)\t15\fC\u0003]\u000f\u0001\u00071*A\u0004c_64\u0015\u000e\\3\u0002\u00151|wMQ8n\u0013:4w\u000e\u0006\u0003G?&t\u0007\"\u00021\t\u0001\u0004\t\u0017!D:dQ\u0016l\u0017MV3sg&|g\u000e\u0005\u0002cO6\t1M\u0003\u0002eK\u0006I1-_2m_:,G\r\u001f\u0006\u0002M\u0006\u0019qN]4\n\u0005!\u001c'a\u0002,feNLwN\u001c\u0005\u0006U\"\u0001\ra[\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u0011\u00051c\u0017BA7V\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\")q\u000e\u0003a\u0001a\u0006\u0019!m\\7\u0011\u0005E$X\"\u0001:\u000b\u0005M\u001c\u0017!B7pI\u0016d\u0017BA;s\u0005\r\u0011u.\\\u0001\u0007e\u0016\u0004xN\u001d;\u0016\u0003a\u0004\"\u0001T=\n\u0005i,&\u0001D+qI\u0006$XMU3q_J$\u0018\u0001F2veJ,g\u000e^\"p]\u001aLw-\u001e:bi&|g.F\u0001l\u0003\rawnZ\u000b\u0002\u007fB\u0019A*!\u0001\n\u0007\u0005\rQK\u0001\u0004M_\u001e<WM]\u000b\u0002C\u0002")
public abstract class BomTask<T> {
    private Version schemaVersion;
    private final BomTaskProperties properties;
    private volatile boolean bitmap$0;

    public BomTaskProperties properties() {
        return this.properties;
    }

    public abstract T execute();

    public String getBomText() {
        Bom bom = new BomExtractor(this.schemaVersion(), this.currentConfiguration(), this.report(), this.log()).bom();
        String bomText = this.properties().jsonFormat() ? BomGeneratorFactory.createJson((Version)this.schemaVersion(), (Bom)bom).toJsonString() : BomGeneratorFactory.createXml((Version)this.schemaVersion(), (Bom)bom).toXmlString();
        this.logBomInfo(this.schemaVersion(), this.currentConfiguration(), bom);
        return bomText;
    }

    public void writeToFile(File destFile, String text) {
        FileUtils.write((File)destFile, (CharSequence)text, (Charset)Charset.forName("UTF-8"), (boolean)false);
    }

    public void validateBomFile(File bomFile) {
        Object parser = this.properties().jsonFormat() ? new JsonParser() : new XmlParser();
        Buffer exceptions = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(((Parser)parser).validate(bomFile, this.schemaVersion())).asScala();
        if (exceptions.nonEmpty()) {
            String message = new StringBuilder(82).append("The BOM file ").append(bomFile.getAbsolutePath()).append(" does not conform to the CycloneDX BOM standard as defined by the XSD").toString();
            this.log().error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(1).append(message).append(":").toString());
            exceptions.foreach((Function1 & Serializable & scala.Serializable)exception -> {
                BomTask.$anonfun$validateBomFile$2(this, exception);
                return BoxedUnit.UNIT;
            });
            throw new BomError(message);
        }
    }

    public void logBomInfo(Version schemaVersion, Configuration configuration, Bom bom) {
        this.log().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Schema version: ").append(schemaVersion.getVersionString()).toString());
        this.log().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Serial number : ").append(bom.getSerialNumber()).toString());
        this.log().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Scope         : ").append(configuration.id()).toString());
    }

    public UpdateReport report() {
        return this.properties().report();
    }

    public Configuration currentConfiguration() {
        return this.properties().currentConfiguration();
    }

    public Logger log() {
        return this.properties().log();
    }

    private Version schemaVersion$lzycompute() {
        BomTask bomTask = this;
        synchronized (bomTask) {
            if (!this.bitmap$0) {
                Option<Version> option = SchemaVersions$.MODULE$.supportedVersionByName(this.properties().schemaVersion());
                if (!(option instanceof Some)) {
                    if (None$.MODULE$.equals(option)) {
                        String message = new StringBuilder(27).append("Unsupported schema version ").append(this.properties().schemaVersion()).toString();
                        this.log().error((Function0 & Serializable & scala.Serializable)() -> message);
                        throw new BomError(message);
                    }
                    throw new MatchError(option);
                }
                Some some = (Some)option;
                Version foundVersion = (Version)some.value();
                this.schemaVersion = foundVersion;
                this.bitmap$0 = true;
            }
        }
        return this.schemaVersion;
    }

    public Version schemaVersion() {
        if (!this.bitmap$0) {
            return this.schemaVersion$lzycompute();
        }
        return this.schemaVersion;
    }

    public static final /* synthetic */ void $anonfun$validateBomFile$2(BomTask $this, ParseException exception) {
        $this.log().error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(2).append("- ").append(exception.getMessage()).toString());
    }

    public BomTask(BomTaskProperties properties) {
        this.properties = properties;
    }
}

