/*
 * Decompiled with CFR 0.152.
 */
package de.lhns.common.s3;

import blobstore.Store;
import blobstore.s3.S3Blob;
import blobstore.s3.S3Blob$;
import blobstore.s3.S3MetaInfo;
import blobstore.s3.S3MetaInfo$;
import blobstore.url.Authority;
import blobstore.url.Path;
import blobstore.url.Path$;
import blobstore.url.Url;
import cats.effect.kernel.Async;
import cats.effect.std.AtomicCell;
import cats.syntax.ApplyOps$;
import cats.syntax.package;
import de.lhns.common.s3.FakeS3BlobStore$;
import de.lhns.common.s3.FakeS3BlobStore$Key$;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Stream;
import fs2.Stream$;
import java.io.Serializable;
import java.time.Instant;
import scala.Function1;
import scala.IArray;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.ArraySeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.ChainingOps$;
import scala.util.hashing.MurmurHash3$;
import scala.util.package;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;

public class FakeS3BlobStore<F>
implements Store<F, S3Blob> {
    private final AtomicCell objects;
    private final Async<F> evidence$1;

    public static <F> Object apply(Async<F> async) {
        return FakeS3BlobStore$.MODULE$.apply(async);
    }

    public FakeS3BlobStore(AtomicCell<F, Map<Key, Tuple2<byte[], S3Blob>>> objects, Async<F> evidence$1) {
        this.objects = objects;
        this.evidence$1 = evidence$1;
    }

    private AtomicCell<F, Map<Key, Tuple2<byte[], S3Blob>>> objects() {
        return this.objects;
    }

    public <A> Stream<F, Url<S3Blob>> list(Url<A> url, boolean recursive) {
        String bucket = url.authority().toString();
        java.nio.file.Path prefix = url.path().nioPath();
        if (recursive) {
            return Stream$.MODULE$.evalSeq(this.filesWhere$1(url, (Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                Key entryKey = (Key)tuple2._1();
                if (tuple2._2() == null) throw new MatchError((Object)tuple2);
                String string = entryKey.bucket();
                String string2 = bucket;
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                if (entryKey.prefix().nioPath().startsWith(prefix)) return true;
                if (prefix.startsWith("")) return true;
                if (!prefix.startsWith("/")) return false;
                return true;
            }));
        }
        return Stream$.MODULE$.evalSeq(package.all$.MODULE$.toFlatMapOps(this.filesWhere$1(url, (Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Key entryKey = (Key)tuple2._1();
            if (tuple2._2() == null) throw new MatchError((Object)tuple2);
            String string = entryKey.bucket();
            String string2 = bucket;
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!entryKey.prefix().nioPath().startsWith(prefix)) return false;
            if (entryKey.prefix().nioPath().relativize(prefix).getNameCount() != 1) return false;
            return true;
        }), this.evidence$1).flatMap((Function1 & Serializable)files -> package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFunctorOps(this.objects().get(), this.evidence$1).map((Function1 & Serializable)_$3 -> (Seq)((IterableOps)((SeqOps)((IterableOps)_$3.toSeq().filter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Key entryKey = (Key)tuple2._1();
            if (tuple2._2() == null) throw new MatchError((Object)tuple2);
            String string = entryKey.bucket();
            String string2 = bucket;
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!entryKey.prefix().nioPath().startsWith(prefix)) return false;
            if (prefix.relativize(entryKey.prefix().nioPath()).getNameCount() <= 1) return false;
            return true;
        })).map((Function1 & Serializable)entry -> {
            String folderName = prefix.relativize(((Key)entry._1()).prefix().nioPath()).getName(0).toString();
            return Path$.MODULE$.createRootless(new StringBuilder(1).append(FakeS3BlobStore$.MODULE$.de$lhns$common$s3$FakeS3BlobStore$$$names(prefix.resolve(folderName)).mkString("/")).append("/").toString());
        })).distinct()).map((Function1 & Serializable)folderPath -> {
            Path path = folderPath.as((Object)S3Blob$.MODULE$.apply(bucket, new StringBuilder(1).append(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(folderPath.toString()), "/")).append("/").toString(), (Option)None$.MODULE$));
            String string = url.copy$default$1();
            Authority authority = url.copy$default$2();
            return url.copy(string, authority, path);
        })), this.evidence$1).map((Function1 & Serializable)folders -> (Seq)files.$plus$plus((IterableOnce)folders))));
    }

    public boolean list$default$2() {
        return false;
    }

    public <A> Stream<F, Object> get(Url<A> url, int chunkSize) {
        return Stream$.MODULE$.evalSeq(package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFunctorOps(this.objects().get(), this.evidence$1).map((Function1 & Serializable)_$4 -> (byte[])_$4.get((Object)FakeS3BlobStore$Key$.MODULE$.apply(url.authority().toString(), (Path<Object>)url.path())).map((Function1 & Serializable)_$5 -> (byte[])_$5._1()).getOrElse(() -> FakeS3BlobStore.get$$anonfun$1$$anonfun$2(url))), this.evidence$1).map((Function1 & Serializable)iarr -> ArraySeq$.MODULE$.unsafeWrapArray((Object)IArray.package.IArray$.MODULE$.wrapByteIArray(iarr).unsafeArray())));
    }

    public <A> Function1<Stream<F, Object>, Stream<F, BoxedUnit>> put(Url<A> url, boolean overwrite, Option<Object> size) {
        return (Function1 & Serializable)input -> {
            Object object = package.chaining$.MODULE$.scalaUtilChainingOps(package.all$.MODULE$.toFlatMapOps(input.compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.evidence$1))).toVector(), this.evidence$1).flatMap((Function1 & Serializable)bytes -> {
                String bucket = url.authority().toString();
                Path prefix = url.path();
                Key key = FakeS3BlobStore$Key$.MODULE$.apply(bucket, (Path<Object>)prefix);
                Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(bytes.length())));
                Some some2 = Some$.MODULE$.apply((Object)Instant.now());
                Option option = S3MetaInfo$.MODULE$.const$default$1();
                Option option2 = S3MetaInfo$.MODULE$.const$default$3();
                Option option3 = S3MetaInfo$.MODULE$.const$default$5();
                boolean bl = S3MetaInfo$.MODULE$.const$default$6();
                Option option4 = S3MetaInfo$.MODULE$.const$default$7();
                Option option5 = S3MetaInfo$.MODULE$.const$default$8();
                Option option6 = S3MetaInfo$.MODULE$.const$default$9();
                Option option7 = S3MetaInfo$.MODULE$.const$default$10();
                Option option8 = S3MetaInfo$.MODULE$.const$default$11();
                Option option9 = S3MetaInfo$.MODULE$.const$default$12();
                Option option10 = S3MetaInfo$.MODULE$.const$default$13();
                Option option11 = S3MetaInfo$.MODULE$.const$default$14();
                Option option12 = S3MetaInfo$.MODULE$.const$default$15();
                Option option13 = S3MetaInfo$.MODULE$.const$default$16();
                Option option14 = S3MetaInfo$.MODULE$.const$default$17();
                Option option15 = S3MetaInfo$.MODULE$.const$default$18();
                Option option16 = S3MetaInfo$.MODULE$.const$default$19();
                Option option17 = S3MetaInfo$.MODULE$.const$default$20();
                Map map = S3MetaInfo$.MODULE$.const$default$21();
                Option option18 = S3MetaInfo$.MODULE$.const$default$22();
                Option option19 = S3MetaInfo$.MODULE$.const$default$23();
                Option option20 = S3MetaInfo$.MODULE$.const$default$24();
                Option option21 = S3MetaInfo$.MODULE$.const$default$25();
                Option option22 = S3MetaInfo$.MODULE$.const$default$26();
                Option option23 = S3MetaInfo$.MODULE$.const$default$27();
                Option option24 = S3MetaInfo$.MODULE$.const$default$28();
                Option option25 = S3MetaInfo$.MODULE$.const$default$29();
                Option option26 = S3MetaInfo$.MODULE$.const$default$30();
                Option option27 = S3MetaInfo$.MODULE$.const$default$31();
                Option option28 = S3MetaInfo$.MODULE$.const$default$32();
                Option option29 = S3MetaInfo$.MODULE$.const$default$33();
                Option option30 = S3MetaInfo$.MODULE$.const$default$34();
                Option option31 = S3MetaInfo$.MODULE$.const$default$35();
                S3MetaInfo s3MetaInfo = S3MetaInfo$.MODULE$.const(option, (Option)some, option2, (Option)some2, option3, bl, option4, option5, option6, option7, option8, option9, option10, option11, option12, option13, option14, option15, option16, option17, map, option18, option19, option20, option21, option22, option23, option24, option25, option26, option27, option28, option29, option30, option31);
                return this.objects().update((Function1 & Serializable)objects -> {
                    if (!overwrite && objects.contains((Object)key)) {
                        throw new IllegalArgumentException(new StringBuilder(30).append("File at path '").append(url).append("' already exist.").toString());
                    }
                    Key key = (Key)Predef$.MODULE$.ArrowAssoc((Object)key);
                    return (Map)objects.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)key, (Object)Tuple2$.MODULE$.apply(IArray.package.IArray$.MODULE$.from((IterableOnce)bytes, ClassTag$.MODULE$.apply(Byte.TYPE)), (Object)S3Blob$.MODULE$.apply(bucket, prefix.toString(), (Option)Some$.MODULE$.apply((Object)s3MetaInfo)))));
                });
            }));
            return (Stream)ChainingOps$.MODULE$.pipe$extension(object, (Function1 & Serializable)fo -> Stream$.MODULE$.eval(fo));
        };
    }

    public boolean put$default$2() {
        return true;
    }

    public <A> Option<Object> put$default$3() {
        return None$.MODULE$;
    }

    public <A, B> F move(Url<A> src, Url<B> dst) {
        Object object = package.all$.MODULE$.catsSyntaxApplyOps(this.copy(src, dst));
        return (F)ApplyOps$.MODULE$.$times$greater$extension(object, this.objects().update((Function1 & Serializable)_$6 -> (Map)_$6.$minus((Object)FakeS3BlobStore$Key$.MODULE$.apply(src.authority().toString(), (Path<Object>)src.path()))), this.evidence$1);
    }

    public <A, B> F copy(Url<A> src, Url<B> dst) {
        return (F)this.objects().update((Function1 & Serializable)objects -> {
            Tuple2 tuple2;
            Key srcKey = FakeS3BlobStore$Key$.MODULE$.apply(src.authority().toString(), (Path<Object>)src.path());
            Key dstKey = FakeS3BlobStore$Key$.MODULE$.apply(dst.authority().toString(), (Path<Object>)dst.path());
            Option option = objects.get((Object)srcKey);
            if (None$.MODULE$.equals(option)) {
                throw NoSuchKeyException.builder().message(new StringBuilder(13).append("No such key: ").append(src).toString()).build();
            }
            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                byte[] bytes = (byte[])tuple2._1();
                Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(IArray.package.IArray$.MODULE$.length(bytes))));
                Some some2 = Some$.MODULE$.apply((Object)Instant.now());
                Option option2 = S3MetaInfo$.MODULE$.const$default$1();
                Option option3 = S3MetaInfo$.MODULE$.const$default$3();
                Option option4 = S3MetaInfo$.MODULE$.const$default$5();
                boolean bl = S3MetaInfo$.MODULE$.const$default$6();
                Option option5 = S3MetaInfo$.MODULE$.const$default$7();
                Option option6 = S3MetaInfo$.MODULE$.const$default$8();
                Option option7 = S3MetaInfo$.MODULE$.const$default$9();
                Option option8 = S3MetaInfo$.MODULE$.const$default$10();
                Option option9 = S3MetaInfo$.MODULE$.const$default$11();
                Option option10 = S3MetaInfo$.MODULE$.const$default$12();
                Option option11 = S3MetaInfo$.MODULE$.const$default$13();
                Option option12 = S3MetaInfo$.MODULE$.const$default$14();
                Option option13 = S3MetaInfo$.MODULE$.const$default$15();
                Option option14 = S3MetaInfo$.MODULE$.const$default$16();
                Option option15 = S3MetaInfo$.MODULE$.const$default$17();
                Option option16 = S3MetaInfo$.MODULE$.const$default$18();
                Option option17 = S3MetaInfo$.MODULE$.const$default$19();
                Option option18 = S3MetaInfo$.MODULE$.const$default$20();
                Map map = S3MetaInfo$.MODULE$.const$default$21();
                Option option19 = S3MetaInfo$.MODULE$.const$default$22();
                Option option20 = S3MetaInfo$.MODULE$.const$default$23();
                Option option21 = S3MetaInfo$.MODULE$.const$default$24();
                Option option22 = S3MetaInfo$.MODULE$.const$default$25();
                Option option23 = S3MetaInfo$.MODULE$.const$default$26();
                Option option24 = S3MetaInfo$.MODULE$.const$default$27();
                Option option25 = S3MetaInfo$.MODULE$.const$default$28();
                Option option26 = S3MetaInfo$.MODULE$.const$default$29();
                Option option27 = S3MetaInfo$.MODULE$.const$default$30();
                Option option28 = S3MetaInfo$.MODULE$.const$default$31();
                Option option29 = S3MetaInfo$.MODULE$.const$default$32();
                Option option30 = S3MetaInfo$.MODULE$.const$default$33();
                Option option31 = S3MetaInfo$.MODULE$.const$default$34();
                Option option32 = S3MetaInfo$.MODULE$.const$default$35();
                S3MetaInfo s3MetaInfo = S3MetaInfo$.MODULE$.const(option2, (Option)some, option3, (Option)some2, option4, bl, option5, option6, option7, option8, option9, option10, option11, option12, option13, option14, option15, option16, option17, option18, map, option19, option20, option21, option22, option23, option24, option25, option26, option27, option28, option29, option30, option31, option32);
                Key key = (Key)Predef$.MODULE$.ArrowAssoc((Object)dstKey);
                return (Map)objects.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)key, (Object)Tuple2$.MODULE$.apply((Object)bytes, (Object)S3Blob$.MODULE$.apply(dstKey.bucket(), dstKey.prefix().toString(), (Option)Some$.MODULE$.apply((Object)s3MetaInfo)))));
            }
            throw new MatchError((Object)option);
        });
    }

    public <A> F remove(Url<A> url, boolean recursive) {
        Key key = FakeS3BlobStore$Key$.MODULE$.apply(url.authority().toString(), (Path<Object>)url.path());
        return (F)this.objects().update((Function1 & Serializable)objects -> {
            Option option = objects.get((Object)key);
            if (None$.MODULE$.equals(option)) {
                throw NoSuchKeyException.builder().message(new StringBuilder(13).append("No such key: ").append(url).toString()).build();
            }
            if (option instanceof Some) {
                return (Map)objects.$minus((Object)key);
            }
            throw new MatchError((Object)option);
        });
    }

    public <A> Function1<Stream<F, Object>, Stream<F, BoxedUnit>> putRotate(F computeUrl, long limit) {
        throw new UnsupportedOperationException("unimplemented");
    }

    public <A> Stream<F, Url<S3Blob>> stat(Url<A> url) {
        return Stream$.MODULE$.eval(package.all$.MODULE$.toFunctorOps(this.objects().get(), this.evidence$1).map((Function1 & Serializable)_$7 -> {
            Option option = _$7.get((Object)FakeS3BlobStore$Key$.MODULE$.apply(url.authority().toString(), (Path<Object>)url.path()));
            if (None$.MODULE$.equals(option)) {
                throw NoSuchKeyException.builder().message(new StringBuilder(13).append("No such key: ").append(url).toString()).build();
            }
            if (option instanceof Some) {
                Tuple2 entry = (Tuple2)((Some)option).value();
                Path path = url.path().as(entry._2());
                String string = url.copy$default$1();
                Authority authority = url.copy$default$2();
                return url.copy(string, authority, path);
            }
            throw new MatchError((Object)option);
        }));
    }

    private final Object filesWhere$1(Url url$2, Function1 p) {
        return package.all$.MODULE$.toFunctorOps(this.objects().get(), this.evidence$1).map((Function1 & Serializable)_$2 -> (Seq)((IterableOps)_$2.toSeq().filter(p)).map((Function1 & Serializable)entry -> {
            Path path = Path$.MODULE$.apply(((Key)entry._1()).prefix().toString()).as(((Tuple2)entry._2())._2());
            String string = url$2.copy$default$1();
            Authority authority = url$2.copy$default$2();
            return url$2.copy(string, authority, path);
        }));
    }

    private static final byte[] get$$anonfun$1$$anonfun$2(Url url$8) {
        throw NoSuchKeyException.builder().message(new StringBuilder(13).append("No such key: ").append(url$8).toString()).build();
    }

    public static class Key
    implements Product,
    Serializable {
        private final String bucket;
        private final Path prefix;

        public static Key apply(String string, Path<Object> path) {
            return FakeS3BlobStore$Key$.MODULE$.apply(string, path);
        }

        public static Key fromProduct(Product product) {
            return FakeS3BlobStore$Key$.MODULE$.fromProduct(product);
        }

        public static Key unapply(Key key) {
            return FakeS3BlobStore$Key$.MODULE$.unapply(key);
        }

        public Key(String bucket, Path<Object> prefix) {
            this.bucket = bucket;
            this.prefix = prefix;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, -601151043, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Key)) return false;
            Key key = (Key)object;
            String string = this.bucket();
            String string2 = key.bucket();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Path<Object> path = this.prefix();
            Path<Object> path2 = key.prefix();
            if (path == null) {
                if (path2 != null) {
                    return false;
                }
            } else if (!path.equals(path2)) return false;
            if (!key.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Key;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Key";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "bucket";
            }
            if (1 == n2) {
                return "prefix";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String bucket() {
            return this.bucket;
        }

        public Path<Object> prefix() {
            return this.prefix;
        }

        public Key copy(String bucket, Path<Object> prefix) {
            return new Key(bucket, prefix);
        }

        public String copy$default$1() {
            return this.bucket();
        }

        public Path<Object> copy$default$2() {
            return this.prefix();
        }

        public String _1() {
            return this.bucket();
        }

        public Path<Object> _2() {
            return this.prefix();
        }
    }
}

