/*
 * Decompiled with CFR 0.152.
 */
package de.lolhens.jstubber;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.function.Predicate;

public class Stubber {
    private final Predicate<ImportDeclaration> filterImports;
    private final Predicate<TypeDeclaration<?>> filterTypes;
    private final Predicate<MethodDeclaration> filterMethods;
    private static final BlockStmt unsupportedOperationBlock = new BlockStmt();
    public static final Stubber MIXIN;

    public Stubber(Predicate<ImportDeclaration> predicate, Predicate<TypeDeclaration<?>> predicate2, Predicate<MethodDeclaration> predicate3) {
        this.filterImports = predicate;
        this.filterTypes = predicate2;
        this.filterMethods = predicate3;
    }

    public CompilationUnit stub(CompilationUnit compilationUnit) {
        new ArrayList<Comment>(compilationUnit.getAllComments()).forEach(Comment::remove);
        new ArrayList(compilationUnit.getTypes()).stream().filter(this.filterTypes.negate()).forEach(Node::remove);
        compilationUnit.findAll(MethodDeclaration.class).forEach(methodDeclaration -> {
            boolean bl = methodDeclaration.getParentNode().flatMap(node -> node.findFirst(ClassOrInterfaceDeclaration.class)).filter(ClassOrInterfaceDeclaration::isInterface).isPresent();
            if (!this.filterMethods.test((MethodDeclaration)methodDeclaration)) {
                methodDeclaration.remove();
            } else if (!methodDeclaration.isAbstract() && !bl) {
                methodDeclaration.setBody(unsupportedOperationBlock);
            }
        });
        new ArrayList(compilationUnit.getImports()).stream().filter(this.filterImports.negate()).forEach(Node::remove);
        if (compilationUnit.getTypes().isEmpty()) {
            return null;
        }
        return compilationUnit;
    }

    public void stubFile(Path path, Path path2) throws IOException {
        CompilationUnit compilationUnit = StaticJavaParser.parse((Path)path);
        CompilationUnit compilationUnit2 = this.stub(compilationUnit);
        if (compilationUnit2 != null) {
            String string = compilationUnit.toString();
            Files.write(path2, string.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
    }

    public void stubDirectory(Path path, Path path2) throws IOException {
        try {
            Files.walk(path, new FileVisitOption[0]).forEach(path3 -> {
                if (path3.getFileName().toString().endsWith(".java")) {
                    Path path4 = path2.resolve(path.relativize((Path)path3));
                    try {
                        Files.createDirectories(path4.getParent(), new FileAttribute[0]);
                        this.stubFile((Path)path3, path4);
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                }
            });
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException.getCause() instanceof IOException) {
                throw (IOException)runtimeException.getCause();
            }
            throw runtimeException;
        }
    }

    static {
        unsupportedOperationBlock.addStatement(StaticJavaParser.parseStatement((String)"throw new UnsupportedOperationException();"));
        MIXIN = new Stubber(importDeclaration -> importDeclaration.getNameAsString().startsWith("java.") || importDeclaration.getNameAsString().startsWith("org.spongepowered.") || importDeclaration.getNameAsString().startsWith("net.minecraft."), typeDeclaration -> typeDeclaration.isAnnotationPresent("Mixin"), methodDeclaration -> methodDeclaration.getAnnotations().isNonEmpty());
    }
}

