/*
 * Decompiled with CFR 0.152.
 */
package com.github.difflib.algorithm.myers;

import com.github.difflib.algorithm.Change;
import com.github.difflib.algorithm.DiffAlgorithm;
import com.github.difflib.algorithm.DiffAlgorithmListener;
import com.github.difflib.algorithm.DiffException;
import com.github.difflib.algorithm.DifferentiationFailedException;
import com.github.difflib.algorithm.myers.MyersDiff$;
import com.github.difflib.algorithm.myers.PathNode;
import com.github.difflib.algorithm.myers.PathNode$;
import com.github.difflib.patch.DeltaType$Change$;
import com.github.difflib.patch.DeltaType$Delete$;
import com.github.difflib.patch.DeltaType$Insert$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005%c\u0001\u0002\u0006\f\u0001YA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\u0006i\u0001!\t!\u000e\u0005\u0006s\u0001!\tE\u000f\u0005\u0006s\u0002!IA\u001f\u0005\b\u00037\u0001A\u0011BA\u000f\u000f%\t\u0019cCA\u0001\u0012\u0003\t)C\u0002\u0005\u000b\u0017\u0005\u0005\t\u0012AA\u0014\u0011\u0019!t\u0001\"\u0001\u0002*!A1nBI\u0001\n\u0003\tYCA\u0005Ns\u0016\u00148\u000fR5gM*\u0011A\"D\u0001\u0006[f,'o\u001d\u0006\u0003\u001d=\t\u0011\"\u00197h_JLG\u000f[7\u000b\u0005A\t\u0012a\u00023jM\u001ad\u0017N\u0019\u0006\u0003%M\taaZ5uQV\u0014'\"\u0001\u000b\u0002\u0007\r|Wn\u0001\u0001\u0016\u0005]!3c\u0001\u0001\u0019=A\u0011\u0011\u0004H\u0007\u00025)\t1$A\u0003tG\u0006d\u0017-\u0003\u0002\u001e5\t1\u0011I\\=SK\u001a\u00042a\b\u0011#\u001b\u0005i\u0011BA\u0011\u000e\u00055!\u0015N\u001a4BY\u001e|'/\u001b;i[B\u00111\u0005\n\u0007\u0001\t\u0015)\u0003A1\u0001'\u0005\u0005!\u0016CA\u0014+!\tI\u0002&\u0003\u0002*5\t9aj\u001c;iS:<\u0007CA\r,\u0013\ta#DA\u0002B]f\fa!Z9vC2\u001c\b#B\r0E\t\n\u0014B\u0001\u0019\u001b\u0005%1UO\\2uS>t'\u0007\u0005\u0002\u001ae%\u00111G\u0007\u0002\b\u0005>|G.Z1o\u0003\u0019a\u0014N\\5u}Q\u0011a\u0007\u000f\t\u0004o\u0001\u0011S\"A\u0006\t\u000f5\u0012\u0001\u0013!a\u0001]\u0005Y1m\\7qkR,G)\u001b4g)\u0011Y$jT)\u0011\u0007q\"uI\u0004\u0002>\u0005:\u0011a(Q\u0007\u0002\u007f)\u0011\u0001)F\u0001\u0007yI|w\u000e\u001e \n\u0003mI!a\u0011\u000e\u0002\u000fA\f7m[1hK&\u0011QI\u0012\u0002\u0005\u0019&\u001cHO\u0003\u0002D5A\u0011q\u0004S\u0005\u0003\u00136\u0011aa\u00115b]\u001e,\u0007\"B&\u0004\u0001\u0004a\u0015AB:pkJ\u001cW\rE\u0002=\u001b\nJ!A\u0014$\u0003\u0007M+\u0017\u000fC\u0003Q\u0007\u0001\u0007A*\u0001\u0004uCJ<W\r\u001e\u0005\b%\u000e\u0001\n\u00111\u0001T\u0003!\u0001(o\\4sKN\u001c\bCA\u0010U\u0013\t)VBA\u000bES\u001a4\u0017\t\\4pe&$\b.\u001c'jgR,g.\u001a:)\u0007\r9V\fE\u0002\u001a1jK!!\u0017\u000e\u0003\rQD'o\\<t!\ty2,\u0003\u0002]\u001b\tiA)\u001b4g\u000bb\u001cW\r\u001d;j_:\fDA\b0gqB\u0011ql\u0019\b\u0003A\u0006\u0004\"A\u0010\u000e\n\u0005\tT\u0012A\u0002)sK\u0012,g-\u0003\u0002eK\n11\u000b\u001e:j]\u001eT!A\u0019\u000e2\u000b\r:'n]6\u0016\u0005!LW#\u00010\u0005\u000b\u0015*\"\u0019\u00018\n\u0005-d\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013G\u0003\u0002n5\u00051A\u000f\u001b:poN\f\"aJ8\u0011\u0005A\fhBA\rC\u0013\t\u0011hIA\u0005UQJ|w/\u00192mKF*1\u0005^;w[:\u0011\u0011$^\u0005\u0003[j\tDAI\r\u001bo\n)1oY1mCF\u0012aEW\u0001\nEVLG\u000e\u001a)bi\"$ba\u001f@\u0002\u0002\u0005\u0015\u0001CA\u001c}\u0013\ti8B\u0001\u0005QCRDgj\u001c3f\u0011\u0015yH\u00011\u0001M\u0003\u0011y'/[4\t\r\u0005\rA\u00011\u0001M\u0003\r\u0011XM\u001e\u0005\u0006%\u0012\u0001\ra\u0015\u0015\u0006\t\u0005%\u0011\u0011\u0003\t\u00053a\u000bY\u0001E\u0002 \u0003\u001bI1!a\u0004\u000e\u0005y!\u0015N\u001a4fe\u0016tG/[1uS>tg)Y5mK\u0012,\u0005pY3qi&|g.\r\u0004\u001f=\u0006M\u0011\u0011D\u0019\u0007G\u001dT\u0017QC62\r\r\"X/a\u0006nc\u0011\u0011\u0013DG<2\u0007\u0019\nY!A\u0007ck&dGMU3wSNLwN\u001c\u000b\u0004w\u0005}\u0001BBA\u0011\u000b\u0001\u000710\u0001\u0006bGR,\u0018\r\u001c)bi\"\f\u0011\"T=feN$\u0015N\u001a4\u0011\u0005]:1CA\u0004\u0019)\t\t)#\u0006\u0003\u0002.\u0005URCAA\u0018U\u0011\t\t$a\u000e\u0011\u000fey\u00131GA\u001acA\u00191%!\u000e\u0005\u000b\u0015J!\u0019\u0001\u0014,\u0005\u0005e\u0002\u0003BA\u001e\u0003\u000bj!!!\u0010\u000b\t\u0005}\u0012\u0011I\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0011\u001b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u000f\niDA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class MyersDiff<T>
implements DiffAlgorithm<T> {
    private final Function2<T, T, Object> equals;

    public static <T> Function2<T, T, Object> $lessinit$greater$default$1() {
        return MyersDiff$.MODULE$.$lessinit$greater$default$1();
    }

    @Override
    public DiffAlgorithmListener computeDiff$default$3() {
        return DiffAlgorithm.computeDiff$default$3$(this);
    }

    public List<Change> computeDiff(Seq<T> source, Seq<T> target, DiffAlgorithmListener progress) throws DiffException {
        progress.diffStart();
        PathNode path = this.buildPath(source, target, progress);
        List<Change> result = this.buildRevision(path);
        progress.diffEnd();
        return result;
    }

    private PathNode buildPath(Seq<T> orig, Seq<T> rev, DiffAlgorithmListener progress) throws DifferentiationFailedException {
        Object object = new Object();
        try {
            int N = orig.size();
            int M = rev.size();
            int MAX = N + M + 1;
            int size = 1 + 2 * MAX;
            int middle = size / 2;
            PathNode[] diagonal = new PathNode[size];
            diagonal[middle + 1] = PathNode$.MODULE$.apply(0, -1, true, true, null);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), MAX).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)d -> {
                progress.diffStep(d, MAX);
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(-d), d).by(2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> {
                    int j;
                    PathNode pathNode;
                    int kmiddle = middle + k;
                    int kplus = kmiddle + 1;
                    int kminus = kmiddle - 1;
                    int i = 0;
                    if (k == -d || k != d && diagonal[kminus].i() < diagonal[kplus].i()) {
                        i = diagonal[kplus].i();
                        pathNode = diagonal[kplus];
                    } else {
                        i = diagonal[kminus].i() + 1;
                        pathNode = diagonal[kminus];
                    }
                    PathNode prev = pathNode;
                    diagonal$1[kminus] = null;
                    PathNode node = PathNode$.MODULE$.apply(i, j, false, false, prev);
                    for (j = i - k; i < N && j < M && BoxesRunTime.unboxToBoolean((Object)$this.equals.apply(orig.apply(i), rev.apply(j))); ++i, ++j) {
                    }
                    PathNode pathNode2 = diagonal$1[kmiddle] = i != node.i() ? PathNode$.MODULE$.apply(i, j, true, false, node) : node;
                    if (i >= N && j >= M) {
                        throw new NonLocalReturnControl(object, (Object)diagonal[kmiddle]);
                    }
                });
                diagonal$1[middle$1 + d - 1] = null;
            });
            throw new DifferentiationFailedException("could not find a diff path");
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return (PathNode)ex.value();
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<Change> buildRevision(PathNode actualPath) {
        void var3_3;
        PathNode path = actualPath;
        Nil$ changes = Nil$.MODULE$;
        if (path.isSnake()) {
            path = path.prev();
        }
        while (path != null && path.prev() != null && path.prev().j() >= 0) {
            if (path.isSnake()) {
                throw new IllegalStateException("bad diffpath: found snake when looking for diff");
            }
            int i = path.i();
            int j = path.j();
            path = path.prev();
            int ianchor = path.i();
            int janchor = path.j();
            if (ianchor == i && janchor != j) {
                Change change = new Change(DeltaType$Insert$.MODULE$, ianchor, i, janchor, j);
                changes = changes.$colon$colon((Object)change);
            } else if (ianchor != i && janchor == j) {
                Change change = new Change(DeltaType$Delete$.MODULE$, ianchor, i, janchor, j);
                changes = changes.$colon$colon((Object)change);
            } else {
                Change change = new Change(DeltaType$Change$.MODULE$, ianchor, i, janchor, j);
                changes = changes.$colon$colon((Object)change);
            }
            if (!path.isSnake()) continue;
            path = path.prev();
        }
        return var3_3;
    }

    public MyersDiff(Function2<T, T, Object> equals) {
        this.equals = equals;
    }
}

