/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisApi;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.mashape.unirest.request.GetRequest;
import com.mashape.unirest.request.HttpRequest;
import de.malkusch.whoisApi.RecoverableWhoisApiException;
import de.malkusch.whoisApi.WhoisApiException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Scanner;
import javax.annotation.concurrent.ThreadSafe;
import org.json.JSONArray;

@ThreadSafe
public class WhoisApi {
    private final String apiKey;
    private final URI baseUri;
    private static final String DEFAULT_BASE_URI = "https://whois-v0.p.mashape.com/";
    private static final String API_KEY_HEADER = "X-Mashape-Key";

    public WhoisApi(String apiKey) {
        this(apiKey, URI.create(DEFAULT_BASE_URI));
    }

    public WhoisApi(String apiKey, URI baseUri) {
        if (apiKey == null || baseUri == null) {
            throw new NullPointerException();
        }
        if (apiKey.isEmpty()) {
            throw new IllegalArgumentException("API key is empty");
        }
        this.apiKey = apiKey;
        this.baseUri = baseUri;
    }

    public boolean isAvailable(String domain) throws RecoverableWhoisApiException {
        if (domain == null) {
            throw new NullPointerException();
        }
        if (domain.isEmpty()) {
            throw new IllegalArgumentException("Domain is empty.");
        }
        String uri = this.baseUri.toString() + "/check?domain={domain}";
        GetRequest request = Unirest.get((String)uri).routeParam("domain", domain);
        return ((JsonNode)this.sendRequest((HttpRequest)request, () -> ((HttpRequest)request).asJson())).getObject().getBoolean("available");
    }

    public String whois(String domain) throws RecoverableWhoisApiException {
        if (domain == null) {
            throw new NullPointerException();
        }
        if (domain.isEmpty()) {
            throw new IllegalArgumentException("Domain is empty.");
        }
        String uri = this.baseUri.toString() + "/check?domain={domain}";
        GetRequest request = Unirest.get((String)uri).routeParam("domain", domain);
        return ((JsonNode)this.sendRequest((HttpRequest)request, () -> ((HttpRequest)request).asJson())).getObject().getString("whoisResponse");
    }

    public InputStream query(String host, String query) throws RecoverableWhoisApiException {
        if (host == null || query == null) {
            throw new NullPointerException();
        }
        if (host.isEmpty() || query.isEmpty()) {
            throw new IllegalArgumentException("Host and query should not be empty.");
        }
        String uri = this.baseUri.toString() + "/whois?host={host}&query={query}";
        GetRequest request = Unirest.get((String)uri).routeParam("host", host).routeParam("query", query);
        return (InputStream)this.sendRequest((HttpRequest)request, () -> ((HttpRequest)request).asBinary());
    }

    public Collection<String> domains() {
        JSONArray response;
        String uri = this.baseUri.toString() + "/domains";
        GetRequest request = Unirest.get((String)uri);
        try {
            response = ((JsonNode)this.sendRequest((HttpRequest)request, () -> ((HttpRequest)request).asJson())).getArray();
        }
        catch (RecoverableWhoisApiException e) {
            throw new IllegalStateException(e);
        }
        String[] domains = new String[response.length()];
        for (int i = 0; i < response.length(); ++i) {
            domains[i] = response.getString(i);
        }
        return Arrays.asList(domains);
    }

    private <T> T sendRequest(HttpRequest request, RequestCall<T> requestCall) throws RecoverableWhoisApiException {
        HttpResponse<T> response;
        request.header(API_KEY_HEADER, this.apiKey);
        try {
            response = requestCall.call();
        }
        catch (UnirestException e) {
            throw new WhoisApiException(e);
        }
        switch (response.getStatus()) {
            case 200: {
                return (T)response.getBody();
            }
            case 502: 
            case 504: {
                String message = String.format("Try again (%d): %s", response.getStatus(), WhoisApi.convert(response));
                throw new RecoverableWhoisApiException(message);
            }
        }
        String message2 = String.format("API failed (%d): %s", response.getStatus(), WhoisApi.convert(response));
        throw new WhoisApiException(message2);
    }

    private static String convert(HttpResponse<?> response) {
        try (Scanner scanner = new Scanner(response.getRawBody());){
            scanner.useDelimiter("\\A");
            String string = scanner.hasNext() ? scanner.next() : "";
            return string;
        }
    }

    private static interface RequestCall<T> {
        public HttpResponse<T> call() throws UnirestException;
    }
}

