/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisApi;

import de.malkusch.whoisApi.CheckResult;
import de.malkusch.whoisApi.RecoverableWhoisApiException;
import de.malkusch.whoisApi.WhoisApiException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.IOUtils;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@ThreadSafe
public class WhoisApi
implements Closeable {
    private final String apiKey;
    private final URI baseUri;
    private final CloseableHttpClient client;
    private static final String DEFAULT_BASE_URI = "https://whois-v0.p.mashape.com/";
    private static final String API_KEY_HEADER = "X-Mashape-Key";

    public WhoisApi(String apiKey) {
        this(apiKey, URI.create(DEFAULT_BASE_URI));
    }

    public WhoisApi(String apiKey, URI baseUri) {
        if (apiKey == null || baseUri == null) {
            throw new NullPointerException();
        }
        if (apiKey.isEmpty()) {
            throw new IllegalArgumentException("API key is empty");
        }
        this.apiKey = apiKey;
        this.baseUri = baseUri;
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setDefaultMaxPerRoute(100);
        cm.setMaxTotal(200);
        this.client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CheckResult check(String domain) throws RecoverableWhoisApiException {
        URI uri;
        if (domain == null) {
            throw new NullPointerException();
        }
        if (domain.isEmpty()) {
            throw new IllegalArgumentException("Domain is empty.");
        }
        try {
            uri = URI.create(this.baseUri.toString() + "/check?domain=" + URLEncoder.encode(domain, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        try (InputStream response = this.sendRequest(uri);){
            CheckResult result;
            JSONObject json = new JSONObject(IOUtils.toString((InputStream)response));
            CheckResult checkResult = result = new CheckResult(json.getBoolean("available"), json.getString("whoisResponse"));
            return checkResult;
        }
        catch (IOException e) {
            throw new RecoverableWhoisApiException(e);
        }
    }

    public boolean isAvailable(String domain) throws RecoverableWhoisApiException {
        return this.check(domain).isAvailable();
    }

    public String whois(String domain) throws RecoverableWhoisApiException {
        return this.check(domain).whoisResponse();
    }

    public InputStream query(String host, String query) throws RecoverableWhoisApiException {
        if (host == null || query == null) {
            throw new NullPointerException();
        }
        if (host.isEmpty() || query.isEmpty()) {
            throw new IllegalArgumentException("Host and query should not be empty.");
        }
        try {
            URI uri = URI.create(this.baseUri.toString() + "/whois?host=" + URLEncoder.encode(host, "UTF-8") + "&query=" + URLEncoder.encode(query, "UTF-8"));
            return this.sendRequest(uri);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<String> domains() throws RecoverableWhoisApiException {
        URI uri = URI.create(this.baseUri.toString() + "/domains");
        try (InputStream response = this.sendRequest(uri);){
            JSONArray array = new JSONArray(IOUtils.toString((InputStream)response));
            String[] domains = new String[array.length()];
            for (int i = 0; i < array.length(); ++i) {
                domains[i] = array.getString(i);
            }
            List<String> list = Arrays.asList(domains);
            return list;
        }
        catch (JSONException e) {
            throw new WhoisApiException(e);
        }
        catch (IOException e) {
            throw new RecoverableWhoisApiException(e);
        }
    }

    private InputStream sendRequest(URI uri) throws RecoverableWhoisApiException {
        try {
            HttpGet get = new HttpGet(uri);
            get.addHeader(API_KEY_HEADER, this.apiKey);
            CloseableHttpResponse response = this.client.execute((HttpUriRequest)get);
            StatusLine statusLine = response.getStatusLine();
            switch (statusLine.getStatusCode()) {
                case 200: {
                    return response.getEntity().getContent();
                }
                case 502: 
                case 504: {
                    String message = String.format("Try again (%d): %s", statusLine.getStatusCode(), statusLine.getReasonPhrase());
                    throw new RecoverableWhoisApiException(message);
                }
            }
            String message2 = String.format("API failed (%d): %s", statusLine.getStatusCode(), statusLine.getReasonPhrase());
            throw new WhoisApiException(message2);
        }
        catch (ClientProtocolException e) {
            throw new WhoisApiException(e);
        }
        catch (IOException e) {
            throw new RecoverableWhoisApiException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }
}

