/*
 * Decompiled with CFR 0.152.
 */
package de.marcoaust.prometheus;

import de.marcoaust.prometheus.PrometheusEndpoint;
import de.marcoaust.prometheus.SpringBootMetricsCollector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.hotspot.DefaultExports;
import java.util.Collection;
import org.springframework.boot.actuate.endpoint.PublicMetrics;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

class PrometheusConfiguration {
    private CollectorRegistry collectorRegistry = CollectorRegistry.defaultRegistry;

    PrometheusConfiguration() {
    }

    @Bean
    public SpringBootMetricsCollector springBootMetricsCollector(Collection<PublicMetrics> publicMetrics) {
        SpringBootMetricsCollector springBootMetricsCollector = new SpringBootMetricsCollector(publicMetrics);
        springBootMetricsCollector.register(this.collectorRegistry);
        return springBootMetricsCollector;
    }

    @Bean
    public PrometheusEndpoint prometheusEndpoint() {
        return new PrometheusEndpoint(this.collectorRegistry);
    }

    @Configuration
    @ConditionalOnClass(value={DefaultExports.class})
    @ConditionalOnProperty(prefix="prometheus.hotspot", name={"enabled"}, matchIfMissing=true)
    static class HotspotMetricsExporter {
        public HotspotMetricsExporter() {
            DefaultExports.initialize();
        }
    }
}

