/*
 * Decompiled with CFR 0.152.
 */
package de.marcoaust.prometheus;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="endpoints.prometheus")
class PrometheusEndpoint
extends AbstractEndpoint<String> {
    private static final Logger log = LoggerFactory.getLogger(PrometheusEndpoint.class);
    private final CollectorRegistry collectorRegistry;

    PrometheusEndpoint(CollectorRegistry collectorRegistry) {
        super("prometheus", true);
        this.collectorRegistry = collectorRegistry;
    }

    public String invoke() {
        try {
            StringWriter writer = new StringWriter();
            TextFormat.write004((Writer)writer, (Enumeration)this.collectorRegistry.metricFamilySamples());
            return ((Object)writer).toString();
        }
        catch (IOException e) {
            log.error("Writing metrics failed", (Throwable)e);
            return "";
        }
    }
}

