/*
 * Decompiled with CFR 0.152.
 */
package de.musichin.ktlint.reporter.github;

import com.pinterest.ktlint.cli.reporter.core.api.KtlintCliError;
import com.pinterest.ktlint.cli.reporter.core.api.ReporterV2;
import de.musichin.ktlint.reporter.github.Level;
import java.io.PrintStream;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/musichin/ktlint/reporter/github/GitHubReporter;", "Lcom/pinterest/ktlint/cli/reporter/core/api/ReporterV2;", "out", "Ljava/io/PrintStream;", "level", "Lde/musichin/ktlint/reporter/github/Level;", "(Ljava/io/PrintStream;Lde/musichin/ktlint/reporter/github/Level;)V", "getLevel", "()Lde/musichin/ktlint/reporter/github/Level;", "escape", "", "data", "onLintError", "", "file", "ktlintCliError", "Lcom/pinterest/ktlint/cli/reporter/core/api/KtlintCliError;", "ktlint-github-reporter"})
public final class GitHubReporter
implements ReporterV2 {
    @NotNull
    private final PrintStream out;
    @NotNull
    private final Level level;

    public GitHubReporter(@NotNull PrintStream out, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        this.out = out;
        this.level = level;
    }

    public /* synthetic */ GitHubReporter(PrintStream printStream, Level level, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            level = Level.ERROR;
        }
        this(printStream, level);
    }

    @NotNull
    public final Level getLevel() {
        return this.level;
    }

    public void onLintError(@NotNull String file, @NotNull KtlintCliError ktlintCliError) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)ktlintCliError, (String)"ktlintCliError");
        if (this.level == Level.NONE) {
            return;
        }
        if (ktlintCliError.getStatus() == KtlintCliError.Status.FORMAT_IS_AUTOCORRECTED) {
            return;
        }
        int line = ktlintCliError.getLine();
        int column = ktlintCliError.getCol();
        String message = this.escape(ktlintCliError.getDetail());
        String string = this.level.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String command = string;
        this.out.println("::" + command + " file=" + file + ",line=" + line + ",col=" + column + "::" + message);
    }

    private final String escape(String data) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)data, (String)"%", (String)"%25", (boolean)false, (int)4, null), (String)"\r", (String)"%0D", (boolean)false, (int)4, null), (String)"\n", (String)"%0A", (boolean)false, (int)4, null);
    }

    public void after(@NotNull String file) {
        ReporterV2.DefaultImpls.after((ReporterV2)this, (String)file);
    }

    public void afterAll() {
        ReporterV2.DefaultImpls.afterAll((ReporterV2)this);
    }

    public void before(@NotNull String file) {
        ReporterV2.DefaultImpls.before((ReporterV2)this, (String)file);
    }

    public void beforeAll() {
        ReporterV2.DefaultImpls.beforeAll((ReporterV2)this);
    }
}

