/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.jade4j.compiler;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang3.StringUtils;

public class IndentWriter {
    private int indent = 0;
    private boolean useIndent = false;
    private boolean empty = true;
    private Writer writer;

    public IndentWriter(Writer writer) {
        this.writer = writer;
    }

    public IndentWriter add(String string) {
        return this.append(string);
    }

    public IndentWriter append(String string) {
        this.write(string);
        return this;
    }

    public void increment() {
        ++this.indent;
    }

    public void decrement() {
        --this.indent;
    }

    private void write(String string) {
        try {
            this.writer.write(string);
            this.empty = false;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return this.writer.toString();
    }

    public void newline() {
        if (this.useIndent && !this.empty) {
            this.write("\n" + StringUtils.repeat((String)"  ", (int)this.indent));
        }
    }

    public void setUseIndent(boolean useIndent) {
        this.useIndent = useIndent;
    }
}

