/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.jade4j.parser;

import de.neuland.jade4j.exceptions.JadeParserException;
import de.neuland.jade4j.expression.ExpressionHandler;
import de.neuland.jade4j.lexer.Assignment;
import de.neuland.jade4j.lexer.Each;
import de.neuland.jade4j.lexer.Lexer;
import de.neuland.jade4j.lexer.token.Attribute;
import de.neuland.jade4j.lexer.token.AttributeList;
import de.neuland.jade4j.lexer.token.AttributesBlock;
import de.neuland.jade4j.lexer.token.Block;
import de.neuland.jade4j.lexer.token.BlockCode;
import de.neuland.jade4j.lexer.token.Call;
import de.neuland.jade4j.lexer.token.CaseToken;
import de.neuland.jade4j.lexer.token.Colon;
import de.neuland.jade4j.lexer.token.Comment;
import de.neuland.jade4j.lexer.token.CssClass;
import de.neuland.jade4j.lexer.token.CssId;
import de.neuland.jade4j.lexer.token.Default;
import de.neuland.jade4j.lexer.token.Doctype;
import de.neuland.jade4j.lexer.token.Dot;
import de.neuland.jade4j.lexer.token.Else;
import de.neuland.jade4j.lexer.token.ElseIf;
import de.neuland.jade4j.lexer.token.Eos;
import de.neuland.jade4j.lexer.token.Expression;
import de.neuland.jade4j.lexer.token.ExtendsToken;
import de.neuland.jade4j.lexer.token.Filter;
import de.neuland.jade4j.lexer.token.If;
import de.neuland.jade4j.lexer.token.Include;
import de.neuland.jade4j.lexer.token.Indent;
import de.neuland.jade4j.lexer.token.Interpolation;
import de.neuland.jade4j.lexer.token.Mixin;
import de.neuland.jade4j.lexer.token.MixinBlock;
import de.neuland.jade4j.lexer.token.Newline;
import de.neuland.jade4j.lexer.token.Outdent;
import de.neuland.jade4j.lexer.token.PipelessText;
import de.neuland.jade4j.lexer.token.Tag;
import de.neuland.jade4j.lexer.token.Text;
import de.neuland.jade4j.lexer.token.Token;
import de.neuland.jade4j.lexer.token.When;
import de.neuland.jade4j.lexer.token.While;
import de.neuland.jade4j.lexer.token.Yield;
import de.neuland.jade4j.parser.PathHelper;
import de.neuland.jade4j.parser.node.AssigmentNode;
import de.neuland.jade4j.parser.node.Attr;
import de.neuland.jade4j.parser.node.AttrsNode;
import de.neuland.jade4j.parser.node.BlockCommentNode;
import de.neuland.jade4j.parser.node.BlockNode;
import de.neuland.jade4j.parser.node.CaseConditionNode;
import de.neuland.jade4j.parser.node.CaseNode;
import de.neuland.jade4j.parser.node.CommentNode;
import de.neuland.jade4j.parser.node.ConditionalNode;
import de.neuland.jade4j.parser.node.DoctypeNode;
import de.neuland.jade4j.parser.node.EachNode;
import de.neuland.jade4j.parser.node.ExpressionNode;
import de.neuland.jade4j.parser.node.FilterNode;
import de.neuland.jade4j.parser.node.IfConditionNode;
import de.neuland.jade4j.parser.node.LiteralNode;
import de.neuland.jade4j.parser.node.MixinBlockNode;
import de.neuland.jade4j.parser.node.MixinNode;
import de.neuland.jade4j.parser.node.Node;
import de.neuland.jade4j.parser.node.TagNode;
import de.neuland.jade4j.parser.node.TextNode;
import de.neuland.jade4j.parser.node.WhileNode;
import de.neuland.jade4j.template.TemplateLoader;
import de.neuland.jade4j.util.CharacterParser;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class Parser {
    public static final Pattern FILE_EXTENSION_PATTERN = Pattern.compile(".*\\.\\w+$");
    private Lexer lexer;
    private LinkedHashMap<String, BlockNode> blocks = new LinkedHashMap();
    private String[] textOnlyTags = new String[]{"script", "style"};
    private Integer _spaces = null;
    private String basePath;
    private final TemplateLoader templateLoader;
    private ExpressionHandler expressionHandler;
    private Parser extending;
    private final String filename;
    private LinkedList<Parser> contexts = new LinkedList();
    private CharacterParser characterParser;
    private int inMixin = 0;
    private HashMap<String, MixinNode> mixins = new HashMap();
    private int inBlock = 0;
    private PathHelper pathHelper = new PathHelper();

    public Parser(String filename, String basePath, TemplateLoader templateLoader, ExpressionHandler expressionHandler) throws IOException {
        this.filename = filename;
        this.basePath = basePath;
        this.templateLoader = templateLoader;
        this.expressionHandler = expressionHandler;
        this.lexer = new Lexer(filename, templateLoader, expressionHandler);
        this.characterParser = new CharacterParser();
        this.getContexts().push(this);
    }

    public Parser(String src, String filename, String basePath, TemplateLoader templateLoader, ExpressionHandler expressionHandler) throws IOException {
        this.filename = filename;
        this.basePath = basePath;
        this.templateLoader = templateLoader;
        this.expressionHandler = expressionHandler;
        this.lexer = new Lexer(src, filename, templateLoader, expressionHandler);
        this.characterParser = new CharacterParser();
        this.getContexts().push(this);
    }

    public Node parse() {
        BlockNode block = new BlockNode();
        block.setLineNumber(this.lexer.getLineno());
        block.setFileName(this.filename);
        while (!(this.peek() instanceof Eos)) {
            if (this.peek() instanceof Newline) {
                this.advance();
                continue;
            }
            Node expr = this.parseExpr();
            if (expr == null) continue;
            block.push(expr);
        }
        if (this.extending != null) {
            this.getContexts().push(this.extending);
            Node rootNode = this.extending.parse();
            this.getContexts().pop();
            Set<String> keySet = this.mixins.keySet();
            for (String name : keySet) {
                rootNode.getNodes().push(this.mixins.get(name));
            }
            return rootNode;
        }
        return block;
    }

    private Node parseExpr() {
        Token token = this.peek();
        if (token instanceof Tag) {
            return this.parseTag();
        }
        if (token instanceof Mixin) {
            return this.parseMixin();
        }
        if (token instanceof Block) {
            return this.parseBlock();
        }
        if (token instanceof MixinBlock) {
            return this.parseMixinBlock();
        }
        if (token instanceof CaseToken) {
            return this.parseCase();
        }
        if (token instanceof ExtendsToken) {
            return this.parseExtends();
        }
        if (token instanceof Include) {
            return this.parseInclude();
        }
        if (token instanceof Doctype) {
            return this.parseDoctype();
        }
        if (token instanceof Filter) {
            return this.parseFilter();
        }
        if (token instanceof Comment) {
            return this.parseComment();
        }
        if (token instanceof Text) {
            return this.parseText();
        }
        if (token instanceof Each) {
            return this.parseEach();
        }
        if (token instanceof Expression) {
            return this.parseCode();
        }
        if (token instanceof BlockCode) {
            return this.parseBlockCode();
        }
        if (token instanceof Call) {
            return this.parseCall();
        }
        if (token instanceof Interpolation) {
            return this.parseInterpolation();
        }
        if (token instanceof Yield) {
            return this.parseYield();
        }
        if (token instanceof CssClass || token instanceof CssId) {
            return this.parseCssClassOrId();
        }
        if (token instanceof While) {
            return this.parseWhile();
        }
        if (token instanceof If) {
            return this.parseConditional();
        }
        if (token instanceof Assignment) {
            return this.parseAssignment();
        }
        throw new JadeParserException(this.filename, this.lexer.getLineno(), this.templateLoader, token);
    }

    private Node parseBlockCode() {
        String text;
        Token tok = this.expect(BlockCode.class);
        Token body = this.peek();
        if (body instanceof PipelessText) {
            this.advance();
            text = StringUtils.join(body.getValues(), (String)"\n");
        } else {
            text = "";
        }
        ExpressionNode node = new ExpressionNode();
        node.setValue(text);
        node.setLineNumber(tok.getLineNumber());
        return node;
    }

    private Node parseComment() {
        Token token = this.expect(Comment.class);
        Node block = this.parseTextBlock();
        if (block != null) {
            BlockCommentNode node = new BlockCommentNode();
            node.setBlock(block);
            node.setBuffered(token.isBuffer());
            node.setLineNumber(token.getLineNumber());
            node.setFileName(this.filename);
            node.setValue(token.getValue());
            return node;
        }
        CommentNode node = new CommentNode();
        node.setBuffered(token.isBuffer());
        node.setLineNumber(token.getLineNumber());
        node.setFileName(this.filename);
        node.setValue(token.getValue());
        return node;
    }

    private Node parseMixin() {
        Matcher matcher;
        List<String> args;
        Mixin mixinToken = (Mixin)this.expect(Mixin.class);
        MixinNode node = new MixinNode();
        node.setName(mixinToken.getValue());
        node.setLineNumber(mixinToken.getLineNumber());
        node.setFileName(this.filename);
        if (StringUtils.isNotBlank((CharSequence)mixinToken.getArguments())) {
            node.setArguments(mixinToken.getArguments());
        }
        if ((args = node.getArguments()).size() > 0 && (matcher = Pattern.compile("^\\.\\.\\.").matcher(args.get(args.size() - 1).trim())).find(0)) {
            String rest = args.remove(args.size() - 1).trim().replaceAll("^\\.\\.\\.", "");
            node.setRest(rest);
        }
        if (this.peek() instanceof Indent) {
            ++this.inMixin;
            node.setBlock(this.block());
            node.setCall(false);
            this.mixins.put(mixinToken.getValue(), node);
            --this.inMixin;
            return node;
        }
        node.setCall(true);
        return node;
    }

    private Node parseCall() {
        Token token = this.expect(Call.class);
        Call callToken = (Call)token;
        MixinNode mixin = new MixinNode();
        mixin.setBlock(new BlockNode());
        mixin.setName(callToken.getValue());
        mixin.setLineNumber(callToken.getLineNumber());
        mixin.setFileName(this.filename);
        mixin.setCall(true);
        if (StringUtils.isNotBlank((CharSequence)callToken.getArguments())) {
            mixin.setArguments(callToken.getArguments());
        }
        this.tag(mixin);
        if (mixin.hasCodeNode()) {
            mixin.getBlock().push(mixin.getCodeNode());
            mixin.setCodeNode(null);
        }
        if (mixin.hasBlock() && mixin.getBlock().getNodes().isEmpty()) {
            mixin.setBlock(null);
        }
        return mixin;
    }

    private Node parseCssClassOrId() {
        Token tok = this.advance();
        Tag div = new Tag("div", this.line());
        this.lexer.defer(div);
        this.lexer.defer(tok);
        return this.parseExpr();
    }

    private Node parseBlock() {
        BlockNode blockNode;
        Token token = this.expect(Block.class);
        Block block = (Block)token;
        String mode = block.getMode();
        String name = block.getValue().trim();
        ++this.inBlock;
        if (this.peek() instanceof Indent) {
            blockNode = this.block();
        } else {
            blockNode = new BlockNode();
            blockNode.setLineNumber(block.getLineNumber());
            blockNode.setFileName(this.filename);
            LiteralNode node = new LiteralNode();
            node.setValue("");
            blockNode.push(node);
        }
        --this.inBlock;
        blockNode.setName(name);
        blockNode.setLineNumber(this.line());
        BlockNode prev = this.blocks.get(name) == null ? new BlockNode() : this.blocks.get(name);
        if ("replace".equals(prev.getMode())) {
            this.blocks.put(name, prev);
            return prev;
        }
        LinkedList<Node> allNodes = new LinkedList<Node>();
        allNodes.addAll(prev.getPrepended());
        allNodes.addAll(blockNode.getNodes());
        allNodes.addAll(prev.getAppended());
        if ("append".equals(mode)) {
            LinkedList<Node> appendedNodes = new LinkedList<Node>();
            if (prev.getParser() == this) {
                appendedNodes.addAll(prev.getAppended());
                appendedNodes.addAll(blockNode.getNodes());
            } else {
                appendedNodes.addAll(blockNode.getNodes());
                appendedNodes.addAll(prev.getAppended());
            }
            prev.setAppended(appendedNodes);
        } else if ("prepend".equals(mode)) {
            LinkedList<Node> prependedNodes = new LinkedList<Node>();
            if (prev.getParser() == this) {
                prependedNodes.addAll(blockNode.getNodes());
                prependedNodes.addAll(prev.getPrepended());
            } else {
                prependedNodes.addAll(prev.getPrepended());
                prependedNodes.addAll(blockNode.getNodes());
            }
            prev.setPrepended(prependedNodes);
        }
        blockNode.setNodes(allNodes);
        blockNode.setAppended(prev.getAppended());
        blockNode.setPrepended(prev.getPrepended());
        blockNode.setMode(mode);
        blockNode.setParser(this);
        blockNode.setSubBlock(this.inBlock > 0);
        this.blocks.put(name, blockNode);
        return blockNode;
    }

    private Node parseMixinBlock() {
        Token tok = this.expect(MixinBlock.class);
        if (this.inMixin == 0) {
            throw new JadeParserException(this.filename, this.lexer.getLineno(), this.templateLoader, "Anonymous blocks are not allowed unless they are part of a mixin.");
        }
        return new MixinBlockNode();
    }

    private Node parseInclude() {
        Token token = this.expect(Include.class);
        Include includeToken = (Include)token;
        String templateName = includeToken.getValue().trim();
        String path = this.pathHelper.resolvePath(this.filename, templateName, this.basePath);
        try {
            if (includeToken.getFilter() != null) {
                Reader reader = this.templateLoader.getReader(path);
                FilterNode node = new FilterNode();
                node.setValue(includeToken.getFilter());
                node.setLineNumber(this.line());
                node.setFileName(this.filename);
                TextNode text = new TextNode();
                text.setValue(IOUtils.toString((Reader)reader));
                BlockNode block = new BlockNode();
                LinkedList<Node> nodes = new LinkedList<Node>();
                nodes.add(text);
                block.setNodes(nodes);
                if (block != null) {
                    node.setTextBlock(block);
                } else {
                    node.setTextBlock(new BlockNode());
                }
                return node;
            }
        }
        catch (IOException e) {
            throw new JadeParserException(this.filename, this.lexer.getLineno(), this.templateLoader, "the included file [" + templateName + "] could not be opened\n" + e.getMessage());
        }
        String extension = FilenameUtils.getExtension((String)path);
        if (!"jade".equals(extension)) {
            try {
                Reader reader = this.templateLoader.getReader(path);
                LiteralNode node = new LiteralNode();
                node.setLineNumber(this.lexer.getLineno());
                node.setFileName(this.filename);
                node.setValue(IOUtils.toString((Reader)reader));
                return node;
            }
            catch (IOException e) {
                throw new JadeParserException(this.filename, this.lexer.getLineno(), this.templateLoader, "the included file [" + templateName + "] could not be opened\n" + e.getMessage());
            }
        }
        Parser parser = this.createParser(templateName);
        parser.setBlocks(new LinkedHashMap<String, BlockNode>(this.blocks));
        parser.setMixins(this.mixins);
        this.contexts.push(parser);
        Node ast = parser.parse();
        this.contexts.pop();
        ast.setFileName(path);
        if (this.peek() instanceof Indent && ast != null) {
            ((BlockNode)ast).getIncludeBlock().push(this.block());
        }
        return ast;
    }

    private Node parseExtends() {
        Token token = this.expect(ExtendsToken.class);
        ExtendsToken extendsToken = (ExtendsToken)token;
        String templateName = extendsToken.getValue().trim();
        Parser parser = this.createParser(templateName);
        parser.setBlocks(this.blocks);
        parser.setContexts(this.contexts);
        this.extending = parser;
        LiteralNode node = new LiteralNode();
        node.setValue("");
        return node;
    }

    private Parser createParser(String templateName) {
        templateName = this.ensureJadeExtension(templateName);
        try {
            return new Parser(this.pathHelper.resolvePath(this.filename, templateName, this.basePath), this.basePath, this.templateLoader, this.expressionHandler);
        }
        catch (IOException e) {
            throw new JadeParserException(this.filename, this.lexer.getLineno(), this.templateLoader, "the template [" + templateName + "] could not be opened\n" + e.getMessage());
        }
    }

    private String ensureJadeExtension(String templateName) {
        if (!"jade".equals(FilenameUtils.getExtension((String)templateName))) {
            return templateName + ".jade";
        }
        return templateName;
    }

    private BlockNode parseYield() {
        this.advance();
        BlockNode block = new BlockNode();
        block.setLineNumber(this.lexer.getLineno());
        block.setFileName(this.filename);
        block.setYield(true);
        return block;
    }

    private Node parseInterpolation() {
        Token token = this.advance();
        String name = token.getValue();
        TagNode tagNode = new TagNode();
        tagNode.setLineNumber(this.lexer.getLineno());
        tagNode.setFileName(this.filename);
        tagNode.setName(name);
        tagNode.setBuffer(true);
        return this.tag(tagNode);
    }

    private Node blockExpansion() {
        if (this.peek() instanceof Colon) {
            Token token = this.expect(Colon.class);
            Colon colon = (Colon)token;
            BlockNode block = new BlockNode();
            block.setLineNumber(colon.getLineNumber());
            block.setFileName(this.filename);
            block.getNodes().add(this.parseExpr());
            return block;
        }
        return this.block();
    }

    private BlockNode block() {
        BlockNode block = new BlockNode();
        block.setLineNumber(this.lexer.getLineno());
        block.setFileName(this.filename);
        this.expect(Indent.class);
        while (!(this.peek() instanceof Outdent)) {
            if (this.peek() instanceof Newline) {
                this.advance();
                continue;
            }
            Node parseExpr = this.parseExpr();
            parseExpr.setFileName(this.filename);
            if (parseExpr == null) continue;
            block.push(parseExpr);
        }
        this.expect(Outdent.class);
        return block;
    }

    private List<CaseConditionNode> whenBlock() {
        this.expect(Indent.class);
        LinkedList<CaseConditionNode> caseConditionalNodes = new LinkedList<CaseConditionNode>();
        while (!(this.peek() instanceof Outdent) && !(this.peek() instanceof Eos)) {
            if (this.peek() instanceof Newline) {
                this.advance();
                continue;
            }
            caseConditionalNodes.add(this.parseCaseCondition());
        }
        if (this.peek() instanceof Outdent) {
            this.expect(Outdent.class);
        }
        return caseConditionalNodes;
    }

    private Node parseText() {
        Token tok = this.expect(Text.class);
        Node[] tokens = this.parseInlineTagsInText(tok.getValue());
        if (tokens.length == 1) {
            return tokens[0];
        }
        BlockNode node = new BlockNode();
        for (int i = 0; i < tokens.length; ++i) {
            node.push(tokens[i]);
        }
        node.setValue(tok.getValue());
        node.setLineNumber(tok.getLineNumber());
        node.setFileName(this.filename);
        return node;
    }

    private Node parseEach() {
        Token token = this.expect(Each.class);
        Each eachToken = (Each)token;
        EachNode node = new EachNode();
        node.setValue(eachToken.getValue());
        node.setKey(eachToken.getKey());
        node.setCode(eachToken.getCode());
        node.setLineNumber(eachToken.getLineNumber());
        node.setFileName(this.filename);
        node.setBlock(this.block());
        if (this.peek() instanceof Else) {
            this.advance();
            node.setElseNode(this.block());
        }
        return node;
    }

    private Node parseWhile() {
        Token token = this.expect(While.class);
        While whileToken = (While)token;
        WhileNode node = new WhileNode();
        node.setValue(whileToken.getValue());
        node.setLineNumber(whileToken.getLineNumber());
        node.setFileName(this.filename);
        BlockNode block = this.block();
        if (block != null) {
            node.setBlock(block);
        } else {
            node.setBlock(new BlockNode());
        }
        return node;
    }

    private Node parseAssignment() {
        Token token = this.expect(Assignment.class);
        Assignment assignmentToken = (Assignment)token;
        AssigmentNode node = new AssigmentNode();
        node.setName(assignmentToken.getName());
        ((Node)node).setValue(assignmentToken.getValue());
        node.setLineNumber(assignmentToken.getLineNumber());
        node.setFileName(this.filename);
        return node;
    }

    private Node parseTag() {
        Token token = this.advance();
        String name = token.getValue();
        TagNode tagNode = new TagNode();
        tagNode.setLineNumber(this.lexer.getLineno());
        tagNode.setFileName(this.filename);
        tagNode.setName(name);
        tagNode.setValue(name);
        tagNode.setSelfClosing(token.isSelfClosing());
        return this.tag(tagNode);
    }

    private Node tag(AttrsNode tagNode) {
        Node block;
        boolean seenAttrs = false;
        block0: while (true) {
            Token tok;
            Token incomingToken;
            if ((incomingToken = this.peek()) instanceof CssId) {
                tok = this.advance();
                tagNode.setAttribute("id", tok.getValue(), false);
                continue;
            }
            if (incomingToken instanceof CssClass) {
                tok = this.advance();
                tagNode.setAttribute("class", tok.getValue(), false);
                continue;
            }
            if (incomingToken instanceof AttributeList) {
                if (seenAttrs) {
                    throw new JadeParserException(this.filename, this.line(), this.templateLoader, this.filename + ", line " + this.peek().getLineNumber() + ":\nYou should not have jade tags with multiple attributes.");
                }
                seenAttrs = true;
                tok = (AttributeList)this.advance();
                List<Attribute> attrs = ((AttributeList)tok).getAttributes();
                tagNode.setSelfClosing(tok.isSelfClosing());
                Iterator<Attribute> iterator = attrs.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block0;
                    Attribute attr = iterator.next();
                    String name = attr.getName();
                    Object value = attr.getValue();
                    tagNode.setAttribute(name, value, attr.isEscaped());
                }
            }
            if (!(incomingToken instanceof AttributesBlock)) break;
            tok = this.advance();
            tagNode.addAttributes(tok.getValue());
        }
        boolean dot = false;
        if (this.peek() instanceof Dot) {
            dot = true;
            tagNode.setTextOnly(true);
            this.advance();
        }
        if (this.peek() instanceof Text) {
            tagNode.getBlock().push(this.parseText());
        } else if (this.peek() instanceof Expression) {
            tagNode.setCodeNode(this.parseCode());
        } else if (this.peek() instanceof Colon) {
            Token next = this.advance();
            BlockNode block2 = new BlockNode();
            block2.setLineNumber(next.getLineNumber());
            block2.setFileName(this.filename);
            block2.push(this.parseExpr());
            tagNode.setBlock(block2);
        }
        while (this.peek() instanceof Newline) {
            this.advance();
        }
        if (tagNode.isTextOnly()) {
            block = this.parseTextBlock();
            if (block == null) {
                block = new BlockNode();
            }
            tagNode.setBlock(block);
        } else if (this.peek() instanceof Indent) {
            block = this.block();
            int len = block.getNodes().size();
            for (int i = 0; i < len; ++i) {
                tagNode.getBlock().push(block.getNodes().get(i));
            }
        }
        return tagNode;
    }

    private Node[] parseInlineTagsInText(String str) {
        int line = this.line();
        Matcher matcher = Pattern.compile("(\\\\)?#\\[((?:.|\\n)*)$").matcher(str);
        TextNode text = new TextNode();
        text.setLineNumber(line);
        text.setFileName(this.filename);
        if (matcher.find(0) && matcher.groupCount() > 1) {
            Object[] textNodes;
            if (matcher.group(1) != null) {
                text.setValue(str.substring(0, matcher.start()) + "#[");
                Object[] rest = this.parseInlineTagsInText(matcher.group(2));
                if (rest[0] instanceof TextNode) {
                    text.setValue(text.getValue() + rest[0].getValue());
                    rest = (Node[])ArrayUtils.remove((Object[])rest, (int)0);
                }
                Object[] textNodes2 = new Node[]{text};
                return (Node[])ArrayUtils.addAll((Object[])textNodes2, (Object[])rest);
            }
            text.setValue(str.substring(0, matcher.start()));
            Object[] buffer = textNodes = new Node[]{text};
            String rest = matcher.group(2);
            CharacterParser.Match range = null;
            try {
                range = this.characterParser.parseMax(rest);
            }
            catch (CharacterParser.SyntaxError syntaxError) {
                throw new JadeParserException(this.filename, line, this.templateLoader, " See " + matcher.group(0));
            }
            Parser inner = null;
            try {
                inner = new Parser(range.getSrc(), this.filename, this.basePath, this.templateLoader, this.expressionHandler);
            }
            catch (IOException e) {
                throw new JadeParserException(this.filename, line, this.templateLoader, "Could not parse text");
            }
            buffer = (Node[])ArrayUtils.add((Object[])buffer, (Object)inner.parse());
            return (Node[])ArrayUtils.addAll((Object[])buffer, (Object[])this.parseInlineTagsInText(rest.substring(range.getEnd() + 1)));
        }
        text.setValue(str);
        Node[] textNodes = new Node[]{text};
        return textNodes;
    }

    private Node parseTextBlock() {
        BlockNode blockNode = new BlockNode();
        blockNode.setLineNumber(this.line());
        blockNode.setFileName(this.filename);
        Token body = this.peek();
        if (!(body instanceof PipelessText)) {
            return null;
        }
        this.advance();
        ArrayList<String> values = body.getValues();
        Object[] textNodes = new Node[]{};
        for (String value : values) {
            textNodes = (Node[])ArrayUtils.addAll((Object[])textNodes, (Object[])this.parseInlineTagsInText(value));
        }
        blockNode.setNodes(new LinkedList<Node>(Arrays.asList(textNodes)));
        return blockNode;
    }

    private Node parseConditional() {
        Token token;
        If conditionalToken = (If)this.expect(If.class);
        ConditionalNode conditional = new ConditionalNode();
        conditional.setLineNumber(conditionalToken.getLineNumber());
        conditional.setFileName(this.filename);
        List<IfConditionNode> conditions = conditional.getConditions();
        IfConditionNode main = new IfConditionNode(conditionalToken.getValue(), conditionalToken.getLineNumber());
        main.setInverse(conditionalToken.isInverseCondition());
        main.setBlock(this.block());
        conditions.add(main);
        while (this.peek() instanceof ElseIf) {
            token = (ElseIf)this.expect(ElseIf.class);
            IfConditionNode elseIf = new IfConditionNode(token.getValue(), token.getLineNumber());
            elseIf.setBlock(this.block());
            conditions.add(elseIf);
        }
        if (this.peek() instanceof Else) {
            token = (Else)this.expect(Else.class);
            IfConditionNode elseNode = new IfConditionNode(null, token.getLineNumber());
            elseNode.setDefault(true);
            elseNode.setBlock(this.block());
            conditions.add(elseNode);
        }
        return conditional;
    }

    private Node parseBlockExpansion() {
        if (this.peek() instanceof Colon) {
            this.advance();
            BlockNode blockNode = new BlockNode();
            blockNode.push(this.parseExpr());
            return blockNode;
        }
        return this.block();
    }

    private Node parseCase() {
        String val = this.expect(CaseToken.class).getValue();
        CaseNode node = new CaseNode();
        node.setValue(val);
        node.setLineNumber(this.line());
        BlockNode block = new BlockNode();
        block.setLineNumber(this.line());
        block.setFileName(this.filename);
        this.expect(Indent.class);
        while (!(this.peek() instanceof Outdent)) {
            if (this.peek() instanceof Comment) {
                this.advance();
                continue;
            }
            if (this.peek() instanceof Newline) {
                this.advance();
                continue;
            }
            if (this.peek() instanceof When) {
                block.push(this.parseWhen());
                continue;
            }
            if (this.peek() instanceof Default) {
                block.push(this.parseDefault());
                continue;
            }
            throw new JadeParserException(this.filename, this.lexer.getLineno(), this.templateLoader, "Unexpected token \"" + this.peek() + "\", expected \"when\", \"default\" or \"newline\"");
        }
        this.expect(Outdent.class);
        node.setBlock(block);
        return node;
    }

    private Node parseWhen() {
        String val = this.expect(When.class).getValue();
        CaseNode.When when = new CaseNode.When();
        when.setValue(val);
        if (!(this.peek() instanceof Newline)) {
            when.setBlock(this.parseBlockExpansion());
        }
        return when;
    }

    private Node parseDefault() {
        this.expect(Default.class);
        CaseNode.When when = new CaseNode.When();
        when.setValue("default");
        when.setBlock(this.parseBlockExpansion());
        return when;
    }

    private CaseConditionNode parseCaseCondition() {
        CaseConditionNode node = new CaseConditionNode();
        Token token = null;
        if (this.peek() instanceof When) {
            token = this.expect(When.class);
        } else {
            token = this.expect(Default.class);
            node.setDefault(true);
        }
        node.setLineNumber(token.getLineNumber());
        node.setFileName(this.filename);
        node.setValue(token.getValue());
        node.setBlock(this.blockExpansion());
        return node;
    }

    private Node parseCode() {
        Token token = this.expect(Expression.class);
        Expression expressionToken = (Expression)token;
        ExpressionNode codeNode = new ExpressionNode();
        codeNode.setValue(expressionToken.getValue());
        codeNode.setBuffer(expressionToken.isBuffer());
        codeNode.setEscape(expressionToken.isEscape());
        codeNode.setLineNumber(expressionToken.getLineNumber());
        codeNode.setFileName(this.filename);
        boolean block = false;
        block = this.peek() instanceof Indent;
        if (block) {
            codeNode.setBlock(this.block());
        }
        return codeNode;
    }

    private Node parseDoctype() {
        Token token = this.expect(Doctype.class);
        Doctype doctype = (Doctype)token;
        DoctypeNode doctypeNode = new DoctypeNode();
        doctypeNode.setValue(doctype.getValue());
        return doctypeNode;
    }

    private Node parseFilter() {
        Token token = this.expect(Filter.class);
        Filter filterToken = (Filter)token;
        AttributeList attr = (AttributeList)this.accept(AttributeList.class);
        this.lexer.setPipeless(true);
        Node tNode = this.parseTextBlock();
        this.lexer.setPipeless(false);
        FilterNode node = new FilterNode();
        node.setValue(filterToken.getValue());
        node.setLineNumber(this.line());
        node.setFileName(this.filename);
        if (tNode != null) {
            node.setTextBlock(tNode);
        } else {
            node.setTextBlock(new BlockNode());
        }
        if (attr != null) {
            node.setAttributes(this.convertToNodeAttributes(attr));
        }
        return node;
    }

    private Node parseASTFilter() {
        Token token = this.expect(Filter.class);
        Filter filterToken = (Filter)token;
        AttributeList attr = (AttributeList)this.accept(AttributeList.class);
        token = this.expect(Colon.class);
        FilterNode node = new FilterNode();
        node.setValue(filterToken.getValue());
        node.setBlock(this.block());
        node.setLineNumber(this.line());
        node.setFileName(this.filename);
        node.setAttributes(this.convertToNodeAttributes(attr));
        return node;
    }

    private List<Attr> convertToNodeAttributes(AttributeList attr) {
        List<Attribute> attributes = attr.getAttributes();
        LinkedList<Attr> attributeNodes = new LinkedList<Attr>();
        for (Attribute attribute : attributes) {
            attributeNodes.add(new Attr(attribute.getName(), attribute.getValue(), attribute.isEscaped()));
        }
        return attributeNodes;
    }

    private Token lookahead(int i) {
        return this.lexer.lookahead(i);
    }

    private Token peek() {
        return this.lookahead(1);
    }

    private void skip(int n) {
        while (n > 0) {
            this.lexer.advance();
            --n;
        }
    }

    private Token advance() {
        return this.lexer.advance();
    }

    private Token accept(Class clazz) {
        if (this.peek().getClass().equals(clazz)) {
            return this.lexer.advance();
        }
        return null;
    }

    private int line() {
        return this.lexer.getLineno();
    }

    private Token expect(Class expectedTokenClass) {
        Token t = this.peek();
        if (t.getClass().equals(expectedTokenClass)) {
            return this.advance();
        }
        throw new JadeParserException(this.filename, this.lexer.getLineno(), this.templateLoader, expectedTokenClass, t.getClass());
    }

    public Map<String, BlockNode> getBlocks() {
        return this.blocks;
    }

    public void setBlocks(LinkedHashMap<String, BlockNode> blocks) {
        this.blocks = blocks;
    }

    public LinkedList<Parser> getContexts() {
        return this.contexts;
    }

    public void setContexts(LinkedList<Parser> contexts) {
        this.contexts = contexts;
    }

    public void setMixins(HashMap mixins) {
        this.mixins = mixins;
    }
}

