/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.jade4j.template;

import de.neuland.jade4j.Jade4J;
import de.neuland.jade4j.compiler.Compiler;
import de.neuland.jade4j.exceptions.JadeCompilerException;
import de.neuland.jade4j.expression.ExpressionHandler;
import de.neuland.jade4j.lexer.token.Doctypes;
import de.neuland.jade4j.model.JadeModel;
import de.neuland.jade4j.parser.node.Node;
import de.neuland.jade4j.template.TemplateLoader;
import java.io.Writer;

public class JadeTemplate {
    private boolean prettyPrint = false;
    private Node rootNode;
    private boolean terse = false;
    private boolean xml = false;
    private TemplateLoader templateLoader;
    private ExpressionHandler expressionHandler;
    private String doctypeLine;

    public void process(JadeModel model, Writer writer) throws JadeCompilerException {
        Compiler compiler = new Compiler(this.rootNode);
        compiler.setPrettyPrint(this.prettyPrint);
        compiler.setTemplate(this);
        compiler.setExpressionHandler(this.expressionHandler);
        compiler.compile(model, writer);
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(Node rootNode) {
        this.rootNode = rootNode;
    }

    public boolean isTerse() {
        return this.terse;
    }

    public boolean isXml() {
        return this.xml;
    }

    public void setTemplateLoader(TemplateLoader templateLoader) {
        this.templateLoader = templateLoader;
    }

    public TemplateLoader getTemplateLoader() {
        return this.templateLoader;
    }

    public void setDoctype(String name) {
        if (name == null) {
            name = "default";
        }
        this.doctypeLine = Doctypes.get(name);
        if (this.doctypeLine == null) {
            this.doctypeLine = "<!DOCTYPE " + name + ">";
        }
        this.terse = "<!doctype html>".equals(this.doctypeLine.toLowerCase());
        this.xml = this.doctypeLine.startsWith("<?xml");
    }

    public String getDoctypeLine() {
        return this.doctypeLine;
    }

    public void setMode(Jade4J.Mode mode) {
        this.xml = false;
        this.terse = false;
        switch (mode) {
            case HTML: {
                this.terse = true;
                break;
            }
            case XML: {
                this.xml = true;
            }
        }
    }

    public void setExpressionHandler(ExpressionHandler expressionHandler) {
        this.expressionHandler = expressionHandler;
    }

    public ExpressionHandler getExpressionHandler() {
        return this.expressionHandler;
    }
}

