/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt;

import com.auth0.jwt.JWTAlgorithmException;
import org.apache.commons.lang3.Validate;

public enum Algorithm {
    HS256("HmacSHA256"),
    HS384("HmacSHA384"),
    HS512("HmacSHA512"),
    RS256("SHA256withRSA"),
    RS384("SHA384withRSA"),
    RS512("SHA512withRSA");

    private String value;

    private Algorithm(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static Algorithm findByName(String name) throws JWTAlgorithmException {
        Validate.notNull((Object)name);
        try {
            return Algorithm.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            throw new JWTAlgorithmException("Unsupported algorithm: " + name);
        }
    }
}

