/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt;

import com.auth0.jwt.Algorithm;
import com.auth0.jwt.JWTAlgorithmException;
import com.auth0.jwt.JWTAudienceException;
import com.auth0.jwt.JWTExpiredException;
import com.auth0.jwt.JWTIssuerException;
import com.auth0.jwt.JWTVerifyException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.Validate;
import org.boon.json.JsonParserAndMapper;
import org.boon.json.JsonParserFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class JWTVerifier {
    private byte[] secret;
    private PublicKey publicKey;
    private final String audience;
    private final String issuer;
    private final Base64.Decoder decoder = Base64.getUrlDecoder();
    private final JsonParserAndMapper fastParser = new JsonParserFactory().createFastParser();

    public JWTVerifier(String secret, String audience, String issuer) {
        this(secret.getBytes(Charset.forName("UTF-8")), audience, issuer);
    }

    public JWTVerifier(String secret, String audience) {
        this(secret, audience, null);
    }

    public JWTVerifier(String secret) {
        this(secret, null, null);
    }

    public JWTVerifier(byte[] secret, String audience) {
        this(secret, audience, null);
    }

    public JWTVerifier(byte[] secret) {
        this(secret, null, null);
    }

    public JWTVerifier(byte[] secret, String audience, String issuer) {
        if (secret == null || secret.length == 0) {
            throw new IllegalArgumentException("Secret cannot be null or empty");
        }
        this.secret = secret;
        this.audience = audience;
        this.issuer = issuer;
    }

    public JWTVerifier(PublicKey publicKey, String audience, String issuer) {
        Validate.notNull((Object)publicKey);
        this.publicKey = publicKey;
        this.audience = audience;
        this.issuer = issuer;
    }

    public JWTVerifier(PublicKey publicKey, String audience) {
        this(publicKey, audience, null);
    }

    public JWTVerifier(PublicKey publicKey) {
        this(publicKey, null, null);
    }

    public Map<String, Object> verify(String token) throws NoSuchAlgorithmException, InvalidKeyException, IllegalStateException, IOException, SignatureException, JWTVerifyException {
        if (token == null || "".equals(token)) {
            throw new IllegalStateException("token not set");
        }
        String[] pieces = token.split("\\.");
        if (pieces.length != 3) {
            throw new IllegalStateException("Wrong number of segments: " + pieces.length);
        }
        Map jwtHeader = this.decodeAndParse(pieces[0]);
        Algorithm algorithm = this.getAlgorithm(jwtHeader);
        Map jwtPayload = this.decodeAndParse(pieces[1]);
        this.verifySignature(pieces, algorithm);
        this.verifyExpiration(jwtPayload);
        this.verifyIssuer(jwtPayload);
        this.verifyAudience(jwtPayload);
        return jwtPayload;
    }

    void verifySignature(String[] pieces, Algorithm algorithm) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, JWTAlgorithmException, IllegalStateException {
        Validate.notNull((Object)pieces);
        Validate.notNull((Object)((Object)algorithm));
        if (pieces.length != 3) {
            throw new IllegalStateException("Wrong number of segments: " + pieces.length);
        }
        switch (algorithm) {
            case HS256: 
            case HS384: 
            case HS512: {
                this.verifyHmac(algorithm, pieces, this.secret);
                return;
            }
            case RS256: 
            case RS384: 
            case RS512: {
                this.verifyRs(algorithm, pieces, this.publicKey);
                return;
            }
        }
        throw new JWTAlgorithmException("Unsupported signing method");
    }

    private void verifyHmac(Algorithm algorithm, String[] pieces, byte[] secret) throws SignatureException, NoSuchAlgorithmException, InvalidKeyException {
        if (secret == null || secret.length == 0) {
            throw new IllegalStateException("Secret cannot be null or empty when using algorithm: " + algorithm.getValue());
        }
        Mac hmac = Mac.getInstance(algorithm.getValue());
        hmac.init(new SecretKeySpec(secret, algorithm.getValue()));
        byte[] sig = hmac.doFinal((pieces[0] + "." + pieces[1]).getBytes());
        if (!MessageDigest.isEqual(sig, this.decoder.decode(pieces[2]))) {
            throw new SignatureException("signature verification failed");
        }
    }

    void verifyExpiration(Map<String, Object> jwtClaims) throws JWTExpiredException {
        if (!jwtClaims.containsKey("exp")) {
            return;
        }
        Object exp = jwtClaims.get("exp");
        long expiration = exp instanceof String ? Long.parseLong((String)exp) : (exp instanceof Number ? ((Number)exp).longValue() : 0L);
        if (expiration != 0L && System.currentTimeMillis() / 1000L >= expiration) {
            throw new JWTExpiredException("jwt expired", expiration);
        }
    }

    private void verifyRs(Algorithm algorithm, String[] pieces, PublicKey publicKey) throws SignatureException, NoSuchAlgorithmException, InvalidKeyException, JWTAlgorithmException {
        if (publicKey == null) {
            throw new IllegalStateException("PublicKey cannot be null when using algorithm: " + algorithm.getValue());
        }
        byte[] decodedSignatureBytes = this.decoder.decode(pieces[2]);
        byte[] headerPayloadBytes = (pieces[0] + "." + pieces[1]).getBytes();
        boolean verified = this.verifySignatureWithPublicKey(this.publicKey, headerPayloadBytes, decodedSignatureBytes, algorithm);
        if (!verified) {
            throw new SignatureException("signature verification failed");
        }
    }

    private boolean verifySignatureWithPublicKey(PublicKey publicKey, byte[] messageBytes, byte[] signatureBytes, Algorithm algorithm) throws InvalidKeyException, SignatureException, NoSuchAlgorithmException, JWTAlgorithmException {
        Validate.notNull((Object)publicKey);
        Validate.notNull((Object)messageBytes);
        Validate.notNull((Object)signatureBytes);
        Validate.notNull((Object)((Object)algorithm));
        try {
            Signature signature = Signature.getInstance(algorithm.getValue(), "BC");
            signature.initVerify(publicKey);
            signature.update(messageBytes);
            return signature.verify(signatureBytes);
        }
        catch (NoSuchProviderException e) {
            throw new JWTAlgorithmException(e.getMessage(), e.getCause());
        }
    }

    void verifyIssuer(Map<String, Object> jwtClaims) throws JWTIssuerException {
        String issuerFromToken;
        Validate.notNull(jwtClaims);
        if (this.issuer == null) {
            return;
        }
        String string = issuerFromToken = jwtClaims.containsKey("iss") ? jwtClaims.get("iss").toString() : null;
        if (issuerFromToken == null || !this.issuer.equals(issuerFromToken)) {
            throw new JWTIssuerException("jwt issuer invalid", issuerFromToken);
        }
    }

    void verifyAudience(Map<String, Object> jwtClaims) throws JWTAudienceException {
        Validate.notNull(jwtClaims);
        if (this.audience == null) {
            return;
        }
        Object audNode = jwtClaims.get("aud");
        if (audNode == null) {
            throw new JWTAudienceException("jwt audience invalid", (Object)null);
        }
        if (audNode instanceof List) {
            List audList = (List)audNode;
            for (Object audListElem : audList) {
                if (!this.audience.equals(audListElem.toString())) continue;
                return;
            }
        } else if (audNode instanceof String && this.audience.equals(audNode.toString())) {
            return;
        }
        throw new JWTAudienceException("jwt audience invalid", audNode);
    }

    Algorithm getAlgorithm(Map<String, Object> jwtHeader) throws JWTAlgorithmException {
        String algorithmName;
        Validate.notNull(jwtHeader);
        String string = algorithmName = jwtHeader.containsKey("alg") ? jwtHeader.get("alg").toString() : null;
        if (algorithmName == null) {
            throw new IllegalStateException("algorithm not set");
        }
        return Algorithm.findByName(algorithmName);
    }

    Map decodeAndParse(String b64String) throws IOException {
        String jsonString = new String(this.decoder.decode(b64String), "UTF-8");
        Map jwtHeader = this.fastParser.parseMap(jsonString);
        return jwtHeader;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

