/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt.pem;

import com.auth0.jwt.pem.PemFileWriter;
import java.io.IOException;
import java.security.Key;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import org.apache.commons.lang3.Validate;

public class PemWriter {
    public static void writePrivateKey(RSAPrivateKey privateKey, String description, String filename) throws IOException {
        Validate.notNull((Object)privateKey);
        Validate.notNull((Object)filename);
        PemWriter.writePemFile(privateKey, description, filename);
    }

    public static void writePublicKey(RSAPublicKey publicKey, String description, String filename) throws IOException {
        Validate.notNull((Object)publicKey);
        Validate.notNull((Object)filename);
        PemWriter.writePemFile(publicKey, description, filename);
    }

    public static void writePemFile(Key key, String description, String filename) throws IOException {
        Validate.notNull((Object)key);
        Validate.notNull((Object)filename);
        PemFileWriter pemFileWriter = new PemFileWriter(key, description);
        pemFileWriter.write(filename);
    }
}

