/*
 * Decompiled with CFR 0.152.
 */
package de.objektkontor.config;

import de.objektkontor.config.ConfigParameter;
import de.objektkontor.config.Configuration;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;

public class ConfigLoader {
    private final Configuration backend;
    private final String bundle;

    public ConfigLoader(Configuration backend, String bundle) {
        this.backend = backend;
        this.bundle = bundle;
    }

    public <C> C loadConfig(C config) {
        return this.loadConfig(null, config);
    }

    public <C> C loadConfig(String prefix, C config) {
        Collection<Field> fields = this.getConfigParameterFields(config.getClass());
        if (fields.size() == 0) {
            throw new IllegalArgumentException("No configuration parameters found in class: " + config.getClass());
        }
        this.loadConfigParameters(prefix, config, fields);
        return config;
    }

    public void loadConfigParameters(String prefix, Object config, Collection<Field> fields) {
        for (Field field : fields) {
            String name = field.getAnnotation(ConfigParameter.class).value();
            if (name.equals("<field.name>")) {
                name = field.getName();
            }
            String key = prefix == null ? "" : prefix;
            key = key + (name.length() > 0 ? (key.length() > 0 ? "." + name : name) : "");
            field.setAccessible(true);
            try {
                Object value = field.get(config);
                Collection<Field> childFields = this.getConfigParameterFields(value == null ? field.getType() : value.getClass());
                if (childFields.size() > 0) {
                    if (value == null) {
                        try {
                            value = field.getType().newInstance();
                        }
                        catch (InstantiationException e) {
                            throw new IllegalArgumentException("Error creating instance of configuration parameter: " + field);
                        }
                        field.set(config, value);
                    }
                    this.loadConfigParameters(key, value, childFields);
                    continue;
                }
                if (key.length() == 0) {
                    throw new IllegalArgumentException("Empty key for configuration parameter: " + field);
                }
                field.set(config, this.loadParameterValue(key, field, value));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Object loadParameterValue(String key, Field field, Object defaultValue) {
        Class<?> type = field.getType();
        if (type == String.class) {
            return this.backend.getStringValue(this.bundle, key, (String)defaultValue);
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return this.backend.getIntValue(this.bundle, key, (Integer)defaultValue);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return this.backend.getBooleanValue(this.bundle, key, (Boolean)defaultValue);
        }
        if (type == Date.class) {
            return this.backend.getDateValue(this.bundle, key, (Date)defaultValue);
        }
        if (Enum.class.isAssignableFrom(type)) {
            return this.backend.getEnumValue(this.bundle, key, (Enum)defaultValue);
        }
        throw new IllegalArgumentException("Unsupported type for configuration parameter: " + field);
    }

    private Collection<Field> getConfigParameterFields(Class<?> configClass) {
        LinkedList<Field> result = new LinkedList<Field>();
        for (Class<?> currentClass = configClass; currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            for (Field field : currentClass.getDeclaredFields()) {
                if (!field.isAnnotationPresent(ConfigParameter.class)) continue;
                result.add(field);
            }
        }
        return result;
    }
}

