/*
 * Decompiled with CFR 0.152.
 */
package de.objektkontor.config;

import de.objektkontor.config.Backend;
import de.objektkontor.config.annotation.ConfigIdentifier;
import de.objektkontor.config.annotation.ConfigParameter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class ConfigLoader {
    private static final Map<Class<?>, Class<?>> primitiveWrappers = ConfigLoader.createPrimitiveWrappers();
    private final Backend backend;
    private final String bundle;

    public ConfigLoader(Backend backend, String bundle) {
        this.backend = backend;
        this.bundle = bundle;
    }

    private static Map<Class<?>, Class<?>> createPrimitiveWrappers() {
        HashMap primitiveWrappers = new HashMap();
        primitiveWrappers.put(Boolean.TYPE, Boolean.class);
        primitiveWrappers.put(Integer.TYPE, Integer.class);
        primitiveWrappers.put(Long.TYPE, Long.class);
        return primitiveWrappers;
    }

    public <C> C loadConfig(C config) {
        return this.loadConfig(null, config);
    }

    public <C> C loadConfig(String prefix, C config) {
        Collection<Field> fields = this.getConfigParameterFields(config.getClass());
        if (fields.size() == 0) {
            throw new IllegalArgumentException("No configuration parameters found in class: " + config.getClass());
        }
        this.loadConfigParameters(prefix, config, fields);
        return config;
    }

    public void loadConfigParameters(String prefix, Object config, Collection<Field> fields) {
        for (Field field : fields) {
            String name = field.getAnnotation(ConfigParameter.class).value();
            if (name.equals("<field.name>")) {
                name = field.getName();
            }
            String key = prefix == null ? "" : prefix;
            key = key + (name.length() > 0 ? (key.length() > 0 ? "." + name : name) : "");
            field.setAccessible(true);
            try {
                Class<?> type = this.getFieldType(config, field);
                Collection<Field> childFields = this.getConfigParameterFields(type);
                if (childFields.size() > 0) {
                    if (type.isArray()) {
                        this.loadArrayOfSubConfigs(config, key, field, childFields);
                        continue;
                    }
                    this.loadSubConfig(config, key, field, childFields);
                    continue;
                }
                if (key.length() == 0) {
                    throw new IllegalArgumentException("Empty key for configuration parameter: " + field);
                }
                Object value = this.loadParameterValue(key, field, field.get(config));
                this.setParameterValue(config, field, value);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Class<?> getFieldType(Object config, Field field) throws IllegalAccessException {
        Object value = field.get(config);
        return value == null ? field.getType() : value.getClass();
    }

    private Collection<Field> getConfigParameterFields(Class<?> type) {
        LinkedList<Field> result = new LinkedList<Field>();
        if (type.isArray()) {
            type = type.getComponentType();
        }
        if (type.isPrimitive()) {
            return result;
        }
        for (Class<?> currentClass = type; currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            for (Field childField : currentClass.getDeclaredFields()) {
                if (!childField.isAnnotationPresent(ConfigParameter.class)) continue;
                result.add(childField);
            }
        }
        return result;
    }

    private void loadSubConfig(Object config, String key, Field field, Collection<Field> childFields) throws IllegalAccessException, InvocationTargetException {
        Class<?> type;
        Object value = field.get(config);
        Class<?> clazz = type = value == null ? field.getType() : value.getClass();
        if (value == null) {
            try {
                value = type.newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("Error creating instance of configuration parameter: " + field);
            }
            this.setParameterValue(config, field, value);
        }
        this.loadConfigParameters(key, value, childFields);
    }

    private void loadArrayOfSubConfigs(Object config, String key, Field field, Collection<Field> childFields) throws IllegalAccessException, InvocationTargetException {
        Object value = field.get(config);
        Class<?> elementType = field.getType().getComponentType();
        Field identifierField = this.getIdentifierField(elementType);
        Set<String> ids = this.backend.getSubconfigIds(this.bundle, key);
        if (value == null) {
            value = Array.newInstance(elementType, ids.size());
            this.setParameterValue(config, field, value);
        }
        Object[] array = (Object[])value;
        int index = 0;
        for (String id : ids) {
            Object element;
            try {
                element = elementType.newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("Error creating instance of configuration parameter: " + field);
            }
            if (identifierField != null) {
                identifierField.setAccessible(true);
                this.setParameterValue(element, identifierField, id);
            }
            this.loadConfigParameters(key + "." + id, element, childFields);
            array[index++] = element;
        }
    }

    private Field getIdentifierField(Class<?> type) {
        for (Class<?> currentClass = type; currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            for (Field field : currentClass.getDeclaredFields()) {
                if (!field.isAnnotationPresent(ConfigIdentifier.class)) continue;
                return field;
            }
        }
        return null;
    }

    private Object loadParameterValue(String key, Field field, Object defaultValue) {
        Class<?> type = field.getType();
        if (type.isArray()) {
            Class<?> loadType = ConfigLoader.normalizeType(type = type.getComponentType());
            ?[] value = this.backend.getValues(this.bundle, key, loadType);
            if (value == null) {
                return defaultValue;
            }
            if (type.isPrimitive()) {
                return this.unboxArray(value, loadType, type);
            }
            return value;
        }
        Class<?> loadType = ConfigLoader.normalizeType(type);
        Class<?> value = this.backend.getValue(this.bundle, key, loadType);
        return value == null ? defaultValue : value;
    }

    private void setParameterValue(Object config, Field field, Object value) throws IllegalAccessException, InvocationTargetException {
        Method setter = this.findSetter(config, field);
        if (setter == null) {
            field.set(config, value);
        } else {
            setter.invoke(config, value);
        }
    }

    private Method findSetter(Object config, Field field) {
        String fieldName = field.getName();
        String methodName = "set" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
        try {
            return config.getClass().getMethod(methodName, field.getType());
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Class<?> normalizeType(Class<?> type) {
        if (type.isPrimitive()) {
            return primitiveWrappers.get(type);
        }
        return type;
    }

    private Object unboxArray(Object value, Class<?> boxedType, Class<?> type) {
        if (type == Boolean.TYPE) {
            Boolean[] source = (Boolean[])value;
            boolean[] reault = new boolean[source.length];
            for (int i = 0; i < reault.length; ++i) {
                reault[i] = source[i];
            }
            return reault;
        }
        if (type == Integer.TYPE) {
            Integer[] source = (Integer[])value;
            int[] reault = new int[source.length];
            for (int i = 0; i < reault.length; ++i) {
                reault[i] = source[i];
            }
            return reault;
        }
        if (type == Long.TYPE) {
            Long[] source = (Long[])value;
            long[] reault = new long[source.length];
            for (int i = 0; i < reault.length; ++i) {
                reault[i] = source[i];
            }
            return reault;
        }
        throw new IllegalStateException("Unsupported type for unbox array: " + type);
    }
}

