/*
 * Decompiled with CFR 0.152.
 */
package de.objektkontor.config;

import de.objektkontor.config.AbstractBackend;
import de.objektkontor.config.DuplicateConfigIdException;
import de.objektkontor.config.ValueFormatException;
import de.objektkontor.config.ValueParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration
extends AbstractBackend {
    private static final Logger log = LoggerFactory.getLogger(Configuration.class);
    private final GeneralizeKeys generalizeKeys;
    private final Map<String, Bundle> bundles = new ConcurrentHashMap<String, Bundle>();

    public Configuration() {
        this(null, null);
    }

    public Configuration(ClassLoader classLoader) {
        this(classLoader, null);
    }

    public Configuration(GeneralizeKeys generalizeKeys) {
        this(null, generalizeKeys);
    }

    public Configuration(ClassLoader classLoader, GeneralizeKeys generalizeKeys) {
        super(classLoader);
        this.generalizeKeys = generalizeKeys;
    }

    @Override
    public <V> V getValue(String bundle, String key, Class<V> valueType) throws ValueFormatException {
        String value = this.getBundleValue(bundle, key);
        if (value == null) {
            return null;
        }
        ValueParser<V> parser = Configuration.getParser(valueType);
        try {
            return parser.parseValue(value, valueType);
        }
        catch (Exception e) {
            throw new ValueFormatException(bundle, key, e);
        }
    }

    @Override
    public <V> V getValue(String bundle, String key, V defaultValue) throws ValueFormatException {
        String value = this.getBundleValue(bundle, key);
        if (value == null) {
            return defaultValue;
        }
        Class<?> valueType = defaultValue.getClass();
        ValueParser<?> parser = Configuration.getParser(valueType);
        try {
            return (V)parser.parseValue(value, valueType);
        }
        catch (Exception e) {
            throw new ValueFormatException(bundle, key, e);
        }
    }

    @Override
    public <V> V[] getValues(String bundle, String key, Class<V> valueType) throws ValueFormatException {
        String values = this.getBundleValue(bundle, key);
        if (values == null) {
            return null;
        }
        ValueParser<V> parser = Configuration.getParser(valueType);
        try {
            return parser.parseValues(values, valueType);
        }
        catch (Exception e) {
            throw new ValueFormatException(bundle, key, e);
        }
    }

    @Override
    public <V> V[] getValues(String bundle, String key, V[] defaultValues) throws ValueFormatException {
        String values = this.getBundleValue(bundle, key);
        if (values == null) {
            return defaultValues;
        }
        Class<?> valueType = defaultValues.getClass().getComponentType();
        ValueParser<?> parser = Configuration.getParser(valueType);
        try {
            return parser.parseValues(values, valueType);
        }
        catch (Exception e) {
            throw new ValueFormatException(bundle, key, e);
        }
    }

    @Override
    public Set<String> getSubconfigIds(String bundle, String key) throws DuplicateConfigIdException {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        String[] ids = this.getValues(bundle, key, String.class);
        if (ids == null) {
            return result;
        }
        for (String id : ids) {
            if (result.contains(id)) {
                throw new DuplicateConfigIdException(id);
            }
            result.add(id);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBundleValue(String bundleName, String key) {
        Bundle bundle = this.bundles.get(bundleName);
        if (bundle == null) {
            Map<String, Bundle> map = this.bundles;
            synchronized (map) {
                bundle = this.bundles.get(bundleName);
                if (bundle == null) {
                    bundle = new Bundle(bundleName);
                    this.bundles.put(bundleName, bundle);
                }
            }
        }
        if (this.generalizeKeys == null) {
            return bundle.getProperty(key);
        }
        String[] parts = key.split("\\.");
        switch (this.generalizeKeys) {
            case FROM_BEGIN: {
                for (int i = 0; i < parts.length; ++i) {
                    StringBuilder subkey = new StringBuilder(parts[i]);
                    for (int j = i + 1; j < parts.length; ++j) {
                        subkey.append(".").append(parts[j]);
                    }
                    String value = bundle.getProperty(subkey.toString());
                    if (value == null) continue;
                    return value;
                }
                break;
            }
            case FROM_END: {
                for (int i = parts.length; i > 0; --i) {
                    StringBuilder subkey = new StringBuilder(parts[0]);
                    for (int j = 1; j < i; ++j) {
                        subkey.append(".").append(parts[j]);
                    }
                    String value = bundle.getProperty(subkey.toString());
                    if (value == null) continue;
                    return value;
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return null;
    }

    public class Bundle {
        private final Properties properties = new Properties();

        public String getProperty(String key) {
            return this.properties.getProperty(key);
        }

        public boolean containsKey(String key) {
            return this.properties.containsKey(key);
        }

        public Bundle(String name) {
            ClassLoader loader = Configuration.this.classLoader;
            if (loader == null) {
                loader = Thread.currentThread().getContextClassLoader();
            }
            if (loader == null) {
                loader = Configuration.class.getClassLoader();
            }
            try (InputStream defaultBundle = loader.getResourceAsStream("default/" + name + ".properties");
                 InputStream stageBundle = loader.getResourceAsStream("stage/" + name + ".properties");){
                if (defaultBundle == null && stageBundle == null) {
                    log.warn("No property files found in classpath for bundle: " + name);
                }
                if (defaultBundle != null) {
                    log.debug("defaultBundle " + name + " found");
                    this.load(defaultBundle, name);
                }
                if (stageBundle != null) {
                    log.debug("stageBundle " + name + " found");
                    this.load(stageBundle, name);
                }
                if (log.isDebugEnabled() && !this.properties.isEmpty()) {
                    log.debug("Loaded configuration values for bundle: " + name);
                    log.debug(this.properties.toString());
                }
                this.cleanup();
            }
            catch (IOException e) {
                // empty catch block
            }
        }

        private void load(InputStream in, String name) {
            try {
                this.properties.load(in);
            }
            catch (IOException e) {
                log.error("Error loading default configuration bundle: " + name, (Throwable)e);
            }
        }

        private void cleanup() {
            Iterator<Object> i = this.properties.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                String value = this.properties.getProperty(key);
                if (value == null || !value.isEmpty() && !value.matches("\\s+")) continue;
                i.remove();
            }
        }
    }

    public static enum GeneralizeKeys {
        FROM_BEGIN,
        FROM_END;

    }
}

