/*
 * Decompiled with CFR 0.152.
 */
package de.objektkontor.config;

import de.objektkontor.config.ConfigInspector;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.List;

public class ConfigDuplicator
extends ConfigInspector {
    public static void copyConfig(Object source, Object target) {
        if (source == null || target == null) {
            throw new IllegalArgumentException("source and/or target cannot be null");
        }
        Class<?> type = source.getClass();
        List<Field> parameterFields = ConfigDuplicator.getConfigParameterFields(type);
        if (parameterFields.size() > 0) {
            ConfigDuplicator.copyConfig(source, target, parameterFields);
            return;
        }
        throw new IllegalArgumentException("cannot copy objects of type: " + type);
    }

    public static <C> C cloneConfig(C source) {
        if (source == null) {
            throw new IllegalArgumentException("source cannot be null");
        }
        Class<?> type = source.getClass();
        try {
            Object target = type.newInstance();
            ConfigDuplicator.copyConfig(source, target);
            return (C)target;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Error creating instance of config: " + type, e);
        }
    }

    private static void copyConfig(Object source, Object target, List<Field> parameterFields) {
        Field identifierField = ConfigInspector.getIdentifierField(source.getClass());
        if (identifierField != null) {
            identifierField.setAccessible(true);
            ConfigDuplicator.copyFieldValue(source, target, identifierField);
        }
        for (Field field : parameterFields) {
            field.setAccessible(true);
            Class<?> type = ConfigDuplicator.getFieldType(source, field);
            List<Field> childFields = ConfigInspector.getConfigParameterFields(type);
            if (childFields.size() > 0) {
                if (type.isArray()) {
                    ConfigDuplicator.copyArrayOfSubConfigs(source, target, field, childFields);
                    continue;
                }
                ConfigDuplicator.copySubConfig(source, target, field, childFields);
                continue;
            }
            if (type.isArray()) {
                ConfigDuplicator.copyFieldArrayValue(source, target, field);
                continue;
            }
            ConfigDuplicator.copyFieldValue(source, target, field);
        }
    }

    private static void copyFieldValue(Object source, Object target, Field field) {
        Object value = ConfigDuplicator.getFieldValue(source, field);
        ConfigDuplicator.setFieldValue(target, field, value);
    }

    private static void copyFieldArrayValue(Object source, Object target, Field field) {
        Object sourceArray = ConfigDuplicator.getFieldValue(source, field);
        if (sourceArray == null) {
            ConfigDuplicator.setFieldValue(target, field, null);
        } else {
            Object targetArray = ConfigDuplicator.getFieldValue(target, field);
            Class<?> elementType = sourceArray.getClass().getComponentType();
            int length = Array.getLength(sourceArray);
            if (targetArray == null || Array.getLength(targetArray) != length) {
                targetArray = Array.newInstance(elementType, length);
            }
            if (length > 0) {
                System.arraycopy(sourceArray, 0, targetArray, 0, length);
            }
            ConfigDuplicator.setFieldValue(target, field, targetArray);
        }
    }

    private static void copySubConfig(Object source, Object target, Field field, List<Field> childFields) {
        Object sourceConfig = ConfigDuplicator.getFieldValue(source, field);
        if (sourceConfig == null) {
            ConfigDuplicator.setFieldValue(target, field, null);
        } else {
            Object targetConfig = ConfigDuplicator.getFieldValue(target, field);
            if (targetConfig == null) {
                Class<?> type = sourceConfig.getClass();
                targetConfig = ConfigDuplicator.newFieldInstance(field, type);
                ConfigDuplicator.setFieldValue(target, field, targetConfig);
            }
            ConfigDuplicator.copyConfig(sourceConfig, targetConfig, childFields);
        }
    }

    private static void copyArrayOfSubConfigs(Object source, Object target, Field field, List<Field> childFields) {
        Object sourceArray = ConfigDuplicator.getFieldValue(source, field);
        if (sourceArray == null) {
            ConfigDuplicator.setFieldValue(target, field, null);
        } else {
            Object targetArray = ConfigDuplicator.getFieldValue(target, field);
            Class<?> elementType = sourceArray.getClass().getComponentType();
            int length = Array.getLength(sourceArray);
            if (targetArray == null || Array.getLength(targetArray) != length) {
                targetArray = Array.newInstance(elementType, length);
                ConfigDuplicator.setFieldValue(target, field, targetArray);
            }
            for (int index = 0; index < length; ++index) {
                Object sourceConfig = Array.get(sourceArray, index);
                Object targetConfig = Array.get(targetArray, index);
                if (targetConfig == null) {
                    targetConfig = ConfigDuplicator.newFieldInstance(field, elementType);
                    Array.set(targetArray, index, targetConfig);
                }
                ConfigDuplicator.copyConfig(sourceConfig, targetConfig, childFields);
            }
        }
    }
}

