/*
 * Decompiled with CFR 0.152.
 */
package de.objektkontor.config;

import de.objektkontor.config.BundleObserver;
import de.objektkontor.config.ConfigBackend;
import de.objektkontor.config.ConfigDuplicator;
import de.objektkontor.config.ConfigInspector;
import de.objektkontor.config.ConfigTracker;
import de.objektkontor.config.ObservableConfig;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigLoader
extends ConfigInspector
implements BundleObserver {
    private static final Logger log = LoggerFactory.getLogger(ConfigLoader.class);
    private static final Map<Class<?>, Class<?>> primitiveWrappers = ConfigLoader.createPrimitiveWrappers();
    private final String bundle;
    private final ConfigBackend configBackend;
    private final ConfigTracker<TrackingData> configTracker;

    public ConfigLoader(ConfigBackend configBackend, String bundle) {
        this(configBackend, bundle, false);
    }

    public ConfigLoader(ConfigBackend configBackend, String bundle, boolean enableTracking) {
        this.configBackend = configBackend;
        this.bundle = bundle;
        if (enableTracking) {
            this.configTracker = new ConfigTracker();
            configBackend.addObserver(bundle, this);
        } else {
            this.configTracker = null;
        }
    }

    public <C> C loadConfig(C config) {
        return this.loadConfig(null, config);
    }

    public <C> C loadConfig(String prefix, C config) {
        this.doLoadConfig(prefix, config);
        if (log.isDebugEnabled()) {
            log.debug("Loaded config " + config.getClass().getSimpleName() + ":\n" + ConfigInspector.dump(prefix, config));
        }
        if (this.trackable(config)) {
            return this.trackConfig(prefix, config);
        }
        return config;
    }

    @Override
    public void bundleChanged() throws Exception {
        if (this.configTracker != null) {
            this.configTracker.updateConfigs(new ConfigTracker.Modifier<TrackingData>(){

                @Override
                public ObservableConfig modify(ObservableConfig workingCopy, ObservableConfig sourceConfig, TrackingData trackingData) {
                    ObservableConfig config = ConfigDuplicator.cloneConfig(trackingData.defaultConfig);
                    ConfigLoader.this.doLoadConfig(trackingData.prefix, config);
                    return config;
                }
            });
        }
    }

    private void doLoadConfig(String prefix, Object config) {
        List<Field> parameterFields = ConfigLoader.getConfigParameterFields(config.getClass());
        if (parameterFields.size() == 0) {
            throw new IllegalArgumentException("No configuration parameters found in class: " + config.getClass());
        }
        this.loadConfigParameters(prefix, config, parameterFields);
    }

    private boolean trackable(Object config) {
        return this.configTracker != null && config instanceof ObservableConfig;
    }

    private <C> C trackConfig(String prefix, C config) {
        ObservableConfig observableConfig = (ObservableConfig)config;
        TrackingData trackingData = new TrackingData(prefix, observableConfig);
        return (C)this.configTracker.register(observableConfig, trackingData);
    }

    private void loadConfigParameters(String prefix, Object config, Collection<Field> parameterFields) {
        for (Field field : parameterFields) {
            String key = ConfigLoader.getParameterKey(prefix, field);
            field.setAccessible(true);
            Class<?> type = ConfigLoader.getFieldType(config, field);
            List<Field> childFields = ConfigLoader.getConfigParameterFields(type);
            if (childFields.size() > 0) {
                if (type.isArray()) {
                    this.loadArrayOfSubConfigs(config, key, field, childFields);
                    continue;
                }
                this.loadSubConfig(config, key, field, childFields);
                continue;
            }
            if (key.length() == 0) {
                throw new IllegalArgumentException("Empty key for configuration parameter: " + field);
            }
            Object defaultValue = ConfigLoader.getFieldValue(config, field);
            Object value = this.loadParameterValue(key, field, defaultValue);
            this.setParameterValue(config, field, value);
        }
    }

    private void loadSubConfig(Object config, String key, Field field, Collection<Field> parameterFields) {
        Class<?> type;
        Object value = ConfigLoader.getFieldValue(config, field);
        Class<?> clazz = type = value == null ? field.getType() : value.getClass();
        if (value == null) {
            value = ConfigLoader.newFieldInstance(field, type);
            this.setParameterValue(config, field, value);
        }
        this.loadConfigParameters(key, value, parameterFields);
    }

    private void loadArrayOfSubConfigs(Object config, String key, Field field, Collection<Field> parameterFields) {
        Object value = ConfigLoader.getFieldValue(config, field);
        Class<?> elementType = field.getType().getComponentType();
        Field identifierField = ConfigLoader.getIdentifierField(elementType);
        Set<String> ids = this.configBackend.getSubconfigIds(this.bundle, key);
        if (value == null) {
            value = Array.newInstance(elementType, ids.size());
            this.setParameterValue(config, field, value);
        }
        Object[] array = (Object[])value;
        int index = 0;
        for (String id : ids) {
            Object element = ConfigLoader.newFieldInstance(field, elementType);
            if (identifierField != null) {
                identifierField.setAccessible(true);
                this.setParameterValue(element, identifierField, id);
            }
            this.loadConfigParameters(key + "." + id, element, parameterFields);
            array[index++] = element;
        }
    }

    private Object loadParameterValue(String key, Field field, Object defaultValue) {
        Class<?> type = field.getType();
        if (type.isArray()) {
            Class<?> loadType = this.normalizeType(type = type.getComponentType());
            ?[] value = this.configBackend.getValues(this.bundle, key, loadType);
            if (value == null) {
                return defaultValue;
            }
            if (type.isPrimitive()) {
                return this.unboxArray(value, loadType, type);
            }
            return value;
        }
        Class<?> loadType = this.normalizeType(type);
        Class<?> value = this.configBackend.getValue(this.bundle, key, loadType);
        return value == null ? defaultValue : value;
    }

    private void setParameterValue(Object config, Field field, Object value) {
        Method setter = this.findSetter(config, field);
        try {
            if (setter == null) {
                field.set(config, value);
            } else {
                setter.invoke(config, value);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private Method findSetter(Object config, Field field) {
        String fieldName = field.getName();
        String methodName = "set" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
        try {
            return config.getClass().getMethod(methodName, field.getType());
        }
        catch (Exception e) {
            return null;
        }
    }

    private Class<?> normalizeType(Class<?> type) {
        if (type.isPrimitive()) {
            return primitiveWrappers.get(type);
        }
        return type;
    }

    private Object unboxArray(Object value, Class<?> boxedType, Class<?> type) {
        if (type == Boolean.TYPE) {
            Boolean[] source = (Boolean[])value;
            boolean[] reault = new boolean[source.length];
            for (int i = 0; i < reault.length; ++i) {
                reault[i] = source[i];
            }
            return reault;
        }
        if (type == Integer.TYPE) {
            Integer[] source = (Integer[])value;
            int[] reault = new int[source.length];
            for (int i = 0; i < reault.length; ++i) {
                reault[i] = source[i];
            }
            return reault;
        }
        if (type == Long.TYPE) {
            Long[] source = (Long[])value;
            long[] reault = new long[source.length];
            for (int i = 0; i < reault.length; ++i) {
                reault[i] = source[i];
            }
            return reault;
        }
        throw new IllegalStateException("Unsupported type for unbox array: " + type);
    }

    private static Map<Class<?>, Class<?>> createPrimitiveWrappers() {
        HashMap primitiveWrappers = new HashMap();
        primitiveWrappers.put(Boolean.TYPE, Boolean.class);
        primitiveWrappers.put(Integer.TYPE, Integer.class);
        primitiveWrappers.put(Long.TYPE, Long.class);
        return primitiveWrappers;
    }

    private static class TrackingData {
        private final String prefix;
        private final ObservableConfig defaultConfig;

        public TrackingData(String prefix, ObservableConfig defaultConfig) {
            this.prefix = prefix;
            this.defaultConfig = defaultConfig;
        }
    }
}

