/*
 * Decompiled with CFR 0.152.
 */
package de.objektkontor.config;

import de.objektkontor.config.ConfigComparator;
import de.objektkontor.config.ConfigDuplicator;
import de.objektkontor.config.ConfigInspector;
import de.objektkontor.config.ConfigUpdate;
import de.objektkontor.config.ObservableConfig;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigTracker<T>
extends ConfigInspector {
    private static final Logger log = LoggerFactory.getLogger(ConfigTracker.class);
    private final Map<ObservableConfig, ObservableConfig> configs = new LinkedHashMap<ObservableConfig, ObservableConfig>();
    private final Map<ObservableConfig, T> trackingDataValues = new HashMap<ObservableConfig, T>();

    public synchronized <C extends ObservableConfig> C register(C sourceConfig) {
        return this.register(sourceConfig, null);
    }

    public synchronized <C extends ObservableConfig> C register(C sourceConfig, T trackingData) {
        if (sourceConfig == null) {
            throw new IllegalArgumentException("Config to register cannot be null");
        }
        C workingCopy = ConfigDuplicator.cloneConfig(sourceConfig);
        this.configs.put(workingCopy, sourceConfig);
        if (trackingData != null) {
            this.trackingDataValues.put(workingCopy, trackingData);
        }
        return workingCopy;
    }

    public synchronized ObservableConfig getSourceConfig(ObservableConfig workingCopy) {
        return this.configs.get(workingCopy);
    }

    public synchronized T getTrackingData(ObservableConfig workingCopy) {
        return this.trackingDataValues.get(workingCopy);
    }

    public synchronized void syncConfigs() throws Exception {
        this.performUpdate();
    }

    public synchronized void updateConfigs(Modifier<T> modifier) throws Exception {
        for (ObservableConfig workingCopy : this.configs.keySet()) {
            ObservableConfig sourceConfig = this.configs.get(workingCopy);
            T trackingData = this.trackingDataValues.get(workingCopy);
            if ((sourceConfig = modifier.modify(workingCopy, sourceConfig, trackingData)) == null) {
                throw new IllegalStateException("Modify callback must return some configuration instance");
            }
            if (sourceConfig == workingCopy) {
                throw new IllegalStateException("Modify callback cannot use workingCopy itself as an updated configuration instance");
            }
            if (!workingCopy.getClass().isAssignableFrom(sourceConfig.getClass())) {
                throw new IllegalStateException("Modify callback must return instance of type which was originally registered");
            }
            this.configs.put(workingCopy, sourceConfig);
        }
        this.performUpdate();
    }

    private void performUpdate() throws Exception {
        List<ConfigUpdate> updates = this.collectConfigUpdates();
        for (int index = 0; index < updates.size(); ++index) {
            try {
                updates.get(index).prepare();
                continue;
            }
            catch (Exception prepareError) {
                for (int discardIndex = index; discardIndex >= 0; --discardIndex) {
                    try {
                        updates.get(discardIndex).discard();
                        continue;
                    }
                    catch (Throwable discardError) {
                        log.error("Uncaught exception discarding config update", discardError);
                    }
                }
                throw prepareError;
            }
        }
        this.copyUpdatedConfigParameters();
        for (ConfigUpdate update : updates) {
            try {
                update.apply();
            }
            catch (Throwable applyError) {
                log.error("Uncaught exception applying config update", applyError);
            }
        }
    }

    private List<ConfigUpdate> collectConfigUpdates() throws Exception {
        ArrayList<ConfigUpdate> updates = new ArrayList<ConfigUpdate>();
        for (ObservableConfig workingCopy : this.configs.keySet()) {
            ObservableConfig sourceConfig = this.configs.get(workingCopy);
            if (log.isDebugEnabled() && !ConfigComparator.deepEquals(workingCopy, sourceConfig, false)) {
                log.debug("Performing update for config " + workingCopy.getClass().getSimpleName() + ". Parameter values diff (old <=> new):\n" + ConfigComparator.diff(workingCopy, sourceConfig));
            }
            this.notifyObservers(workingCopy, sourceConfig, updates);
        }
        return updates;
    }

    private void notifyObservers(ObservableConfig workingCopy, ObservableConfig sourceConfig, List<ConfigUpdate> updates) throws Exception {
        Class<?> type = workingCopy.getClass();
        List<Field> parameterFields = ConfigTracker.getConfigParameterFields(type);
        if (parameterFields.size() > 0 && !type.isArray()) {
            this.notifyObservers(workingCopy, sourceConfig, updates, parameterFields);
        }
        workingCopy.notifyObserver(sourceConfig, updates);
    }

    private void notifyObservers(ObservableConfig working, ObservableConfig source, List<ConfigUpdate> updates, List<Field> parameters) throws Exception {
        for (Field field : parameters) {
            field.setAccessible(true);
            Object config = ConfigTracker.getFieldValue(working, field);
            if (config == null || !(config instanceof ObservableConfig)) continue;
            ObservableConfig workingCopy = (ObservableConfig)config;
            ObservableConfig sourceConfig = (ObservableConfig)ConfigTracker.getFieldValue(source, field);
            this.notifyObservers(workingCopy, sourceConfig, updates);
        }
    }

    private void copyUpdatedConfigParameters() {
        for (ObservableConfig workingCopy : this.configs.keySet()) {
            ObservableConfig sourceConfig = this.configs.get(workingCopy);
            ConfigDuplicator.copyConfig(sourceConfig, workingCopy);
        }
    }

    public static interface Modifier<T> {
        public ObservableConfig modify(ObservableConfig var1, ObservableConfig var2, T var3);
    }
}

