/*
 * Decompiled with CFR 0.152.
 */
package de.objektkontor.config;

import de.objektkontor.config.BundleObserver;
import de.objektkontor.config.ConfigBackend;
import de.objektkontor.config.ReloadInitiator;
import de.objektkontor.config.ValueParser;
import de.objektkontor.config.valueparser.BooleanValueParser;
import de.objektkontor.config.valueparser.DateValueParser;
import de.objektkontor.config.valueparser.DurationValueParser;
import de.objektkontor.config.valueparser.EnumValueParser;
import de.objektkontor.config.valueparser.IntegerValueParser;
import de.objektkontor.config.valueparser.LongValueParser;
import de.objektkontor.config.valueparser.StringValueParser;
import java.time.Duration;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractConfigBackend
implements ConfigBackend,
ReloadInitiator.Handler {
    protected final Set<BundleObserver> observers = new LinkedHashSet<BundleObserver>();
    private static final Map<Class<?>, ValueParser<?>> parsers = AbstractConfigBackend.createParsers();

    public AbstractConfigBackend() {
        ReloadInitiator.getInstance().register(this);
    }

    protected abstract void doReload() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reloadConfiguration() throws Exception {
        this.doReload();
        Set<BundleObserver> set = this.observers;
        synchronized (set) {
            for (BundleObserver observer : this.observers) {
                observer.bundleChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addObserver(String bundle, BundleObserver observer) {
        Set<BundleObserver> set = this.observers;
        synchronized (set) {
            this.observers.add(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeObserver(String bundle, BundleObserver observer) {
        Set<BundleObserver> set = this.observers;
        synchronized (set) {
            this.observers.remove(observer);
        }
    }

    protected static <V> ValueParser<V> getParser(Class<V> valueType) {
        Class<?> searchType = AbstractConfigBackend.normalizeType(valueType);
        ValueParser<?> parser = parsers.get(searchType);
        if (parser == null) {
            throw new IllegalArgumentException("Datatype is not supported: " + valueType);
        }
        return parser;
    }

    private static Class<?> normalizeType(Class<?> type) {
        if (type.getSuperclass() == Enum.class) {
            return Enum.class;
        }
        return type;
    }

    private static Map<Class<?>, ValueParser<?>> createParsers() {
        HashMap parsers = new HashMap();
        parsers.put(String.class, new StringValueParser());
        parsers.put(Boolean.class, new BooleanValueParser());
        parsers.put(Integer.class, new IntegerValueParser());
        parsers.put(Long.class, new LongValueParser());
        parsers.put(Date.class, new DateValueParser());
        parsers.put(Enum.class, new EnumValueParser());
        parsers.put(Duration.class, new DurationValueParser());
        return parsers;
    }
}

