/*
 * Decompiled with CFR 0.152.
 */
package de.objektkontor.config;

import de.objektkontor.config.AbstractConfigBackend;
import de.objektkontor.config.DuplicateConfigIdException;
import de.objektkontor.config.ValueFormatException;
import de.objektkontor.config.ValueParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyBackend
extends AbstractConfigBackend {
    private static final Logger log = LoggerFactory.getLogger(PropertyBackend.class);
    protected final ClassLoader classLoader;
    private final Map<String, Bundle> bundles = new ConcurrentHashMap<String, Bundle>();

    public PropertyBackend() {
        this(null);
    }

    public PropertyBackend(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public <V> V getValue(String bundle, String key, Class<V> valueType) throws ValueFormatException {
        String value = this.getBundleValue(bundle, key);
        if (value == null) {
            return null;
        }
        ValueParser<V> parser = PropertyBackend.getParser(valueType);
        try {
            return parser.parseValue(value, valueType);
        }
        catch (Exception e) {
            throw new ValueFormatException(bundle, key, e);
        }
    }

    @Override
    public <V> V getValue(String bundle, String key, V defaultValue) throws ValueFormatException {
        String value = this.getBundleValue(bundle, key);
        if (value == null) {
            return defaultValue;
        }
        Class<?> valueType = defaultValue.getClass();
        ValueParser<?> parser = PropertyBackend.getParser(valueType);
        try {
            return (V)parser.parseValue(value, valueType);
        }
        catch (Exception e) {
            throw new ValueFormatException(bundle, key, e);
        }
    }

    @Override
    public <V> V[] getValues(String bundle, String key, Class<V> valueType) throws ValueFormatException {
        String values = this.getBundleValue(bundle, key);
        if (values == null) {
            return null;
        }
        ValueParser<V> parser = PropertyBackend.getParser(valueType);
        try {
            return parser.parseValues(values, valueType);
        }
        catch (Exception e) {
            throw new ValueFormatException(bundle, key, e);
        }
    }

    @Override
    public <V> V[] getValues(String bundle, String key, V[] defaultValues) throws ValueFormatException {
        String values = this.getBundleValue(bundle, key);
        if (values == null) {
            return defaultValues;
        }
        Class<?> valueType = defaultValues.getClass().getComponentType();
        ValueParser<?> parser = PropertyBackend.getParser(valueType);
        try {
            return parser.parseValues(values, valueType);
        }
        catch (Exception e) {
            throw new ValueFormatException(bundle, key, e);
        }
    }

    @Override
    public Set<String> getSubconfigIds(String bundle, String key) throws DuplicateConfigIdException {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        String[] ids = this.getValues(bundle, key, String.class);
        if (ids == null) {
            return result;
        }
        for (String id : ids) {
            if (result.contains(id)) {
                throw new DuplicateConfigIdException(id);
            }
            result.add(id);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doReload() {
        Map<String, Bundle> map = this.bundles;
        synchronized (map) {
            for (String bundleName : this.bundles.keySet()) {
                Bundle bundle = new Bundle(bundleName);
                this.bundles.put(bundleName, bundle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBundleValue(String bundleName, String key) {
        Bundle bundle = this.bundles.get(bundleName);
        if (bundle == null) {
            Map<String, Bundle> map = this.bundles;
            synchronized (map) {
                bundle = this.bundles.get(bundleName);
                if (bundle == null) {
                    bundle = new Bundle(bundleName);
                    this.bundles.put(bundleName, bundle);
                }
            }
        }
        return bundle.getProperty(key);
    }

    public class Bundle {
        private final Properties properties = new Properties();

        public String getProperty(String key) {
            return this.properties.getProperty(key);
        }

        public boolean containsKey(String key) {
            return this.properties.containsKey(key);
        }

        public Bundle(String name) {
            ClassLoader loader = PropertyBackend.this.classLoader;
            if (loader == null) {
                loader = Thread.currentThread().getContextClassLoader();
            }
            if (loader == null) {
                loader = PropertyBackend.class.getClassLoader();
            }
            try (InputStream defaultBundle = loader.getResourceAsStream("default/" + name + ".properties");
                 InputStream stageBundle = loader.getResourceAsStream("stage/" + name + ".properties");
                 InputStream rootBundle = loader.getResourceAsStream(name + ".properties");){
                if (defaultBundle == null && stageBundle == null && rootBundle == null) {
                    log.warn("No property files found in classpath for bundle: " + name);
                }
                if (defaultBundle != null) {
                    log.debug("default bundle " + name + " found");
                    this.load(defaultBundle, name);
                }
                if (stageBundle != null) {
                    log.debug("stage bundle " + name + " found");
                    this.load(stageBundle, name);
                }
                if (rootBundle != null) {
                    log.debug("root bundle " + name + " found");
                    this.load(rootBundle, name);
                }
                if (log.isDebugEnabled() && !this.properties.isEmpty()) {
                    log.debug("Loaded configuration values for bundle: " + name);
                    log.debug(this.properties.toString());
                }
                this.cleanup();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void load(InputStream in, String name) {
            try {
                this.properties.load(in);
            }
            catch (IOException e) {
                log.error("Error loading default configuration bundle: " + name, (Throwable)e);
            }
        }

        private void cleanup() {
            Iterator<Object> i = this.properties.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                String value = this.properties.getProperty(key);
                if (value == null || !value.isEmpty() && !value.matches("\\s+")) continue;
                i.remove();
            }
        }
    }
}

