/*
 * Decompiled with CFR 0.152.
 */
package de.objektkontor.config.backend;

import de.objektkontor.config.backend.PropertyBackend;
import java.io.File;
import java.io.FileInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyFileBackend
extends PropertyBackend {
    private static final Logger log = LoggerFactory.getLogger(PropertyFileBackend.class);
    private final File file;

    public PropertyFileBackend(File file) throws Exception {
        super(file.getName());
        this.file = file;
        this.doReload();
    }

    @Override
    protected void doReload() throws Exception {
        log.debug("looking for properties in " + this.file);
        try (FileInputStream in = new FileInputStream(this.file);){
            this.properties.load(in);
            this.cleanup();
            if (log.isDebugEnabled() && !this.properties.isEmpty()) {
                log.debug("(Re)Loaded configuration values: " + this.properties.toString());
            }
        }
    }
}

