/*
 * Decompiled with CFR 0.152.
 */
package de.objektkontor.config;

import de.objektkontor.config.ConfigComparator;
import de.objektkontor.config.ConfigObserver;
import de.objektkontor.config.ConfigUpdate;
import java.util.List;

public abstract class ObservableConfig {
    private ConfigObserver<?> observer;

    public boolean hasObserver() {
        return this.observer != null;
    }

    public void setObserver(ConfigObserver<?> observer) {
        if (observer == null) {
            throw new IllegalArgumentException("observer cannot be null");
        }
        if (this.observer != null) {
            throw new IllegalStateException("observer allready set");
        }
        this.observer = observer;
    }

    public ConfigObserver<?> removeObserver() {
        ConfigObserver<?> removedObserver = this.observer;
        this.observer = null;
        return removedObserver;
    }

    protected void notifyObserver(ObservableConfig newConfig, List<ConfigUpdate> updates) throws Exception {
        if (this.observer == null) {
            return;
        }
        if (ConfigComparator.equals(this, newConfig)) {
            return;
        }
        this.observer.reconfigure(newConfig, updates);
    }
}

