/*
 * Decompiled with CFR 0.152.
 */
package de.objektkontor.config.backend;

import de.objektkontor.config.backend.PropertyBackend;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyFileBackend
extends PropertyBackend {
    private static final Logger log = LoggerFactory.getLogger(PropertyFileBackend.class);
    private final File file;
    private final Properties override;

    public PropertyFileBackend(File file) throws Exception {
        this(file, null);
    }

    public PropertyFileBackend(File file, Properties override) throws Exception {
        super(file.getName());
        this.file = file;
        this.override = override;
        this.doReload();
    }

    @Override
    protected void doReload() throws Exception {
        log.debug("looking for properties in " + this.file);
        this.properties.putAll((Map<?, ?>)PropertyFileBackend.loadProperties(this.file));
        if (this.override != null) {
            log.debug("applying override properties");
            this.properties.putAll((Map<?, ?>)this.override);
        }
        this.cleanup();
        if (log.isDebugEnabled() && !this.properties.isEmpty()) {
            log.debug("(Re)Loaded configuration values: " + this.properties.toString());
        }
    }
}

