/*
 * Decompiled with CFR 0.152.
 */
package de.objektkontor.config.reload;

import de.objektkontor.config.ReloadInitiator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollReloadInitiator
extends ReloadInitiator {
    private static final Logger log = LoggerFactory.getLogger(PollReloadInitiator.class);
    private static final String DEFAULT_CHECK_INTERVAL = "30000";
    private final long checkInterval;

    public PollReloadInitiator() {
        log.info("Configuring File Touch Reload Initiator");
        this.checkInterval = PollReloadInitiator.getCheckInterval(DEFAULT_CHECK_INTERVAL);
        this.startThread();
        log.info("Configuration reloading enabled. Polling for changes every " + this.checkInterval + "ms");
    }

    private void startThread() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        Thread.sleep(PollReloadInitiator.this.checkInterval);
                        if (log.isDebugEnabled()) {
                            log.debug("Check timeout exceeded. Notifying handlers");
                        }
                        PollReloadInitiator.this.notifyHandlers();
                    }
                }
                catch (InterruptedException e) {
                    log.warn(Thread.currentThread().getName() + " was interrupted");
                    return;
                }
            }
        };
        Thread thread = new Thread(runnable, "Config-Loader");
        thread.setDaemon(true);
        thread.start();
    }
}

