/*
 * Decompiled with CFR 0.152.
 */
package de.objektkontor.config.reload;

import de.objektkontor.config.ReloadInitiator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketReloadInitiator
extends ReloadInitiator {
    private static final Logger logger = LoggerFactory.getLogger(SocketReloadInitiator.class);
    private static final String PORT_PARAMETER = "ConfigReloadPort";
    private static final String DEFAULT_PORT = "4321";
    private static final String ADDRESS_PARAMETER = "ConfigReloadBindAddress";
    private static final String DEFAULT_ADDRESS = "localhost";
    private static final String SECRET_PARAMETER = "ConfigReloadSecret";
    private static final String DEFAULT_SECRET = "changeMe!";
    private final int port;
    private final InetAddress bindAddress;
    private final String secret;

    public SocketReloadInitiator() throws IOException {
        logger.info("Configuring Seocket Reload Initiator");
        this.port = this.getPort();
        this.bindAddress = this.getBindAddress();
        this.secret = this.getSecret();
        logger.info("Listening on: " + this.bindAddress + ":" + this.port);
        this.startServer();
        logger.info("Configuration reloading enabled. Use command <echo [secret] | curl telnet://localhost:" + this.port + "> to reload configuration");
    }

    private int getPort() {
        String value = SocketReloadInitiator.getParameter(PORT_PARAMETER, DEFAULT_PORT);
        return Integer.parseInt(value);
    }

    private InetAddress getBindAddress() throws IOException {
        String value = SocketReloadInitiator.getParameter(ADDRESS_PARAMETER, DEFAULT_ADDRESS);
        return InetAddress.getByName(value);
    }

    private String getSecret() {
        String value = SocketReloadInitiator.getParameter(SECRET_PARAMETER, DEFAULT_SECRET);
        if (DEFAULT_SECRET.equals(value)) {
            logger.warn("UNSING DEFAULT SECRET VALUE IS NOT RECOMENDED!");
        }
        return value;
    }

    private void startServer() throws IOException {
        final ServerSocket serverSocket = new ServerSocket(this.port, 1, this.bindAddress);
        Runnable runnable = new Runnable(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) lbl-1000:
                        // 5 sources

                        {
                            socket = serverSocket.accept();
                            try {
                                if (SocketReloadInitiator.logger.isDebugEnabled()) {
                                    SocketReloadInitiator.logger.debug("Incomming connection from: " + socket.getRemoteSocketAddress());
                                }
                                socket.setTcpNoDelay(true);
                                socket.getOutputStream().write("Enter secret\n".getBytes());
                                answer = new BufferedReader(new InputStreamReader(socket.getInputStream())).readLine();
                                if (SocketReloadInitiator.this.secret.equals(answer)) {
                                    if (SocketReloadInitiator.logger.isDebugEnabled()) {
                                        SocketReloadInitiator.logger.debug("Authentification successful. Notifying handlers.");
                                    }
                                    SocketReloadInitiator.access$000(SocketReloadInitiator.this);
                                }
                                if (!SocketReloadInitiator.logger.isDebugEnabled()) ** GOTO lbl-1000
                                SocketReloadInitiator.logger.debug("Access denied");
                            }
                            finally {
                                if (socket == null) continue;
                                socket.close();
                                continue;
                            }
                            break;
                        }
                    }
                    catch (IOException e) {
                        SocketReloadInitiator.logger.warn("Exception processing incomming connection: " + e.getMessage());
                        continue;
                    }
                    ** GOTO lbl-1000
                    break;
                }
            }
        };
        Thread thread = new Thread(runnable, "Config-Loader");
        thread.setDaemon(true);
        thread.start();
    }

    static /* synthetic */ void access$000(SocketReloadInitiator x0) {
        x0.notifyHandlers();
    }
}

