/*
 * Decompiled with CFR 0.152.
 */
package de.objektkontor.config;

import de.objektkontor.config.ConfigInspector;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.List;

public class ConfigDuplicator
extends ConfigInspector {
    public static void copyConfig(Object source, Object target) {
        ConfigDuplicator.copyConfig(source, target, false);
    }

    public static void copyConfig(Object source, Object target, boolean skipDefaults) {
        if (source == null || target == null) {
            throw new IllegalArgumentException("source and/or target cannot be null");
        }
        Class<?> type = source.getClass();
        List<Field> parameterFields = ConfigDuplicator.getConfigParameterFields(type);
        if (parameterFields.size() > 0) {
            ConfigDuplicator.copyConfig(source, target, parameterFields, skipDefaults);
            return;
        }
        throw new IllegalArgumentException("cannot copy objects of type: " + type);
    }

    public static <C> C cloneConfig(C source) {
        if (source == null) {
            throw new IllegalArgumentException("source cannot be null");
        }
        C target = ConfigDuplicator.newInstanceOfSameType(source);
        ConfigDuplicator.copyConfig(source, target);
        return target;
    }

    public static <C> C completeConfig(C config, C template) {
        if (config == null || template == null) {
            throw new IllegalArgumentException("config and/or template cannot be null");
        }
        C target = ConfigDuplicator.cloneConfig(template);
        ConfigDuplicator.copyConfig(config, target, true);
        return target;
    }

    private static void copyConfig(Object source, Object target, List<Field> parameterFields, boolean skipDefaults) {
        Field identifierField = ConfigInspector.getIdentifierField(source.getClass());
        if (identifierField != null) {
            identifierField.setAccessible(true);
            ConfigDuplicator.setFieldValue(target, identifierField, ConfigDuplicator.getFieldValue(source, identifierField));
        }
        Object defaultSource = skipDefaults ? ConfigDuplicator.newInstanceOfSameType(source) : null;
        for (Field field : parameterFields) {
            field.setAccessible(true);
            Class<?> type = ConfigDuplicator.getFieldType(source, field);
            List<Field> childFields = ConfigInspector.getConfigParameterFields(type);
            if (childFields.size() > 0) {
                if (type.isArray()) {
                    ConfigDuplicator.copyArrayOfSubConfigs(source, target, field, childFields, skipDefaults);
                    continue;
                }
                ConfigDuplicator.copySubConfig(source, target, field, childFields, skipDefaults);
                continue;
            }
            if (type.isArray()) {
                ConfigDuplicator.copyFieldArrayValue(source, target, field, skipDefaults);
                continue;
            }
            Object sourceValue = ConfigDuplicator.getFieldValue(source, field);
            if (skipDefaults && (sourceValue == null || sourceValue.equals(ConfigDuplicator.getFieldValue(defaultSource, field)))) continue;
            ConfigDuplicator.setFieldValue(target, field, sourceValue);
        }
    }

    private static void copyFieldArrayValue(Object source, Object target, Field field, boolean skipDefaults) {
        Object sourceArray = ConfigDuplicator.getFieldValue(source, field);
        if (sourceArray == null) {
            if (!skipDefaults) {
                ConfigDuplicator.setFieldValue(target, field, null);
            }
        } else {
            Object targetArray = ConfigDuplicator.getFieldValue(target, field);
            Class<?> elementType = sourceArray.getClass().getComponentType();
            int length = Array.getLength(sourceArray);
            if (targetArray == null || Array.getLength(targetArray) != length) {
                targetArray = Array.newInstance(elementType, length);
            }
            if (length > 0) {
                System.arraycopy(sourceArray, 0, targetArray, 0, length);
            }
            ConfigDuplicator.setFieldValue(target, field, targetArray);
        }
    }

    private static void copySubConfig(Object source, Object target, Field field, List<Field> childFields, boolean skipDefaults) {
        Object sourceConfig = ConfigDuplicator.getFieldValue(source, field);
        if (sourceConfig == null) {
            if (!skipDefaults) {
                ConfigDuplicator.setFieldValue(target, field, null);
            }
        } else {
            Object targetConfig = ConfigDuplicator.getFieldValue(target, field);
            if (targetConfig == null) {
                Class<?> type = sourceConfig.getClass();
                targetConfig = ConfigDuplicator.newFieldInstance(field, type);
                ConfigDuplicator.setFieldValue(target, field, targetConfig);
            }
            ConfigDuplicator.copyConfig(sourceConfig, targetConfig, childFields, skipDefaults);
        }
    }

    private static void copyArrayOfSubConfigs(Object source, Object target, Field field, List<Field> childFields, boolean skipDefaults) {
        Object sourceArray = ConfigDuplicator.getFieldValue(source, field);
        if (sourceArray == null) {
            if (!skipDefaults) {
                ConfigDuplicator.setFieldValue(target, field, null);
            }
        } else {
            Object targetArray = ConfigDuplicator.getFieldValue(target, field);
            Class<?> elementType = sourceArray.getClass().getComponentType();
            int length = Array.getLength(sourceArray);
            if (targetArray == null || Array.getLength(targetArray) != length) {
                targetArray = Array.newInstance(elementType, length);
                ConfigDuplicator.setFieldValue(target, field, targetArray);
            }
            for (int index = 0; index < length; ++index) {
                Object sourceConfig = Array.get(sourceArray, index);
                Object targetConfig = Array.get(targetArray, index);
                if (targetConfig == null) {
                    targetConfig = ConfigDuplicator.newFieldInstance(field, elementType);
                    Array.set(targetArray, index, targetConfig);
                }
                ConfigDuplicator.copyConfig(sourceConfig, targetConfig, childFields, skipDefaults);
            }
        }
    }
}

