/*
 * Decompiled with CFR 0.152.
 */
package de.objektkontor.config;

import de.objektkontor.config.ObservableConfig;
import de.objektkontor.config.annotation.ConfigIdentifier;
import de.objektkontor.config.annotation.ConfigParameter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class ConfigInspector {
    private static final int DUMP_PARAMETER_NAME_LENGTH = 60;
    private static final int DUMP_PARAMETER_VALUE_LENGTH = 30;

    public static String dump(Object config) {
        return ConfigInspector.dump(null, config, false);
    }

    public static String dump(Object config, boolean skipNulls) {
        return ConfigInspector.dump(null, config, skipNulls);
    }

    public static String dump(String prefix, Object config, boolean skipNulls) {
        if (config == null) {
            throw new IllegalArgumentException("Config to dump cannot be null");
        }
        StringBuilder buffer = new StringBuilder();
        ConfigInspector.doDump(prefix, config, null, skipNulls, buffer);
        return buffer.toString();
    }

    protected static String getParameterKey(String prefix, Field field) {
        Object key;
        String name = field.getAnnotation(ConfigParameter.class).value();
        if (name.equals("<field.name>")) {
            name = field.getName();
        }
        Object object = key = prefix == null ? "" : prefix;
        key = (String)key + (String)(name.length() > 0 ? (((String)key).length() > 0 ? "." + name : name) : "");
        return key;
    }

    protected static String getParameterDescription(Field field) {
        String description = field.getAnnotation(ConfigParameter.class).description();
        if ("<no.description>".equals(description)) {
            return null;
        }
        return description;
    }

    protected static Class<?> getFieldType(Object config, Field field) {
        Object value = ConfigInspector.getFieldValue(config, field);
        return value == null ? field.getType() : value.getClass();
    }

    protected static Object getFieldValue(Object config, Field field) {
        try {
            return field.get(config);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    protected static void setFieldValue(Object config, Field field, Object value) {
        try {
            field.set(config, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    protected static <C> C newInstanceOfSameType(C source) {
        Class<?> type = source.getClass();
        try {
            return (C)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Error creating instance of type: " + type, e);
        }
    }

    protected static Object newFieldInstance(Field field, Class<?> exactType) {
        Class<?> type = exactType == null ? field.getType() : exactType;
        try {
            return type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Error creating instance of configuration parameter: " + field);
        }
    }

    protected static List<Field> getConfigParameterFields(Class<?> type) {
        LinkedList<Field> result = new LinkedList<Field>();
        if (type.isArray()) {
            type = type.getComponentType();
        }
        if (type.isPrimitive()) {
            return result;
        }
        for (Class<?> currentClass = type; currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            for (Field childField : currentClass.getDeclaredFields()) {
                if (!childField.isAnnotationPresent(ConfigParameter.class)) continue;
                result.add(childField);
            }
        }
        return result;
    }

    protected static Field getIdentifierField(Class<?> type) {
        for (Class<?> currentClass = type; currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            for (Field field : currentClass.getDeclaredFields()) {
                if (!field.isAnnotationPresent(ConfigIdentifier.class)) continue;
                return field;
            }
        }
        return null;
    }

    protected static boolean hasObserver(Object config) {
        return config instanceof ObservableConfig && ((ObservableConfig)config).hasObserver();
    }

    private static void doDump(String name, Object config, String description, boolean skipNulls, StringBuilder buffer) {
        if (config == null) {
            ConfigInspector.doValueDump(name, config, description, skipNulls, buffer);
            return;
        }
        Class<?> type = config.getClass();
        List<Field> parameterFields = ConfigInspector.getConfigParameterFields(type);
        if (parameterFields.size() > 0) {
            if (type.isArray()) {
                ConfigInspector.doConfigArrayDump(name, config, parameterFields, skipNulls, buffer);
            } else {
                ConfigInspector.doConfigDump(name, config, parameterFields, skipNulls, buffer);
            }
            return;
        }
        if (type.isArray()) {
            ConfigInspector.doValueArrayDump(name, config, description, skipNulls, buffer);
            return;
        }
        ConfigInspector.doValueDump(name, config, description, skipNulls, buffer);
    }

    protected static void appendName(StringBuilder buffer, String name) {
        buffer.append("  ").append(name).append(" ");
        if (name.length() < 60) {
            char[] padding = new char[60 - name.length()];
            Arrays.fill(padding, '.');
            buffer.append(padding);
        }
        buffer.append(" ");
    }

    private static void doValueDump(String name, Object value, String description, boolean skipNulls, StringBuilder buffer) {
        if (value != null || !skipNulls) {
            ConfigInspector.appendName(buffer, name);
            buffer.append(String.format("%-30s", String.valueOf(value)));
            if (description != null) {
                buffer.append(" - ").append(description);
            }
            buffer.append("\n");
        }
    }

    private static void doConfigDump(String name, Object config, List<Field> parameterFields, boolean skipNulls, StringBuilder buffer) {
        for (Field field : parameterFields) {
            field.setAccessible(true);
            Object value = ConfigInspector.getFieldValue(config, field);
            ConfigInspector.doDump(ConfigInspector.getParameterKey(name, field), value, ConfigInspector.getParameterDescription(field), skipNulls, buffer);
        }
    }

    private static void doValueArrayDump(String name, Object array, String description, boolean skipNulls, StringBuilder buffer) {
        StringBuilder valuesBuffer = new StringBuilder();
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object value = Array.get(array, i);
            if (i > 0) {
                valuesBuffer.append(", ");
            }
            valuesBuffer.append(String.valueOf(value));
        }
        ConfigInspector.doValueDump(name + "[]", valuesBuffer, description, skipNulls, buffer);
    }

    private static void doConfigArrayDump(String name, Object array, List<Field> parameterFields, boolean skipNulls, StringBuilder buffer) {
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object config = Array.get(array, i);
            if (config == null) {
                ConfigInspector.doValueDump(name + "[" + i + "]", config, null, skipNulls, buffer);
                continue;
            }
            ConfigInspector.doConfigDump(name + "[" + ConfigInspector.getConfigIndex(config, i) + "]", config, parameterFields, skipNulls, buffer);
        }
    }

    private static String getConfigIndex(Object config, int index) {
        Field identifierField = ConfigInspector.getIdentifierField(config.getClass());
        if (identifierField == null) {
            return Integer.toString(index);
        }
        identifierField.setAccessible(true);
        Object value = ConfigInspector.getFieldValue(config, identifierField);
        if (value == null) {
            return Integer.toString(index);
        }
        return String.valueOf(value);
    }
}

