/*
 * Decompiled with CFR 0.152.
 */
package de.objektkontor.config.backend;

import de.objektkontor.config.DuplicateConfigIdException;
import de.objektkontor.config.ValueFormatException;
import de.objektkontor.config.ValueParser;
import de.objektkontor.config.backend.AbstractConfigBackend;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;

public abstract class PropertyBackend
extends AbstractConfigBackend {
    protected final String sourceName;
    protected final Properties properties = new Properties();

    protected PropertyBackend(String sourceName) {
        this.sourceName = sourceName;
    }

    @Override
    public <V> V getValue(String key, Class<V> valueType) throws ValueFormatException {
        String value = this.properties.getProperty(key);
        if (value == null) {
            return null;
        }
        ValueParser<V> parser = PropertyBackend.getParser(valueType);
        try {
            return parser.parseValue(value, valueType);
        }
        catch (Exception e) {
            throw new ValueFormatException(this.sourceName, key, e);
        }
    }

    @Override
    public <V> V getValue(String key, V defaultValue) throws ValueFormatException {
        String value = this.properties.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        Class<?> valueType = defaultValue.getClass();
        ValueParser<?> parser = PropertyBackend.getParser(valueType);
        try {
            return (V)parser.parseValue(value, valueType);
        }
        catch (Exception e) {
            throw new ValueFormatException(this.sourceName, key, e);
        }
    }

    @Override
    public <V> V[] getValues(String key, Class<V> valueType) throws ValueFormatException {
        String values = this.properties.getProperty(key);
        if (values == null) {
            return null;
        }
        ValueParser<V> parser = PropertyBackend.getParser(valueType);
        try {
            return parser.parseValues(values, valueType);
        }
        catch (Exception e) {
            throw new ValueFormatException(this.sourceName, key, e);
        }
    }

    @Override
    public <V> V[] getValues(String key, V[] defaultValues) throws ValueFormatException {
        String values = this.properties.getProperty(key);
        if (values == null) {
            return defaultValues;
        }
        Class<?> valueType = defaultValues.getClass().getComponentType();
        ValueParser<?> parser = PropertyBackend.getParser(valueType);
        try {
            return parser.parseValues(values, valueType);
        }
        catch (Exception e) {
            throw new ValueFormatException(this.sourceName, key, e);
        }
    }

    @Override
    public Set<String> getSubconfigIds(String key) throws DuplicateConfigIdException {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        String[] ids = this.getValues(key, String.class);
        if (ids == null) {
            return result;
        }
        for (String id : ids) {
            if (result.contains(id)) {
                throw new DuplicateConfigIdException(id);
            }
            result.add(id);
        }
        return result;
    }

    protected void cleanup() {
        Iterator<Object> i = this.properties.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = this.properties.getProperty(key);
            if (value == null || !value.isEmpty() && !value.matches("\\s+")) continue;
            i.remove();
        }
    }

    public static Properties loadProperties(File file) throws IOException {
        Properties result = new Properties();
        try (FileInputStream in = new FileInputStream(file);){
            result.load(in);
            Properties properties = result;
            return properties;
        }
    }
}

