/*
 * Decompiled with CFR 0.152.
 */
package de.objektkontor.config.backend;

import de.objektkontor.config.backend.PropertyBackend;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyClasspathBackend
extends PropertyBackend {
    private static final Logger log = LoggerFactory.getLogger(PropertyClasspathBackend.class);
    private final ClassLoader classLoader;
    private final Properties override;

    public PropertyClasspathBackend(String sourceName) throws Exception {
        this(null, sourceName);
    }

    public PropertyClasspathBackend(String sourceName, Properties override) throws Exception {
        this(null, sourceName, override);
    }

    public PropertyClasspathBackend(ClassLoader classLoader, String sourceName) throws Exception {
        this(classLoader, sourceName, null);
    }

    public PropertyClasspathBackend(ClassLoader classLoader, String sourceName, Properties override) throws Exception {
        super(sourceName);
        this.classLoader = classLoader;
        this.override = override;
        this.doReload();
    }

    @Override
    protected void doReload() throws Exception {
        ClassLoader loader = this.classLoader;
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if (loader == null) {
            loader = PropertyClasspathBackend.class.getClassLoader();
        }
        try (InputStream defaultBundle = loader.getResourceAsStream("default/" + this.sourceName + ".properties");
             InputStream stageBundle = loader.getResourceAsStream("stage/" + this.sourceName + ".properties");
             InputStream rootBundle = loader.getResourceAsStream(this.sourceName + ".properties");){
            if (defaultBundle == null && stageBundle == null && rootBundle == null) {
                log.warn("No property files found in classpath for bundle: " + this.sourceName);
            }
            if (defaultBundle != null) {
                log.debug("default bundle " + this.sourceName + " found");
                this.properties.load(defaultBundle);
            }
            if (stageBundle != null) {
                log.debug("stage bundle " + this.sourceName + " found");
                this.properties.load(stageBundle);
            }
            if (rootBundle != null) {
                log.debug("root bundle " + this.sourceName + " found");
                this.properties.load(rootBundle);
            }
            if (this.override != null) {
                log.debug("applying override properties");
                this.properties.putAll((Map<?, ?>)this.override);
            }
            this.cleanup();
            if (log.isDebugEnabled() && !this.properties.isEmpty()) {
                log.debug("(Re)Loaded configuration values for bundle: " + this.sourceName);
                log.debug(this.properties.toString());
            }
        }
    }
}

