/*
 * Decompiled with CFR 0.152.
 */
package de.objektkontor.config.common;

import de.objektkontor.config.ObservableConfig;
import de.objektkontor.config.annotation.ConfigParameter;
import de.objektkontor.config.common.smtp.AuthConfig;
import de.objektkontor.config.common.smtp.HttpProxyConfig;
import de.objektkontor.config.common.smtp.SaslConfig;
import de.objektkontor.config.common.smtp.SocketFactoryConfig;
import de.objektkontor.config.common.smtp.SocksProxyConfig;
import de.objektkontor.config.common.smtp.SslConfig;
import de.objektkontor.config.common.smtp.StartTlsConfig;
import java.util.Properties;

public class SmtpConfig
extends ObservableConfig {
    @ConfigParameter(description="Default user name for SMTP.")
    private String user;
    @ConfigParameter(description="The SMTP server to connect to.")
    private String host;
    @ConfigParameter(description="The SMTP server port to connect to, if the connect() method doesn't explicitly specify one. Defaults to 25.")
    private Integer port;
    @ConfigParameter(description="Socket connection timeout value in milliseconds. This timeout is implemented by java.net.Socket. Default is infinite timeout.")
    private Integer connectionTimeout;
    @ConfigParameter(description="Socket read timeout value in milliseconds. This timeout is implemented by java.net.Socket. Default is infinite timeout.")
    private Integer timeout;
    @ConfigParameter(description="Socket write timeout value in milliseconds. This timeout is implemented by using a java.util.concurrent.ScheduledExecutorService per connection that schedules a thread to close the socket if the timeout expires. Thus, the overhead of using this timeout is one thread per connection. Default is infinite timeout.")
    private Integer writeTimeout;
    @ConfigParameter(description="Email address to use for SMTP MAIL command. This sets the envelope return address. Defaults to msg.getFrom() or InternetAddress.getLocalAddress(). NOTE: mail.smtp.user was previously used for this.")
    private String from;
    @ConfigParameter(description="Local host name used in the SMTP HELO or EHLO command. Defaults to InetAddress.getLocalHost().getHostName(). Should not normally need to be set if your JDK and your name service are configured properly.")
    private String localHost;
    @ConfigParameter(description="Local address (host name) to bind to when creating the SMTP socket. Defaults to the address picked by the Socket class. Should not normally need to be set, but useful with multi-homed hosts where it's important to pick a particular local address to bind to.")
    private String localAddress;
    @ConfigParameter(description="Local port number to bind to when creating the SMTP socket. Defaults to the port number picked by the Socket class.")
    private Integer localPort;
    @ConfigParameter(description="If false, do not attempt to sign on with the EHLO command. Defaults to true. Normally failure of the EHLO command will fallback to the HELO command; this property exists only for servers that don't fail EHLO properly or don't implement EHLO properly.")
    private Boolean ehlo;
    @ConfigParameter(description="User authentication configuration.")
    private AuthConfig auth;
    @ConfigParameter(description="The submitter to use in the AUTH tag in the MAIL FROM command. Typically used by a mail relay to pass along information about the original submitter of the message. See also the setSubmitter method of SMTPMessage. Mail clients typically do not use this.")
    private String submitter;
    @ConfigParameter(description="The NOTIFY option to the RCPT command. Either NEVER, or some combination of SUCCESS, FAILURE, and DELAY (separated by commas).")
    private String dsnNotify;
    @ConfigParameter(description="The RET option to the MAIL command. Either FULL or HDRS.")
    private String dsnRet;
    @ConfigParameter(description="If set to true, and the server supports the 8BITMIME extension, text parts of messages that use the \"quoted-printable\" or \"base64\" encodings are converted to use \"8bit\" encoding if they follow the RFC2045 rules for 8bit text.")
    private Boolean allow8BitMime;
    @ConfigParameter(description="If set to true, and a message has some valid and some invalid addresses, send the message anyway, reporting the partial failure with a SendFailedException. If set to false (the default), the message is not sent to any of the recipients if there is an invalid recipient address.")
    private Boolean sendPartial;
    @ConfigParameter(description="Sasl configuration")
    private SaslConfig sasl;
    @ConfigParameter(description="If set to false, the QUIT command is sent and the connection is immediately closed. If set to true (the default), causes the transport to wait for the response to the QUIT command.")
    private Boolean quitWait;
    @ConfigParameter(description="If set to true, causes the transport to include an SMTPAddressSucceededException for each address that is successful. Note also that this will cause a SendFailedException to be thrown from the sendMessage method of SMTPTransport even if all addresses were correct and the message was sent successfully.")
    private Boolean reportsuccess;
    @ConfigParameter(description="SockerFactory configuration")
    private SocketFactoryConfig socketFactory;
    @ConfigParameter(description="Ssl configuration")
    private SslConfig ssl;
    @ConfigParameter(description="If set, enables the use of the STARTTLS command (if supported by the server) to switch the connection to a TLS-protected connection before issuing any login commands. Note that an appropriate trust store must configured so that the client will trust the server's certificate. Defaults to disabled.")
    private StartTlsConfig startTls;
    @ConfigParameter(description="Http proxy configuration")
    private HttpProxyConfig httpProxy;
    @ConfigParameter(description="Socks proxy configuration")
    private SocksProxyConfig socksProxy;
    @ConfigParameter(description="Extension string to append to the MAIL command. The extension string can be used to specify standard SMTP service extensions as well as vendor-specific extensions. Typically the application should use the SMTPTransport method supportsExtension to verify that the server supports the desired service extension. See RFC 1869 and other RFCs that define specific extensions.")
    private String mailExtension;
    @ConfigParameter(description="If set to true, use the RSET command instead of the NOOP command in the isConnected method. In some cases sendmail will respond slowly after many NOOP commands; use of RSET avoids this sendmail issue. Defaults to false.")
    private Boolean useRset;
    @ConfigParameter(description="If set to true (the default), insist on a 250 response code from the NOOP command to indicate success. The NOOP command is used by the isConnected method to determine if the connection is still alive. Some older servers return the wrong response code on success, some servers don't implement the NOOP command at all and so always return a failure code. Set this property to false to handle servers that are broken in this way. Normally, when a server times out a connection, it will send a 421 response code, which the client will see as the response to the next command it issues. Some servers send the wrong failure response code when timing out a connection. Do not set this property to false when dealing with servers that are broken in this way.")
    private Boolean noopStrict;

    public void applyTo(Properties properties) {
        this.applyTo(properties, "mail.smtp.");
    }

    public void applyToSmtps(Properties properties) {
        this.applyTo(properties, "mail.smtps.");
    }

    private void applyTo(Properties properties, String prefix) {
        SocksProxyConfig socksProxy;
        HttpProxyConfig httpProxy;
        StartTlsConfig startTls;
        SslConfig ssl;
        this.setValue(properties, prefix, "user", this.getUser());
        this.setValue(properties, prefix, "host", this.getHost());
        this.setValue(properties, prefix, "port", this.getPort());
        this.setValue(properties, prefix, "connectiontimeout", this.getConnectionTimeout());
        this.setValue(properties, prefix, "timeout", this.getTimeout());
        this.setValue(properties, prefix, "writetimeout", this.getWriteTimeout());
        this.setValue(properties, prefix, "from", this.getFrom());
        this.setValue(properties, prefix, "localhost", this.getLocalHost());
        this.setValue(properties, prefix, "localaddress", this.getLocalAddress());
        this.setValue(properties, prefix, "localport", this.getLocalPort());
        this.setValue(properties, prefix, "ehlo", this.getEhlo());
        AuthConfig auth = this.getAuth();
        if (auth != null) {
            this.setValue(properties, prefix, "auth.enable", auth.getEnable());
            this.setValue(properties, prefix, "auth.mechanisms", auth.getMechanisms());
            this.setValue(properties, prefix, "auth.login.disable", auth.getLoginDisable());
            this.setValue(properties, prefix, "auth.plain.disable", auth.getPlainDisable());
            this.setValue(properties, prefix, "auth.digest-md5.disable", auth.getDigestMd5Disable());
            this.setValue(properties, prefix, "auth.ntlm.disable", auth.getNtlmDisable());
            this.setValue(properties, prefix, "auth.ntlm.domain", auth.getNtlmDomain());
            this.setValue(properties, prefix, "auth.ntlm.flags", auth.getNtlmFlags());
            this.setValue(properties, prefix, "auth.xoauth2.disable", auth.getXoauth2Disable());
        }
        this.setValue(properties, prefix, "submitter", this.getSubmitter());
        this.setValue(properties, prefix, "dsn.notify", this.getDsnNotify());
        this.setValue(properties, prefix, "dsn.ret", this.getDsnRet());
        this.setValue(properties, prefix, "allow8bitmime", this.getAllow8BitMime());
        this.setValue(properties, prefix, "sendpartial", this.getSendPartial());
        SaslConfig sasl = this.getSasl();
        if (sasl != null) {
            this.setValue(properties, prefix, "sasl.enable", sasl.getEnable());
            this.setValue(properties, prefix, "sasl.mechanisms", sasl.getMechanisms());
            this.setValue(properties, prefix, "sasl.authorizationid", sasl.getAuthorizationId());
            this.setValue(properties, prefix, "sasl.realm", sasl.getRealm());
            this.setValue(properties, prefix, "sasl.usecanonicalhostname", sasl.getUseCanonicalHostName());
        }
        this.setValue(properties, prefix, "quitwait", this.getQuitWait());
        this.setValue(properties, prefix, "reportsuccess", this.getReportsuccess());
        SocketFactoryConfig socketFactory = this.getSocketFactory();
        if (socketFactory != null) {
            this.setValue(properties, prefix, "socketFactory.class", socketFactory.getClassName());
            this.setValue(properties, prefix, "socketFactory.fallback", socketFactory.getFallback());
            this.setValue(properties, prefix, "socketFactory.port", socketFactory.getPort());
        }
        if ((ssl = this.getSsl()) != null) {
            this.setValue(properties, prefix, "ssl.enable", ssl.getEnable());
            this.setValue(properties, prefix, "ssl.checkserveridentity", ssl.getCheckServerIdentity());
            this.setValue(properties, prefix, "ssl.trust", ssl.getTrust());
            socketFactory = ssl.getSocketFactory();
            if (socketFactory != null) {
                this.setValue(properties, prefix, "ssl.socketFactory.class", socketFactory.getClassName());
                this.setValue(properties, prefix, "ssl.socketFactory.port", socketFactory.getPort());
            }
            this.setValue(properties, prefix, "ssl.protocols", ssl.getProtocols());
            this.setValue(properties, prefix, "ssl.ciphersuites", ssl.getCipherSuites());
        }
        if ((startTls = this.getStartTls()) != null) {
            this.setValue(properties, prefix, "starttls.enable", startTls.getEnable());
            this.setValue(properties, prefix, "starttls.required", startTls.getRequired());
        }
        if ((httpProxy = this.getHttpProxy()) != null) {
            this.setValue(properties, prefix, "proxy.host", httpProxy.getHost());
            this.setValue(properties, prefix, "proxy.port", httpProxy.getPort());
        }
        if ((socksProxy = this.getSocksProxy()) != null) {
            this.setValue(properties, prefix, "socks.host", socksProxy.getHost());
            this.setValue(properties, prefix, "socks.port", socksProxy.getPort());
        }
        this.setValue(properties, prefix, "mailextension", this.getMailExtension());
        this.setValue(properties, prefix, "userset", this.getUseRset());
        this.setValue(properties, prefix, "noop.strict", this.getNoopStrict());
    }

    private void setValue(Properties properties, String prefix, String name, Object value) {
        if (value != null) {
            properties.setProperty(prefix + name, String.valueOf(value));
        }
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public Integer getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setWriteTimeout(Integer writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getLocalHost() {
        return this.localHost;
    }

    public void setLocalHost(String localHost) {
        this.localHost = localHost;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    public Integer getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(Integer localPort) {
        this.localPort = localPort;
    }

    public Boolean getEhlo() {
        return this.ehlo;
    }

    public void setEhlo(Boolean ehlo) {
        this.ehlo = ehlo;
    }

    public AuthConfig getAuth() {
        return this.auth;
    }

    public void setAuth(AuthConfig auth) {
        this.auth = auth;
    }

    public String getSubmitter() {
        return this.submitter;
    }

    public void setSubmitter(String submitter) {
        this.submitter = submitter;
    }

    public String getDsnNotify() {
        return this.dsnNotify;
    }

    public void setDsnNotify(String dsnNotify) {
        this.dsnNotify = dsnNotify;
    }

    public String getDsnRet() {
        return this.dsnRet;
    }

    public void setDsnRet(String dsnRet) {
        this.dsnRet = dsnRet;
    }

    public Boolean getAllow8BitMime() {
        return this.allow8BitMime;
    }

    public void setAllow8BitMime(Boolean allow8BitMime) {
        this.allow8BitMime = allow8BitMime;
    }

    public Boolean getSendPartial() {
        return this.sendPartial;
    }

    public void setSendPartial(Boolean sendPartial) {
        this.sendPartial = sendPartial;
    }

    public SaslConfig getSasl() {
        return this.sasl;
    }

    public void setSasl(SaslConfig sasl) {
        this.sasl = sasl;
    }

    public Boolean getQuitWait() {
        return this.quitWait;
    }

    public void setQuitWait(Boolean quitWait) {
        this.quitWait = quitWait;
    }

    public Boolean getReportsuccess() {
        return this.reportsuccess;
    }

    public void setReportsuccess(Boolean reportsuccess) {
        this.reportsuccess = reportsuccess;
    }

    public SocketFactoryConfig getSocketFactory() {
        return this.socketFactory;
    }

    public void setSocketFactory(SocketFactoryConfig socketFactory) {
        this.socketFactory = socketFactory;
    }

    public SslConfig getSsl() {
        return this.ssl;
    }

    public void setSsl(SslConfig ssl) {
        this.ssl = ssl;
    }

    public StartTlsConfig getStartTls() {
        return this.startTls;
    }

    public void setStartTls(StartTlsConfig startTls) {
        this.startTls = startTls;
    }

    public HttpProxyConfig getHttpProxy() {
        return this.httpProxy;
    }

    public void setHttpProxy(HttpProxyConfig httpProxy) {
        this.httpProxy = httpProxy;
    }

    public SocksProxyConfig getSocksProxy() {
        return this.socksProxy;
    }

    public void setSocksProxy(SocksProxyConfig socksProxy) {
        this.socksProxy = socksProxy;
    }

    public String getMailExtension() {
        return this.mailExtension;
    }

    public void setMailExtension(String mailExtension) {
        this.mailExtension = mailExtension;
    }

    public Boolean getUseRset() {
        return this.useRset;
    }

    public void setUseRset(Boolean useRset) {
        this.useRset = useRset;
    }

    public Boolean getNoopStrict() {
        return this.noopStrict;
    }

    public void setNoopStrict(Boolean noopStrict) {
        this.noopStrict = noopStrict;
    }
}

