/*
 * Decompiled with CFR 0.152.
 */
package de.objektkontor.config.reload;

import de.objektkontor.config.ReloadInitiator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Signal;

public class SignalReloadInitiator
extends ReloadInitiator {
    private static final Logger log = LoggerFactory.getLogger(SignalReloadInitiator.class);
    private static final String SIGNAL_PARAMETER = "ConfigReloadSignal";
    private static final String DEFAULT_SIGNAL = "USR2";

    public SignalReloadInitiator() {
        log.info("Configuring Signal Reload Initiator");
        String signal = this.getSignalName();
        Signal.handle(new Signal(signal), signal1 -> {
            if (log.isDebugEnabled()) {
                log.debug("Signal received. Notifying handlers.");
            }
            this.notifyHandlers();
        });
        log.info("Configuration reloading enabled. Use command <kill -s SIG" + signal + " " + SignalReloadInitiator.getProcessId() + "> to reload configuration");
    }

    private String getSignalName() {
        String name = SignalReloadInitiator.getParameter(SIGNAL_PARAMETER, DEFAULT_SIGNAL);
        if (name.startsWith("SIG")) {
            return name.substring(3);
        }
        return name;
    }
}

