/*
 * Decompiled with CFR 0.152.
 */
package de.objektkontor.config.reload;

import de.objektkontor.config.ReloadInitiator;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TouchReloadInitiator
extends ReloadInitiator {
    private static final Logger logger = LoggerFactory.getLogger(TouchReloadInitiator.class);
    private static final String FILE_PARAMETER = "ConfigReloadFile";
    private static final String DEFAULT_FILE = "reload_config_<PID>.tmp";
    private static final String DEFAULT_CHECK_INTERVAL = "1000";
    private final File file;
    private final long checkInterval;

    public TouchReloadInitiator() throws IOException {
        logger.info("Configuring File Touch Reload Initiator");
        this.checkInterval = TouchReloadInitiator.getCheckInterval(DEFAULT_CHECK_INTERVAL);
        this.file = this.getFile();
        this.startThread();
        logger.info("Configuration reloading enabled. Use command <touch " + this.file + "> to reload configuration");
    }

    private File getFile() throws IOException {
        Object name = TouchReloadInitiator.getParameter(FILE_PARAMETER, DEFAULT_FILE);
        if (!((String)name).startsWith(File.separator)) {
            name = System.getProperty("java.io.tmpdir") + File.separator + (String)name;
        }
        name = ((String)name).replace("<PID>", TouchReloadInitiator.getProcessId());
        File file = new File((String)name);
        file.createNewFile();
        file.deleteOnExit();
        return file;
    }

    private void startThread() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    long timestamp = TouchReloadInitiator.this.file.lastModified();
                    while (true) {
                        Thread.sleep(TouchReloadInitiator.this.checkInterval);
                        long currentTimestamp = TouchReloadInitiator.this.file.lastModified();
                        if (currentTimestamp == timestamp) continue;
                        timestamp = currentTimestamp;
                        if (logger.isDebugEnabled()) {
                            logger.debug("File timestamp change detected. Notifying handlers.");
                        }
                        TouchReloadInitiator.this.notifyHandlers();
                    }
                }
                catch (InterruptedException e) {
                    logger.warn(Thread.currentThread().getName() + " was interrupted");
                    return;
                }
            }
        };
        Thread thread = new Thread(runnable, "Config-Loader");
        thread.setDaemon(true);
        thread.start();
    }
}

