/*
 * Decompiled with CFR 0.152.
 */
package de.obqo.decycle.report;

import com.google.common.base.Preconditions;
import j2html.tags.InlineStaticResource;
import j2html.utils.CSSMin;
import j2html.utils.JSMin;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.Properties;
import org.webjars.MultipleMatchesException;
import org.webjars.WebJarAssetLocator;

public class ResourcesExtractor {
    private static final Properties VERSION_PROPERTIES = ResourcesExtractor.loadVersionProperties();
    private static final String BOOTSTRAP_VERSION_PROP = "bootstrapVersion";
    private static final String BOOTSTRAP_ICONS_VERSION_PROP = "bootstrapIconsVersion";
    private static final String JQUERY_VERSION_PROP = "jqueryVersion";
    private static final String TOOLTIPSTER_VERSION_PROP = "tooltipsterVersion";
    private static final String SVGJS_VERSION_PROP = "svgjsVersion";
    private static final WebJarAssetLocator locator = new WebJarAssetLocator();

    private static Properties loadVersionProperties() {
        Properties versionProperties = new Properties();
        versionProperties.load(ResourcesExtractor.class.getResourceAsStream("/gradle.properties"));
        return versionProperties;
    }

    public static void copyResources(File targetDir) throws IOException {
        targetDir.mkdirs();
        ResourcesExtractor.copyLocalResource(targetDir, "custom.css");
        ResourcesExtractor.copyLocalResource(targetDir, "custom.js");
        ResourcesExtractor.copyWebJarResource(targetDir, "bootstrap", "bootstrap.min.css", BOOTSTRAP_VERSION_PROP);
        ResourcesExtractor.copyWebJarResource(targetDir, "bootstrap-icons", "bootstrap-icons.css", BOOTSTRAP_ICONS_VERSION_PROP);
        ResourcesExtractor.copyWebJarResource(targetDir, "bootstrap-icons", "fonts/bootstrap-icons.woff", BOOTSTRAP_ICONS_VERSION_PROP);
        ResourcesExtractor.copyWebJarResource(targetDir, "bootstrap-icons", "fonts/bootstrap-icons.woff2", BOOTSTRAP_ICONS_VERSION_PROP);
        ResourcesExtractor.copyWebJarResource(targetDir, "jquery", "jquery.min.js", JQUERY_VERSION_PROP);
        ResourcesExtractor.copyWebJarResource(targetDir, "tooltipster", "tooltipster.bundle.min.js", TOOLTIPSTER_VERSION_PROP);
        ResourcesExtractor.copyWebJarResource(targetDir, "tooltipster", "tooltipster.bundle.min.css", TOOLTIPSTER_VERSION_PROP);
        ResourcesExtractor.copyWebJarResource(targetDir, "tooltipster", "tooltipster-SVG.min.js", TOOLTIPSTER_VERSION_PROP);
        ResourcesExtractor.copyWebJarResource(targetDir, "svg.js", "svg.min.js", SVGJS_VERSION_PROP);
    }

    private static void copyLocalResource(File targetDir, String name) throws IOException {
        String content = InlineStaticResource.getFileAsString((String)("/report/" + name));
        if (name.endsWith(".css")) {
            content = CSSMin.compressCss((String)content);
        } else if (name.endsWith(".js")) {
            content = JSMin.compressJs((String)content);
        }
        File targetFile = ResourcesExtractor.getTargetFile(targetDir, name);
        Files.writeString(targetFile.toPath(), (CharSequence)content, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    private static void copyWebJarResource(File targetDir, String webjar, String asset, String version) throws IOException {
        String fullPath = ResourcesExtractor.getFullPath(webjar, asset, version);
        InputStream inputStream = locator.getClass().getClassLoader().getResourceAsStream(fullPath);
        Objects.requireNonNull(inputStream, () -> String.format("Cannot read resource %s", fullPath));
        File targetFile = ResourcesExtractor.getTargetFile(targetDir, asset);
        Files.copy(inputStream, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    private static String getFullPath(String webjar, String asset, String versionProp) {
        try {
            return locator.getFullPath(webjar, asset);
        }
        catch (MultipleMatchesException ex) {
            String version = VERSION_PROPERTIES.getProperty(versionProp);
            Preconditions.checkNotNull((Object)version, (Object)("Missing property value for " + versionProp));
            String versionPath = "/" + version + "/";
            return ex.getMatches().stream().filter(path -> path.contains(versionPath)).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Unable to find %s for version %s", asset, version)));
        }
    }

    private static File getTargetFile(File targetDir, String name) {
        File targetFile = new File(targetDir, name);
        if (name.contains("/")) {
            targetFile.getParentFile().mkdirs();
        }
        return targetFile;
    }
}

