/*
 * Decompiled with CFR 0.152.
 */
package de.obqo.decycle.check;

import de.obqo.decycle.graph.Slicing;
import de.obqo.decycle.graph.SlicingSource;
import de.obqo.decycle.model.Edge;
import de.obqo.decycle.model.SliceType;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public interface Constraint {
    public String getShortString();

    public List<Violation> violations(SlicingSource var1);

    public static final class Violation {
        private final String name;
        private final Slicing violatingSubgraph;

        public SliceType getSliceType() {
            return this.violatingSubgraph.getSliceType();
        }

        public Set<Edge> getDependencies() {
            return new TreeSet<Edge>(this.violatingSubgraph.edges());
        }

        public String toString() {
            return this.displayString();
        }

        public String displayString() {
            return String.format("Violation(slicing=%s, name=%s, dependencies=[%s])", this.getSliceType().displayString(), this.name, this.getDependencies().stream().map(Edge::displayString).collect(Collectors.joining(", ")));
        }

        public static String displayString(List<Violation> violations) {
            return violations.stream().map(Violation::displayString).collect(Collectors.joining("\n"));
        }

        public Violation(String name, Slicing violatingSubgraph) {
            this.name = name;
            this.violatingSubgraph = violatingSubgraph;
        }

        public String getName() {
            return this.name;
        }

        public Slicing getViolatingSubgraph() {
            return this.violatingSubgraph;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Violation)) {
                return false;
            }
            Violation other = (Violation)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Slicing this$violatingSubgraph = this.getViolatingSubgraph();
            Slicing other$violatingSubgraph = other.getViolatingSubgraph();
            return !(this$violatingSubgraph == null ? other$violatingSubgraph != null : !this$violatingSubgraph.equals(other$violatingSubgraph));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Slicing $violatingSubgraph = this.getViolatingSubgraph();
            result = result * 59 + ($violatingSubgraph == null ? 43 : $violatingSubgraph.hashCode());
            return result;
        }
    }
}

