/*
 * Decompiled with CFR 0.152.
 */
package de.obqo.decycle.check;

import de.obqo.decycle.check.Layer;
import de.obqo.decycle.check.SlicedConstraint;
import de.obqo.decycle.model.Edge;
import de.obqo.decycle.model.SliceType;
import java.util.List;

public final class DirectLayeringConstraint
extends SlicedConstraint {
    public DirectLayeringConstraint(String sliceType, List<Layer> layers) {
        super(SliceType.customType(sliceType), layers, " => ");
    }

    @Override
    protected boolean isViolatedBy(Edge edge) {
        int j;
        int i = this.indexOf(edge.getFrom());
        return this.containsBothNodes(i, j = this.indexOf(edge.getTo())) && this.nodesViolateOrder(i, j) || this.containsOnlyToNodeWhichIsNotTheFirst(i, j) || this.containsOnlyFromNodeWhichIsNotTheLast(i, j);
    }

    private boolean nodesViolateOrder(int i, int j) {
        return this.nodesAreInWrongOrder(i, j) || this.nodesAreNotDirectlyConnected(i, j) || this.nodesAreInTheSameOneOfLayer(i, j);
    }

    private boolean nodesAreNotDirectlyConnected(int i, int j) {
        return j - i > 1;
    }

    private boolean containsOnlyToNodeWhichIsNotTheFirst(int i, int j) {
        return i < 0 && j > 0;
    }

    private boolean containsOnlyFromNodeWhichIsNotTheLast(int i, int j) {
        return i >= 0 && i < this.layers.size() - 1 && j < 0;
    }
}

