/*
 * Decompiled with CFR 0.152.
 */
package de.obqo.decycle.graph;

import de.obqo.decycle.graph.Slicing;
import de.obqo.decycle.model.Edge;
import de.obqo.decycle.model.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

class Topological {
    Topological() {
    }

    static List<Node> order(Slicing slicing) {
        return new DepthFirstOrder(slicing).reversePost();
    }

    private static class DepthFirstOrder {
        private final Set<Node> marked = new HashSet<Node>();
        private final List<Node> postorder = new LinkedList<Node>();

        DepthFirstOrder(Slicing g) {
            for (Node node : this.sorted(g.nodes(), Node.COMPARATOR.reversed())) {
                if (this.marked.contains(node)) continue;
                this.depthFirstSearch(g, node);
            }
        }

        private void depthFirstSearch(Slicing g, Node node) {
            this.marked.add(node);
            for (Edge e : this.sorted(g.outEdges(node), Edge.COMPARATOR.reversed())) {
                Node to = e.getTo();
                if (!e.isIncluded() || this.marked.contains(to)) continue;
                this.depthFirstSearch(g, to);
            }
            this.postorder.add(node);
        }

        private <T> Set<T> sorted(Set<T> set, Comparator<T> comparator) {
            TreeSet<T> result = new TreeSet<T>(comparator);
            result.addAll(set);
            return result;
        }

        List<Node> reversePost() {
            ArrayList<Node> reverse = new ArrayList<Node>(this.postorder);
            Collections.reverse(reverse);
            return reverse;
        }
    }
}

