/*
 * Decompiled with CFR 0.152.
 */
package de.obqo.decycle.check;

import de.obqo.decycle.graph.SlicingSource;
import de.obqo.decycle.model.Edge;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public interface Constraint {
    public String getShortString();

    public List<Violation> violations(SlicingSource var1);

    public static final class Violation {
        private final String sliceType;
        private final String name;
        private final Set<Dependency> dependencies;

        public Violation(String sliceType, String name, Set<Dependency> dependencies) {
            this.sliceType = sliceType;
            this.name = name;
            this.dependencies = dependencies;
        }

        public String getSliceType() {
            return this.sliceType;
        }

        public String getName() {
            return this.name;
        }

        public Set<Dependency> getDependencies() {
            return this.dependencies;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Violation)) {
                return false;
            }
            Violation other = (Violation)o;
            String this$sliceType = this.getSliceType();
            String other$sliceType = other.getSliceType();
            if (this$sliceType == null ? other$sliceType != null : !this$sliceType.equals(other$sliceType)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Set<Dependency> this$dependencies = this.getDependencies();
            Set<Dependency> other$dependencies = other.getDependencies();
            return !(this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sliceType = this.getSliceType();
            result = result * 59 + ($sliceType == null ? 43 : $sliceType.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Set<Dependency> $dependencies = this.getDependencies();
            result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
            return result;
        }

        public String toString() {
            return "Constraint.Violation(sliceType=" + this.getSliceType() + ", name=" + this.getName() + ", dependencies=" + this.getDependencies() + ")";
        }
    }

    public static final class Dependency
    implements Comparable<Dependency> {
        private static Comparator<Dependency> COMPARATOR = Comparator.comparing(Dependency::getFrom).thenComparing(Dependency::getTo);
        private final String from;
        private final String to;

        static Dependency of(Edge edge) {
            return new Dependency(edge.getFrom().getName(), edge.getTo().getName());
        }

        public String toString() {
            return this.from + " \u2192 " + this.to;
        }

        @Override
        public int compareTo(Dependency other) {
            return COMPARATOR.compare(this, other);
        }

        public Dependency(String from, String to) {
            this.from = from;
            this.to = to;
        }

        public String getFrom() {
            return this.from;
        }

        public String getTo() {
            return this.to;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Dependency)) {
                return false;
            }
            Dependency other = (Dependency)o;
            String this$from = this.getFrom();
            String other$from = other.getFrom();
            if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
                return false;
            }
            String this$to = this.getTo();
            String other$to = other.getTo();
            return !(this$to == null ? other$to != null : !this$to.equals(other$to));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $from = this.getFrom();
            result = result * 59 + ($from == null ? 43 : $from.hashCode());
            String $to = this.getTo();
            result = result * 59 + ($to == null ? 43 : $to.hashCode());
            return result;
        }
    }
}

