/*
 * Decompiled with CFR 0.152.
 */
package de.obqo.decycle.check;

import de.obqo.decycle.check.Constraint;
import de.obqo.decycle.graph.SlicingSource;
import de.obqo.decycle.graph.StronglyConnectedComponentsFinder;
import de.obqo.decycle.model.Edge;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class CycleFree
implements Constraint {
    @Override
    public String getShortString() {
        return "no cycles";
    }

    @Override
    public List<Constraint.Violation> violations(SlicingSource slicingSource) {
        ArrayList<Constraint.Violation> list = new ArrayList<Constraint.Violation>();
        for (String sliceType : slicingSource.sliceTypes()) {
            if ("Class".equals(sliceType)) continue;
            for (Set<Edge> comp : StronglyConnectedComponentsFinder.findComponents(slicingSource.slicing(sliceType))) {
                list.add(new Constraint.Violation(sliceType, this.getShortString(), comp.stream().map(Constraint.Dependency::of).collect(Collectors.toCollection(TreeSet::new))));
            }
        }
        return list;
    }
}

