/*
 * Decompiled with CFR 0.152.
 */
package de.obqo.decycle.check;

import de.obqo.decycle.check.Constraint;
import de.obqo.decycle.check.Layer;
import de.obqo.decycle.graph.Slicing;
import de.obqo.decycle.graph.SlicingSource;
import de.obqo.decycle.model.Edge;
import de.obqo.decycle.model.Node;
import java.util.List;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class SlicedConstraint
implements Constraint {
    private final String sliceType;
    final List<Layer> layers;
    private final String arrow;

    abstract boolean isViolatedBy(Node var1, Node var2);

    int indexOf(Node node) {
        for (int i = 0; i < this.layers.size(); ++i) {
            if (!this.layers.get(i).contains(node.getName())) continue;
            return i;
        }
        return -1;
    }

    boolean constraintContainsBothNodes(int i, int j) {
        return i >= 0 && j >= 0;
    }

    @Override
    public List<Constraint.Violation> violations(SlicingSource slicingSource) {
        Slicing sg = slicingSource.slicing(this.sliceType);
        TreeSet deps = sg.edges().stream().filter(Predicate.not(Edge::isIgnored)).filter(e -> this.isViolatedBy(e.getFrom(), e.getTo())).map(Constraint.Dependency::of).collect(Collectors.toCollection(TreeSet::new));
        return deps.isEmpty() ? List.of() : List.of(new Constraint.Violation(this.sliceType, this.getShortString(), deps));
    }

    @Override
    public String getShortString() {
        return this.layers.stream().map(Layer::getShortString).collect(Collectors.joining(this.arrow));
    }

    public String toString() {
        return this.getShortString();
    }

    public SlicedConstraint(String sliceType, List<Layer> layers, String arrow) {
        this.sliceType = sliceType;
        this.layers = layers;
        this.arrow = arrow;
    }
}

