/*
 * Decompiled with CFR 0.152.
 */
package de.obqo.decycle.graph;

import com.google.common.graph.Network;
import de.obqo.decycle.model.Edge;
import de.obqo.decycle.model.Node;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

class SliceNodeFinder {
    private final String sliceType;
    private final Network<Node, Edge> internalGraph;

    Optional<Node> find(Node node) {
        return this.allInNodesOfType(node).findFirst();
    }

    private Stream<Node> allInNodesOfType(Node node) {
        if (node.hasType(this.sliceType)) {
            return Stream.of(node);
        }
        return this.inEdges(node).stream().filter(Edge::isContaining).map(Edge::getFrom).flatMap(this::allInNodesOfType);
    }

    private Set<Edge> inEdges(Node node) {
        return this.internalGraph.nodes().contains(node) ? this.internalGraph.inEdges((Object)node) : Set.of();
    }

    public SliceNodeFinder(String sliceType, Network<Node, Edge> internalGraph) {
        this.sliceType = sliceType;
        this.internalGraph = internalGraph;
    }
}

