/*
 * Decompiled with CFR 0.152.
 */
package de.obqo.decycle.report;

import de.obqo.decycle.check.Constraint;
import de.obqo.decycle.graph.Graph;
import de.obqo.decycle.graph.Slicing;
import de.obqo.decycle.model.Edge;
import de.obqo.decycle.model.Node;
import de.obqo.decycle.report.MarkupReader;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.EmptyTag;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HtmlReport {
    private static final SliceComparator SLICE_COMPARATOR = new SliceComparator();

    public void writeReport(Graph graph, List<Constraint.Violation> violations, Appendable out, String title, boolean minify) {
        Stream<DomContent> sliceSections = graph.sliceTypes().stream().filter(Predicate.not("Class"::equals)).sorted(SLICE_COMPARATOR).map(sliceType -> this.renderSliceSection(graph, violations, (String)sliceType));
        ContainerTag html = ((ContainerTag)TagCreator.html().withLang("en")).with(new DomContent[]{TagCreator.head((DomContent[])new DomContent[]{TagCreator.meta().withCharset("UTF-8"), ((EmptyTag)TagCreator.meta().withName("viewport")).withContent("width=device-width, initial-scale=1, shrink-to-fit=no"), TagCreator.title((String)((String)(title != null ? title + " - " : "") + "Decycle Report")), ((EmptyTag)((EmptyTag)TagCreator.link().withHref("data:image/svg+xml;base64," + MarkupReader.base64FromFile_min("/report/icon.svg"))).withRel("icon")).withType("image/svg+xml"), ((EmptyTag)((EmptyTag)((EmptyTag)TagCreator.link().withRel("stylesheet")).withHref("https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/css/bootstrap.min.css")).attr("integrity", (Object)"sha384-B0vP5xmATw1+K9KRQjQERJvTumQW0nPEzvF6L/Z6nronJ3oUOFUFpCjEUQouq2+l")).attr("crossorigin", (Object)"anonymous"), ((EmptyTag)TagCreator.link().withRel("stylesheet")).withHref("https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css"), this.inlineStyle(minify, "/report/custom.css"), ((ContainerTag)((ContainerTag)TagCreator.script().withSrc("https://code.jquery.com/jquery-3.6.0.min.js")).attr("integrity", (Object)"sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=")).attr("crossorigin", (Object)"anonymous"), this.inlineScript(minify, "/report/custom.js")}), TagCreator.body((DomContent[])new DomContent[]{((ContainerTag)TagCreator.div().withClass("container-fluid p-3")).with((DomContent)((ContainerTag)TagCreator.div().withClass("mx-2")).with(new DomContent[]{this.inlineMarkup(minify, "/report/logo.svg"), TagCreator.hr().withClass("mt-1"), ((ContainerTag)TagCreator.h1().withClass("mb-3")).withText("Violation Report" + (String)(title != null ? " for " + title : "")), this.getViolationDiv(violations), TagCreator.each(sliceSections), TagCreator.hr(), ((ContainerTag)TagCreator.div().withClass("footer small")).with(new DomContent[]{TagCreator.text((String)"Generated by "), ((ContainerTag)((ContainerTag)TagCreator.a().withHref("https://github.com/obecker/decycle")).withTarget("decycle")).withText("Decycle"), TagCreator.text((String)" "), TagCreator.text((String)HtmlReport.class.getPackage().getImplementationVersion())})}))})});
        String text = minify ? html.render() : html.renderFormatted();
        try {
            out.append(text);
            out.append('\n');
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    private ContainerTag inlineStyle(boolean minify, String path) {
        return minify ? TagCreator.styleWithInlineFile_min((String)path) : TagCreator.styleWithInlineFile((String)path);
    }

    private ContainerTag inlineScript(boolean minify, String path) {
        return minify ? TagCreator.scriptWithInlineFile_min((String)path) : TagCreator.scriptWithInlineFile((String)path);
    }

    private DomContent inlineMarkup(boolean minify, String path) {
        return minify ? MarkupReader.rawHtmlWithInlineFile_min(path) : MarkupReader.rawHtmlWithInlineFile(path);
    }

    private DomContent getViolationDiv(List<Constraint.Violation> violations) {
        return violations.isEmpty() ? ((ContainerTag)TagCreator.div().withClass("violations border rounded-lg pb-1 mb-3 alert-success row")).with(new DomContent[]{((ContainerTag)TagCreator.h1().withClass("m-0 pt-2")).with((DomContent)TagCreator.i().withClass("bi bi-check-circle-fill")), ((ContainerTag)TagCreator.div().withClass("col-12 mt-1")).with((DomContent)TagCreator.b((String)"No violations found"))}) : ((ContainerTag)TagCreator.div().withClass("violations border rounded-lg pb-1 mb-3 alert-danger row")).with(new DomContent[]{((ContainerTag)TagCreator.h1().withClass("m-0 pt-2")).with((DomContent)TagCreator.i().withClass("bi bi-exclamation-triangle-fill")), TagCreator.each(violations.stream().sorted(Comparator.comparing(Constraint.Violation::getSliceType, SLICE_COMPARATOR).thenComparing(Constraint.Violation::getName)).flatMap(this::getViolationDivColumns))});
    }

    private Stream<ContainerTag> getViolationDivColumns(Constraint.Violation v) {
        return Stream.of(((ContainerTag)TagCreator.div().withClass("col-4 name mt-1")).with((DomContent)TagCreator.b((String)this.replaceArrows(v.getName()))), ((ContainerTag)TagCreator.div().withClass("col-8 dependencies mt-1")).with(v.getDependencies().stream().map(dependency -> TagCreator.div((DomContent[])new DomContent[]{((ContainerTag)TagCreator.a((String)dependency.toString()).withHref("#" + v.getSliceType() + "-" + dependency.getFrom())).withClass("alert-link")}))));
    }

    private String replaceArrows(String name) {
        return name.replace("->", "\u2192").replace("=>", "\u21e8");
    }

    private DomContent renderSliceSection(Graph graph, List<Constraint.Violation> violations, String sliceType) {
        Map violationsIndex = violations.stream().filter(v -> v.getSliceType().equals(sliceType)).flatMap(v -> v.getDependencies().stream().map(d -> Map.entry(d.getFrom(), Map.entry(d.getTo(), v.getName())))).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList())))));
        Slicing slicing = graph.slicing(sliceType);
        return ((ContainerTag)TagCreator.div().withClass("pt-2")).with(new DomContent[]{TagCreator.h2((String)sliceType).withClass("slice text-capitalize mt-2"), ((ContainerTag)TagCreator.dl().withClass("slices row border rounded-lg py-1")).with(slicing.nodes().stream().sorted().flatMap(node -> this.renderNodeTableRow(graph, slicing, violationsIndex, (Node)node)))});
    }

    private Stream<DomContent> renderNodeTableRow(Graph graph, Slicing slicing, Map<String, Map<String, List<String>>> violationsIndex, Node node) {
        Map<String, List<String>> fromViolations = violationsIndex.getOrDefault(node.getName(), Map.of());
        String errorClass = fromViolations.isEmpty() ? "" : "error";
        return Stream.of(((ContainerTag)((ContainerTag)TagCreator.dt().withClasses(new String[]{"col-sm-4", "border-top", "py-1", "text-truncate", errorClass})).withTitle(node.getName())).with((DomContent)TagCreator.a((String)node.getName()).withId(node.getType() + "-" + node.getName())), ((ContainerTag)TagCreator.dd().withClasses(new String[]{"col-sm-8", "border-top", "py-1", "mb-0", errorClass})).with((DomContent)((ContainerTag)TagCreator.ul().withClass("references list-unstyled mb-0")).with(this.renderOutEdgesList(graph, slicing, node, fromViolations))));
    }

    private Stream<DomContent> renderOutEdgesList(Graph graph, Slicing slicing, Node node, Map<String, List<String>> fromViolations) {
        return slicing.outEdges(node).stream().sorted().map(edge -> {
            List toViolations = fromViolations.getOrDefault(edge.getTo().getName(), List.of());
            boolean hasViolations = !toViolations.isEmpty();
            return ((ContainerTag)TagCreator.li().withClasses(new String[]{"pb-1", (String)TagCreator.iff((boolean)hasViolations, (Object)"error")})).with(new DomContent[]{((ContainerTag)TagCreator.a().withClass("mr-2")).with(HtmlReport.wrap(edge.isIgnored(), TagCreator::del, new DomContent[]{TagCreator.text((String)edge.getTo().getName())})), (DomContent)TagCreator.iff((boolean)hasViolations, (Object)TagCreator.span((DomContent[])new DomContent[]{TagCreator.text((String)" "), TagCreator.i().withClass("bi bi-exclamation-triangle-fill"), TagCreator.text((String)toViolations.stream().collect(Collectors.joining(", ", " (", ")")))})), ((ContainerTag)TagCreator.ul().withClass("class-references list-unstyled")).with(graph.containingClassEdges((Edge)edge).stream().sorted().map(classEdge -> TagCreator.li((DomContent[])HtmlReport.wrap(classEdge.isIgnored(), TagCreator::del, new DomContent[]{((ContainerTag)((ContainerTag)TagCreator.span().withClass("class-node")).withData("name", classEdge.getFrom().getName())).withText(classEdge.getFrom().getName()), TagCreator.rawHtml((String)" &rarr;&nbsp;"), ((ContainerTag)((ContainerTag)TagCreator.span().withClass("class-node")).withData("name", classEdge.getTo().getName())).withText(classEdge.getTo().getName())}))))});
        });
    }

    private static DomContent[] wrap(boolean condition, Function<DomContent[], DomContent> wrapper, DomContent ... contents) {
        DomContent[] domContentArray;
        if (condition) {
            DomContent[] domContentArray2 = new DomContent[1];
            domContentArray = domContentArray2;
            domContentArray2[0] = wrapper.apply(contents);
        } else {
            domContentArray = contents;
        }
        return domContentArray;
    }

    private static class SliceComparator
    implements Comparator<String> {
        private SliceComparator() {
        }

        @Override
        public int compare(String slice1, String slice2) {
            if ("Package".equals(slice1)) {
                return -1;
            }
            if ("Package".equals(slice2)) {
                return 1;
            }
            return slice1.compareTo(slice2);
        }
    }
}

