/*
 * Decompiled with CFR 0.152.
 */
package de.obqo.decycle.check;

import com.google.common.base.Preconditions;
import de.obqo.decycle.check.Constraint;
import de.obqo.decycle.graph.MutableSlicing;
import de.obqo.decycle.graph.Slicing;
import de.obqo.decycle.graph.SlicingSource;
import de.obqo.decycle.graph.StronglyConnectedComponentsFinder;
import de.obqo.decycle.model.Edge;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public class CycleFree
implements Constraint {
    @Override
    public String getShortString() {
        return "no cycles";
    }

    @Override
    public List<Constraint.Violation> violations(SlicingSource slicingSource) {
        ArrayList<Constraint.Violation> list = new ArrayList<Constraint.Violation>();
        for (String sliceType : slicingSource.sliceTypes()) {
            if ("Class".equals(sliceType)) continue;
            for (Set<Edge> comp : StronglyConnectedComponentsFinder.findComponents(slicingSource.slicing(sliceType))) {
                MutableSlicing violatingSubgraph = MutableSlicing.create(sliceType, comp);
                this.identifyViolations(violatingSubgraph);
                list.add(new Constraint.Violation(this.getShortString(), violatingSubgraph));
            }
        }
        return list;
    }

    private void identifyViolations(Slicing subgraph) {
        Preconditions.checkState((!subgraph.edges().isEmpty() ? 1 : 0) != 0);
        subgraph.edges().stream().min(Comparator.comparing(Edge::getWeight).thenComparing(Edge::displayString)).ifPresent(Edge::setViolating);
        StronglyConnectedComponentsFinder.findComponents(subgraph).forEach(edges -> this.identifyViolations(MutableSlicing.create(subgraph.getSliceType(), edges)));
    }
}

