/*
 * Decompiled with CFR 0.152.
 */
package de.obqo.decycle.model;

import java.util.Comparator;
import lombok.NonNull;

public final class Node
implements Comparable<Node> {
    public static final String CLASS = "Class";
    public static final String PACKAGE = "Package";
    public static final Comparator<Node> COMPARATOR = Comparator.comparing(Node::getName);
    @NonNull
    private final String type;
    @NonNull
    private final String name;

    public static Node classNode(String name) {
        return new Node(CLASS, name);
    }

    public static Node packageNode(String name) {
        return new Node(PACKAGE, name);
    }

    public static Node sliceNode(String type, String name) {
        return new Node(type, name);
    }

    public boolean hasType(String type) {
        return type.equals(this.type);
    }

    public String displayString() {
        return this.name;
    }

    @Override
    public int compareTo(Node other) {
        return COMPARATOR.compare(this, other);
    }

    @NonNull
    public String getType() {
        return this.type;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Node)) {
            return false;
        }
        Node other = (Node)o;
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "Node(type=" + this.getType() + ", name=" + this.getName() + ")";
    }

    private Node(@NonNull String type, @NonNull String name) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.type = type;
        this.name = name;
    }
}

